/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.FileSystemSelectionArea;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class CreateLinkedResourceGroup {
    private Listener listener;
    private String linkTarget = "";
    private int type;
    private boolean createLink = false;
    private FontMetrics fontMetrics;
    private Composite groupComposite;
    private Text linkTargetField;
    private Button browseButton;
    private Button variablesButton;
    private Label resolvedPathLabelText;
    private Label resolvedPathLabelData;
    private final IStringValue updatableResourceName;
    private String lastUpdatedValue;
    private FileSystemSelectionArea fileSystemSelectionArea;

    public CreateLinkedResourceGroup(int n, Listener listener, IStringValue iStringValue) {
        this.type = n;
        this.listener = listener;
        this.updatableResourceName = iStringValue;
        if (iStringValue != null) {
            this.lastUpdatedValue = iStringValue.getValue();
        }
    }

    public Composite createContents(Composite composite) {
        Font font = composite.getFont();
        this.initializeDialogUnits((Control)composite);
        this.groupComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        this.groupComposite.setLayout((Layout)gridLayout);
        this.groupComposite.setLayoutData((Object)new GridData(784));
        this.groupComposite.setFont(font);
        final Button button = new Button(this.groupComposite, 32);
        if (this.type == 1) {
            button.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_linkFileButton);
        } else {
            button.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_linkFolderButton);
        }
        button.setSelection(this.createLink);
        button.setFont(font);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CreateLinkedResourceGroup.this.createLink = button.getSelection();
                CreateLinkedResourceGroup.this.browseButton.setEnabled(CreateLinkedResourceGroup.this.createLink);
                CreateLinkedResourceGroup.this.variablesButton.setEnabled(CreateLinkedResourceGroup.this.createLink);
                CreateLinkedResourceGroup.this.linkTargetField.setEnabled(CreateLinkedResourceGroup.this.createLink);
                if (CreateLinkedResourceGroup.this.fileSystemSelectionArea != null) {
                    CreateLinkedResourceGroup.this.fileSystemSelectionArea.setEnabled(CreateLinkedResourceGroup.this.createLink);
                }
                if (CreateLinkedResourceGroup.this.listener != null) {
                    CreateLinkedResourceGroup.this.listener.handleEvent(new Event());
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        this.createLinkLocationGroup(this.groupComposite, this.createLink);
        return this.groupComposite;
    }

    private void createLinkLocationGroup(Composite composite, boolean bl) {
        Button button = new Button(composite, 32);
        int n = button.computeSize((int)-1, (int)-1).x;
        button.dispose();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = n;
        composite2.setLayoutData((Object)gridData);
        this.linkTargetField = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 2;
        this.linkTargetField.setLayoutData((Object)gridData);
        this.linkTargetField.setEnabled(bl);
        this.linkTargetField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Path path;
                String string;
                String string2;
                CreateLinkedResourceGroup.this.linkTarget = CreateLinkedResourceGroup.this.linkTargetField.getText();
                CreateLinkedResourceGroup.this.resolveVariable();
                if (CreateLinkedResourceGroup.this.updatableResourceName != null && ((string2 = CreateLinkedResourceGroup.this.updatableResourceName.getValue()) == null || string2.equals("") || string2.equals(CreateLinkedResourceGroup.this.lastUpdatedValue)) && (string = (path = new Path(CreateLinkedResourceGroup.this.linkTarget)).lastSegment()) != null) {
                    CreateLinkedResourceGroup.this.lastUpdatedValue = string;
                    CreateLinkedResourceGroup.this.updatableResourceName.setValue(string);
                }
                if (CreateLinkedResourceGroup.this.listener != null) {
                    CreateLinkedResourceGroup.this.listener.handleEvent(new Event());
                }
            }
        });
        this.browseButton = new Button(composite2, 8);
        this.browseButton.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CreateLinkedResourceGroup.this.handleLinkTargetBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(bl);
        this.setButtonLayoutData(this.browseButton);
        this.variablesButton = new Button(composite2, 8);
        this.variablesButton.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_variablesButton);
        this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CreateLinkedResourceGroup.this.handleVariablesButtonPressed();
            }
        });
        this.variablesButton.setEnabled(bl);
        this.setButtonLayoutData(this.variablesButton);
        this.createFileSystemSelection(composite2, bl);
        this.createResolvedPathGroup(composite, n);
        if (this.linkTarget != null) {
            this.linkTargetField.setText(this.linkTarget);
        }
    }

    private void createFileSystemSelection(Composite composite, boolean bl) {
        if (FileSystemSupportRegistry.getInstance().hasOneFileSystem()) {
            return;
        }
        this.fileSystemSelectionArea = new FileSystemSelectionArea();
        this.fileSystemSelectionArea.createContents(composite);
        this.fileSystemSelectionArea.setEnabled(bl);
    }

    private void createResolvedPathGroup(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = n;
        composite2.setLayoutData((Object)gridData);
        this.resolvedPathLabelText = new Label(composite2, 4);
        this.resolvedPathLabelText.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_resolvedPathLabel);
        this.resolvedPathLabelText.setVisible(false);
        this.resolvedPathLabelData = new Label(composite2, 4);
        gridData = new GridData(768);
        this.resolvedPathLabelData.setLayoutData((Object)gridData);
        this.resolvedPathLabelData.setVisible(false);
    }

    private IStatus createStatus(int n, String string) {
        return new Status(n, IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), n, string, null);
    }

    public void dispose() {
        if (this.groupComposite != null && !this.groupComposite.isDisposed()) {
            this.groupComposite.dispose();
        }
    }

    public URI getLinkTargetURI() {
        FileSystemConfiguration fileSystemConfiguration;
        if (!this.createLink) {
            return null;
        }
        Path path = new Path(this.linkTarget);
        if (!path.isAbsolute()) {
            URI uRI;
            fileSystemConfiguration = this.updatableResourceName.getProject() != null ? this.updatableResourceName.getProject().getPathVariableManager() : ResourcesPlugin.getWorkspace().getPathVariableManager();
            URI uRI2 = URIUtil.toURI((IPath)path);
            if (uRI2 != (uRI = fileSystemConfiguration.resolveURI(uRI2))) {
                return uRI2;
            }
        }
        if ((fileSystemConfiguration = this.getSelectedConfiguration()) == null) {
            return URIUtil.toURI((String)this.linkTarget);
        }
        return fileSystemConfiguration.getContributor().getURI(this.linkTarget);
    }

    private void handleLinkTargetBrowseButtonPressed() {
        boolean bl;
        IFileStore iFileStore = null;
        String string = null;
        FileSystemConfiguration fileSystemConfiguration = this.getSelectedConfiguration();
        boolean bl2 = bl = fileSystemConfiguration == null || FileSystemSupportRegistry.getInstance().getDefaultConfiguration().equals(fileSystemConfiguration);
        if (this.linkTarget.length() > 0 && !(iFileStore = IDEResourceInfoUtils.getFileStore(this.linkTarget)).fetchInfo().exists()) {
            iFileStore = null;
        }
        if (this.type == 1) {
            if (bl) {
                FileDialog fileDialog = new FileDialog(this.linkTargetField.getShell());
                fileDialog.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_targetSelectionTitle);
                if (iFileStore != null) {
                    if (iFileStore.fetchInfo().isDirectory()) {
                        fileDialog.setFilterPath(this.linkTarget);
                    } else {
                        fileDialog.setFileName(this.linkTarget);
                    }
                }
                string = fileDialog.open();
            } else {
                URI uRI = fileSystemConfiguration.getContributor().browseFileSystem(this.linkTarget, this.linkTargetField.getShell());
                if (uRI != null) {
                    string = uRI.toString();
                }
            }
        } else {
            Object object;
            String string2 = null;
            if (iFileStore != null) {
                object = iFileStore;
                if (!iFileStore.fetchInfo().isDirectory()) {
                    object = iFileStore.getParent();
                }
                if (object != null) {
                    string2 = iFileStore.toString();
                }
            }
            if (bl) {
                object = new DirectoryDialog(this.linkTargetField.getShell());
                object.setMessage(IDEWorkbenchMessages.CreateLinkedResourceGroup_targetSelectionLabel);
                if (string2 != null) {
                    object.setFilterPath(string2);
                }
                string = object.open();
            } else {
                URI uRI;
                object = "";
                if (string2 != null) {
                    object = string2;
                }
                if ((uRI = fileSystemConfiguration.getContributor().browseFileSystem((String)object, this.linkTargetField.getShell())) != null) {
                    string = uRI.toString();
                }
            }
        }
        if (string != null) {
            this.linkTargetField.setText(string);
        }
    }

    private FileSystemConfiguration getSelectedConfiguration() {
        if (this.fileSystemSelectionArea == null) {
            return null;
        }
        return this.fileSystemSelectionArea.getSelectedConfiguration();
    }

    private void handleVariablesButtonPressed() {
        String[] stringArray;
        int n = 2;
        if (this.type == 1) {
            n |= 1;
        }
        PathVariableSelectionDialog pathVariableSelectionDialog = new PathVariableSelectionDialog(this.linkTargetField.getShell(), n);
        pathVariableSelectionDialog.setProject(this.updatableResourceName.getProject());
        if (pathVariableSelectionDialog.open() == 0 && (stringArray = (String[])pathVariableSelectionDialog.getResult()) != null && stringArray.length == 1) {
            this.linkTargetField.setText(stringArray[0]);
        }
    }

    protected void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        this.fontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    private void resolveVariable() {
        Path path = new Path(this.linkTarget);
        IPathVariableManager iPathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath iPath = iPathVariableManager.resolvePath((IPath)path);
        if (path.equals((Object)iPath)) {
            this.resolvedPathLabelText.setVisible(false);
            this.resolvedPathLabelData.setVisible(false);
        } else {
            this.resolvedPathLabelText.setVisible(true);
            this.resolvedPathLabelData.setVisible(true);
        }
        this.resolvedPathLabelData.setText(iPath.toOSString());
    }

    private GridData setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
        return gridData;
    }

    public void setLinkTarget(String string) {
        this.linkTarget = string;
        if (this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            this.linkTargetField.setText(string);
        }
    }

    private IStatus validateFileType(IFileInfo iFileInfo) {
        if (this.type == 1 && iFileInfo.isDirectory()) {
            return this.createStatus(4, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkTargetNotFile);
        }
        if (this.type == 2 && !iFileInfo.isDirectory()) {
            return this.createStatus(4, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkTargetNotFolder);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateLinkLocation(IResource iResource) {
        Object object;
        if (this.linkTargetField == null || this.linkTargetField.isDisposed() || !this.createLink) {
            if (iResource.getParent().isGroup()) {
                return this.createStatus(4, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkRequiredUnderAGroup);
            }
            return Status.OK_STATUS;
        }
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        FileSystemConfiguration fileSystemConfiguration = this.getSelectedConfiguration();
        if ((fileSystemConfiguration == null || "file".equals(fileSystemConfiguration.getScheme())) && (object = new Path(this.linkTarget)).isUNC()) {
            return this.createStatus(2, IDEWorkbenchMessages.CreateLinkedResourceGroup_unableToValidateLinkTarget);
        }
        object = this.getLinkTargetURI();
        if (object == null) {
            return this.createStatus(2, IDEWorkbenchMessages.CreateLinkedResourceGroup_unableToValidateLinkTarget);
        }
        IStatus iStatus = iWorkspace.validateLinkLocationURI(iResource, (URI)object);
        if (iStatus.getSeverity() == 4 || this.linkTarget.trim().equals("")) {
            return iStatus;
        }
        IPathVariableManager iPathVariableManager = this.updatableResourceName.getProject() != null ? this.updatableResourceName.getProject().getPathVariableManager() : iWorkspace.getPathVariableManager();
        URI uRI = iPathVariableManager.resolveURI((URI)object);
        if (uRI.getScheme() == null) {
            return this.createStatus(2, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkTargetNonExistent);
        }
        IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(uRI);
        if (iFileInfo != null && iFileInfo.exists()) {
            IStatus iStatus2 = this.validateFileType(iFileInfo);
            if (!iStatus2.isOK()) {
                return iStatus2;
            }
        } else if (iStatus.isOK()) {
            return this.createStatus(2, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkTargetNonExistent);
        }
        return iStatus;
    }

    public static interface IStringValue {
        public void setValue(String var1);

        public String getValue();

        public IProject getProject();
    }
}

