/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.IFileStoreFilter;

public class FileFolderSelectionDialog
extends ElementTreeSelectionDialog {
    public FileFolderSelectionDialog(Shell shell, boolean bl, int n) {
        super(shell, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider((n & 1) != 0));
        this.setComparator(new FileViewerSorter());
        this.setValidator(new FileSelectionValidator(bl, (n & 2) != 0));
    }

    private static class FileContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private IFileStoreFilter fileFilter;

        public FileContentProvider(boolean bl) {
            this.fileFilter = new IFileStoreFilter(this, bl){
                final /* synthetic */ FileContentProvider this$1;
                private final /* synthetic */ boolean val$showFiles;
                {
                    this.this$1 = fileContentProvider;
                    this.val$showFiles = bl;
                }

                public boolean accept(IFileStore iFileStore) {
                    return iFileStore.fetchInfo().isDirectory() || this.val$showFiles;
                }
            };
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray;
            if (object instanceof IFileStore && (objectArray = IDEResourceInfoUtils.listFileStores((IFileStore)object, this.fileFilter, (IProgressMonitor)new NullProgressMonitor())) != null) {
                return objectArray;
            }
            return EMPTY;
        }

        public Object getParent(Object object) {
            if (object instanceof IFileStore) {
                return ((IFileStore)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        private FileLabelProvider() {
        }

        public Image getImage(Object object) {
            if (object instanceof IFileStore) {
                IFileStore iFileStore = (IFileStore)object;
                if (iFileStore.fetchInfo().isDirectory()) {
                    return IMG_FOLDER;
                }
                return IMG_FILE;
            }
            return null;
        }

        public String getText(Object object) {
            if (object instanceof IFileStore) {
                return ((IFileStore)object).getName();
            }
            return super.getText(object);
        }
    }

    private static class FileSelectionValidator
    implements ISelectionStatusValidator {
        private boolean multiSelect;
        private boolean acceptFolders;

        public FileSelectionValidator(boolean bl, boolean bl2) {
            this.multiSelect = bl;
            this.acceptFolders = bl2;
        }

        public IStatus validate(Object[] objectArray) {
            int n = objectArray.length;
            String string = "org.eclipse.ui.ide";
            if (n == 0 || n > 1 && !this.multiSelect) {
                return new Status(4, string, 4, "", null);
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                if (object instanceof IFileStore) {
                    IFileStore iFileStore = (IFileStore)object;
                    if (!this.acceptFolders && iFileStore.fetchInfo().isDirectory()) {
                        return new Status(4, string, 4, "", null);
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private static class FileViewerSorter
    extends ViewerComparator {
        private FileViewerSorter() {
        }

        public int category(Object object) {
            if (object instanceof IFileStore && !((IFileStore)object).fetchInfo().isDirectory()) {
                return 1;
            }
            return 0;
        }
    }
}

