/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class FileStatesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static final int FAILED_VALUE = -1;
    private static final long DAY_LENGTH = 86400000L;
    private static final long MEGABYTES = 0x100000L;
    private Text longevityText;
    private Text maxStatesText;
    private Text maxStateSizeText;
    private int FILE_STATES_MAXIMUM = 10000;
    private long STATE_SIZE_MAXIMUM = 100L;

    private Text addLabelAndText(String string, String string2, Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        Text text = new Text(composite, 18432);
        GridData gridData = new GridData();
        text.addListener(24, (Listener)this);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)gridData);
        text.setText(string2);
        return text;
    }

    private void checkState() {
        if (this.longevityText == null || this.maxStatesText == null || this.maxStateSizeText == null) {
            this.setValid(false);
            return;
        }
        if (this.validateLongTextEntry(this.longevityText) == -1L) {
            this.setValid(false);
            return;
        }
        if (this.validateMaxFileStates() == -1) {
            this.setValid(false);
            return;
        }
        if (this.validateMaxFileStateSize() == -1L) {
            this.setValid(false);
            return;
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    protected Control createContents(Composite composite) {
        long l;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.file_states_preference_page_context");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        IWorkspaceDescription iWorkspaceDescription = this.getWorkspaceDescription();
        long l2 = iWorkspaceDescription.getFileStateLongevity() / 86400000L;
        if (l2 < 1L) {
            l2 = 1L;
        }
        if ((l = iWorkspaceDescription.getMaxFileStateSize() / 0x100000L) < 1L) {
            l = 1L;
        }
        this.longevityText = this.addLabelAndText(IDEWorkbenchMessages.FileHistory_longevity, String.valueOf(l2), composite2);
        this.maxStatesText = this.addLabelAndText(IDEWorkbenchMessages.FileHistory_entries, String.valueOf(iWorkspaceDescription.getMaxFileStates()), composite2);
        this.maxStateSizeText = this.addLabelAndText(IDEWorkbenchMessages.FileHistory_diskSpace, String.valueOf(l), composite2);
        this.checkState();
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite3 = this.createNoteComposite(composite.getFont(), composite2, IDEWorkbenchMessages.Preference_note, IDEWorkbenchMessages.FileHistory_restartNote);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData2);
        this.applyDialogFont(composite2);
        return composite2;
    }

    private IWorkspaceDescription getWorkspaceDescription() {
        return ResourcesPlugin.getWorkspace().getDescription();
    }

    public void handleEvent(Event event) {
        this.checkState();
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        long l = preferences.getDefaultLong("description.filestatelongevity") / 86400000L;
        long l2 = preferences.getDefaultLong("description.maxfilestatesize") / 0x100000L;
        this.longevityText.setText(String.valueOf(l));
        this.maxStatesText.setText(preferences.getDefaultString("description.maxfilestates"));
        this.maxStateSizeText.setText(String.valueOf(l2));
        this.checkState();
    }

    public boolean performOk() {
        long l = this.validateLongTextEntry(this.longevityText);
        int n = this.validateMaxFileStates();
        long l2 = this.validateMaxFileStateSize();
        if (l == -1L || n == -1 || l2 == -1L) {
            return false;
        }
        IWorkspaceDescription iWorkspaceDescription = this.getWorkspaceDescription();
        iWorkspaceDescription.setFileStateLongevity(l * 86400000L);
        iWorkspaceDescription.setMaxFileStates(n);
        iWorkspaceDescription.setMaxFileStateSize(l2 * 0x100000L);
        try {
            ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.FileHistory_exceptionSaving, (String)coreException.getMessage(), (IStatus)coreException.getStatus());
            return false;
        }
        return true;
    }

    private int validateIntegerTextEntry(Text text) {
        int n;
        try {
            n = Integer.parseInt(text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(MessageFormat.format((String)IDEWorkbenchMessages.FileHistory_invalid, (Object[])new Object[]{numberFormatException.getLocalizedMessage()}));
            return -1;
        }
        if (n <= 0) {
            this.setErrorMessage(IDEWorkbenchMessages.FileHistory_mustBePositive);
            return -1;
        }
        return n;
    }

    private long validateLongTextEntry(Text text) {
        long l;
        try {
            l = Long.parseLong(text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(MessageFormat.format((String)IDEWorkbenchMessages.FileHistory_invalid, (Object[])new Object[]{numberFormatException.getLocalizedMessage()}));
            return -1L;
        }
        if (l <= 0L) {
            this.setErrorMessage(IDEWorkbenchMessages.FileHistory_mustBePositive);
            return -1L;
        }
        return l;
    }

    private int validateMaxFileStates() {
        int n = this.validateIntegerTextEntry(this.maxStatesText);
        if (n == -1) {
            return n;
        }
        if (n > this.FILE_STATES_MAXIMUM) {
            this.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.FileHistory_aboveMaxEntries, (Object)String.valueOf(this.FILE_STATES_MAXIMUM)));
            return -1;
        }
        return n;
    }

    private long validateMaxFileStateSize() {
        long l = this.validateLongTextEntry(this.maxStateSizeText);
        if (l == -1L) {
            return l;
        }
        if (l > this.STATE_SIZE_MAXIMUM) {
            this.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.FileHistory_aboveMaxFileSize, (Object)String.valueOf(this.STATE_SIZE_MAXIMUM)));
            return -1L;
        }
        return l;
    }
}

