/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.internal.ide.misc.CompoundFilter;

class FilterCopy
implements IFilter {
    static String EMPTY = "";
    String arguments = EMPTY;
    String id = null;
    IPath path = null;
    IProject project = null;
    int type = 0;
    FilterCopy parent = null;
    LinkedList children = null;
    IFilter original = null;
    int serialNumber = ++lastSerialNumber;
    private static int lastSerialNumber = 0;

    public FilterCopy(IFilter iFilter) {
        this.internalCopy(iFilter);
        this.original = iFilter;
    }

    public void setParent(FilterCopy filterCopy) {
        this.parent = filterCopy;
    }

    public boolean canAcceptDrop() {
        int n = this.getChildrenLimit();
        if (n > 0) {
            FilterCopy[] filterCopyArray = this.getChildren();
            return filterCopyArray == null || filterCopyArray.length < n;
        }
        return false;
    }

    public boolean hasParent(FilterCopy filterCopy) {
        FilterCopy filterCopy2 = this;
        do {
            if (!filterCopy2.equals(filterCopy)) continue;
            return true;
        } while ((filterCopy2 = filterCopy2.getParent()) != null);
        return false;
    }

    public FilterCopy getParent() {
        return this.parent;
    }

    public void copy(IFilter iFilter) {
        this.internalCopy(iFilter);
        this.argumentsChanged();
    }

    private void internalCopy(IFilter iFilter) {
        this.children = null;
        this.arguments = iFilter.getArguments();
        this.id = iFilter.getId();
        this.path = iFilter.getPath();
        this.project = iFilter.getProject();
        this.type = iFilter.getType();
        if (this.arguments == null) {
            this.arguments = EMPTY;
        }
    }

    public boolean hasChanged() {
        if (this.original != null) {
            return !(this.arguments == null ? this.original.getArguments() == null : this.arguments.equals(this.original.getArguments())) || !this.id.equals(this.original.getId()) || this.type != this.original.getType();
        }
        return true;
    }

    public FilterCopy() {
        this.path = null;
        this.project = null;
        this.type = 5;
        this.id = FilterTypeUtil.getDefaultFilterID();
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getId() {
        return this.id;
    }

    public IPath getPath() {
        return this.path;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getType() {
        return this.type;
    }

    public void setArguments(String string) {
        this.arguments = string;
        this.argumentsChanged();
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setPath(IPath iPath) {
        this.path = iPath;
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean hasStringArguments() {
        FilterTypeManager.Descriptor descriptor = FilterTypeUtil.getDescriptor(this.id);
        if (descriptor != null) {
            return descriptor.getArgumentType().equals("string");
        }
        return false;
    }

    public int getChildrenLimit() {
        FilterTypeManager.Descriptor descriptor = FilterTypeUtil.getDescriptor(this.id);
        if (descriptor != null) {
            if (descriptor.getArgumentType().equals("filter")) {
                return 1;
            }
            if (descriptor.getArgumentType().equals("filters")) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterCopy)) {
            return false;
        }
        FilterCopy filterCopy = (FilterCopy)object;
        return this.serialNumber == filterCopy.serialNumber;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public FilterCopy findBySerialNumber(int n) {
        LinkedList<FilterCopy> linkedList = new LinkedList<FilterCopy>();
        linkedList.add(this);
        while (!linkedList.isEmpty()) {
            FilterCopy filterCopy = (FilterCopy)linkedList.getFirst();
            linkedList.removeFirst();
            if (filterCopy.serialNumber == n) {
                return filterCopy;
            }
            FilterCopy[] filterCopyArray = filterCopy.getChildren();
            if (filterCopyArray == null) continue;
            linkedList.addAll(Arrays.asList(filterCopyArray));
        }
        return null;
    }

    public FilterCopy[] getChildren() {
        if (this.getChildrenLimit() > 0) {
            this.initializeChildren();
            return this.children.toArray(new FilterCopy[0]);
        }
        return null;
    }

    protected void initializeChildren() {
        if (this.children == null && this.getChildrenLimit() > 0) {
            this.children = new LinkedList();
            IFilter[] iFilterArray = CompoundFilter.unserialize(this.getProject(), this.getArguments());
            int n = 0;
            while (n < iFilterArray.length) {
                FilterCopy filterCopy = new FilterCopy(iFilterArray[n]);
                filterCopy.parent = this;
                this.children.add(filterCopy);
                ++n;
            }
        }
    }

    public void addChild(FilterCopy filterCopy) {
        this.initializeChildren();
        if (filterCopy.getParent() != null) {
            filterCopy.getParent().removeChild(filterCopy);
        }
        this.children.add(filterCopy);
        filterCopy.parent = this;
        this.serializeChildren();
    }

    public void removeChild(FilterCopy filterCopy) {
        this.initializeChildren();
        this.children.remove(filterCopy);
        if (filterCopy.parent == this) {
            filterCopy.parent = null;
        }
        this.serializeChildren();
    }

    protected void serializeChildren() {
        this.initializeChildren();
        this.argumentsChanged();
    }

    protected void argumentsChanged() {
        this.initializeChildren();
        if (this.children != null) {
            this.arguments = CompoundFilter.serialize(this.children.toArray(new FilterCopy[0]));
        }
        FilterCopy filterCopy = this.parent;
        while (filterCopy != null) {
            filterCopy.serializeChildren();
            filterCopy = filterCopy.parent;
        }
    }

    public boolean isUnderAGroupFilter() {
        return this.parent != null && this.parent.getChildrenLimit() > 0 && this.parent.getParent() != null;
    }
}

