/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;

class FilterEditDialog
extends TrayDialog {
    private FilterCopy filter;
    protected Button includeButton;
    protected Button excludeButton;
    protected Button filesButton;
    protected Button foldersButton;
    protected Button filesAndFoldersButton;
    protected Combo idCombo;
    protected Button inherited;
    protected Text arguments;
    protected Label description;
    protected FilterTypeUtil util;

    public FilterEditDialog(Shell shell, FilterCopy filterCopy) {
        super(shell);
        this.filter = filterCopy;
        this.util = new FilterTypeUtil();
    }

    protected Control createDialogArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.ui.ide.edit_resource_filter_property_page_context");
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(16384, 0x1000000, true, false);
        composite3.setLayoutData((Object)gridData);
        composite3.setFont(font);
        this.createModeArea(font, composite3);
        this.createTargetArea(font, composite3);
        this.createIdArea(font, composite2);
        return composite2;
    }

    private void createInheritableArea(Font font, Composite composite) {
        if (!this.filter.isUnderAGroupFilter()) {
            this.inherited = new Button(composite, 32);
            this.inherited.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterInheritable, null));
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = 1;
            this.inherited.setLayoutData((Object)gridData);
            this.inherited.setFont(font);
            this.inherited.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.INHERITABLE, new Boolean(FilterEditDialog.this.inherited.getSelection()));
                }
            });
            this.inherited.setSelection(((Boolean)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.INHERITABLE)).booleanValue());
        }
    }

    private void createArgumentsArea(Font font, Composite composite) {
        this.addLabel(composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterArguments, null));
        this.arguments = new Text(composite, 2052);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.arguments.setLayoutData((Object)gridData);
        this.arguments.setFont(font);
        this.arguments.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.ARGUMENTS, FilterEditDialog.this.arguments.getText());
            }
        });
        if (this.filter.hasStringArguments()) {
            this.arguments.setText((String)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.ARGUMENTS));
        }
        this.arguments.setEnabled(this.filter.hasStringArguments());
    }

    private void createDescriptionArea(Font font, Composite composite) {
        this.description = new Label(composite, 16448);
        this.description.setText(FilterTypeUtil.getDescriptor(this.filter.getId()).getDescription());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 300;
        gridData.heightHint = 40;
        this.description.setLayoutData((Object)gridData);
        this.description.setFont(font);
    }

    private void createIdArea(Font font, Composite composite) {
        Group group = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterID, null));
        this.idCombo = new Combo((Composite)group, 8);
        this.idCombo.setItems(FilterTypeUtil.getFilterNames(this.filter.getChildrenLimit() > 0));
        GridData gridData = new GridData(4, 0x1000000, true, true);
        this.idCombo.setLayoutData((Object)gridData);
        this.idCombo.setFont(font);
        this.idCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.ID, FilterEditDialog.this.idCombo.getItem(FilterEditDialog.this.idCombo.getSelectionIndex()));
                FilterEditDialog.this.arguments.setEnabled(FilterEditDialog.this.filter.hasStringArguments());
                FilterEditDialog.this.description.setText(FilterTypeUtil.getDescriptor(FilterEditDialog.this.filter.getId()).getDescription());
            }
        });
        this.idCombo.select(((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.ID)).intValue());
        Composite composite2 = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        this.createArgumentsArea(font, composite2);
        this.createDescriptionArea(font, (Composite)group);
    }

    private void createModeArea(Font font, Composite composite) {
        if (!this.filter.isUnderAGroupFilter()) {
            Group group = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterMode, null));
            String[] stringArray = FilterTypeUtil.getModes();
            this.includeButton = new Button((Composite)group, 16);
            this.includeButton.setText(stringArray[0]);
            this.includeButton.setImage(this.util.getImage(FilterTypeUtil.MODE, 0));
            GridData gridData = new GridData(4, 0x1000000, true, false);
            this.includeButton.setLayoutData((Object)gridData);
            this.includeButton.setFont(font);
            this.includeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.MODE, new Integer(0));
                }
            });
            this.includeButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.MODE) == 0);
            this.excludeButton = new Button((Composite)group, 16);
            this.excludeButton.setText(stringArray[1]);
            this.excludeButton.setImage(this.util.getImage(FilterTypeUtil.MODE, 1));
            gridData = new GridData(4, 0x1000000, true, false);
            this.excludeButton.setLayoutData((Object)gridData);
            this.excludeButton.setFont(font);
            this.excludeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.MODE, new Integer(1));
                }
            });
            this.excludeButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.MODE) == 1);
            this.createInheritableArea(font, (Composite)group);
        } else {
            this.createInheritableArea(font, composite);
        }
    }

    private Group createGroup(Font font, Composite composite, String string) {
        Group group = new Group(composite, 0);
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        group.setLayoutData((Object)gridData);
        group.setFont(font);
        return group;
    }

    private void createTargetArea(Font font, Composite composite) {
        Group group = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterTargets, null));
        String[] stringArray = FilterTypeUtil.getTargets();
        this.filesButton = new Button((Composite)group, 16);
        this.filesButton.setText(stringArray[0]);
        this.filesButton.setImage(this.util.getImage(FilterTypeUtil.TARGET, 0));
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.filesButton.setLayoutData((Object)gridData);
        this.filesButton.setFont(font);
        this.foldersButton = new Button((Composite)group, 16);
        this.foldersButton.setText(stringArray[1]);
        this.foldersButton.setImage(this.util.getImage(FilterTypeUtil.TARGET, 1));
        gridData = new GridData(4, 0x1000000, true, false);
        this.foldersButton.setLayoutData((Object)gridData);
        this.foldersButton.setFont(font);
        this.filesAndFoldersButton = new Button((Composite)group, 16);
        this.filesAndFoldersButton.setText(stringArray[2]);
        this.filesAndFoldersButton.setImage(this.util.getImage(FilterTypeUtil.TARGET, 2));
        gridData = new GridData(4, 0x1000000, true, false);
        this.filesAndFoldersButton.setLayoutData((Object)gridData);
        this.filesAndFoldersButton.setFont(font);
        this.filesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(0));
            }
        });
        this.foldersButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(1));
            }
        });
        this.filesAndFoldersButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(2));
            }
        });
        this.filesButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 0);
        this.foldersButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 1);
        this.filesAndFoldersButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 2);
    }

    void addLabel(Composite composite, String string) {
        String string2 = ":";
        Font font = composite.getFont();
        Label label = new Label(composite, 16384);
        label.setText(String.valueOf(string) + string2);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)gridData);
        label.setFont(font);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.initialize();
        this.update();
        return control;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        shell.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_editFilterDialogTitle, null));
        super.configureShell(shell);
    }

    private void initialize() {
    }

    protected void update() {
    }

    protected void okPressed() {
        super.okPressed();
    }
}

