/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.LinkedList;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IFilter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class FilterTypeUtil {
    static String ID = "id";
    static String TARGET = "target";
    static String MODE = "mode";
    static String ARGUMENTS = "arguments";
    static String INHERITABLE = "inheritable";
    static String[] columnNames = new String[]{MODE, ARGUMENTS, INHERITABLE};
    private Image fileIcon = null;
    private Image folderIcon = null;
    private Image fileFolderIcon = null;
    private Image includeIcon = null;
    private Image excludeIcon = null;

    static String[] getModes() {
        return new String[]{NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_includeOnly, null), NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_excludeAll, null)};
    }

    public static void setValue(FilterCopy filterCopy, String string, Object object) {
        int n;
        if (string.equals(ID)) {
            FilterTypeManager.Descriptor descriptor;
            if (object instanceof Integer) {
                n = (Integer)object;
                descriptor = FilterTypeUtil.getDescriptorFromIndex(n);
            } else {
                descriptor = FilterTypeUtil.getDescriptorByName((String)object);
            }
            if (descriptor != null) {
                filterCopy.setId(descriptor.getId());
            }
        }
        if (string.equals(MODE)) {
            int n2 = (Integer)object;
            n = filterCopy.getType() & 0xFFFFFFFC;
            if (n2 == 0) {
                filterCopy.setType(n | 1);
            } else {
                filterCopy.setType(n | 2);
            }
        }
        if (string.equals(TARGET)) {
            int n3 = (Integer)object;
            n = filterCopy.getType() & 0xFFFFFFF3;
            if (n3 == 0) {
                filterCopy.setType(n | 4);
            }
            if (n3 == 1) {
                filterCopy.setType(n | 8);
            }
            if (n3 == 2) {
                filterCopy.setType(n | 4 | 8);
            }
        }
        if (string.equals(INHERITABLE)) {
            int n4 = filterCopy.getType() & 0xFFFFFFEF;
            if (((Boolean)object).booleanValue()) {
                filterCopy.setType(n4 | 0x10);
            } else {
                filterCopy.setType(n4);
            }
        }
        if (string.equals(ARGUMENTS)) {
            filterCopy.setArguments((String)object);
        }
    }

    static FilterTypeManager.Descriptor getDescriptor(String string) {
        FilterTypeManager.Descriptor[] descriptorArray = FilterTypeManager.getDefault().getDescriptors();
        int n = 0;
        while (n < descriptorArray.length) {
            if (descriptorArray[n].getId().equals(string)) {
                return descriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    static int getDescriptorIndex(String string) {
        FilterTypeManager.Descriptor[] descriptorArray = FilterTypeManager.getDefault().getDescriptors();
        int n = 0;
        while (n < descriptorArray.length) {
            if (descriptorArray[n].getId().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static Object getValue(IFilter iFilter, String string) {
        if (string.equals(ID)) {
            String string2 = iFilter.getId();
            int n = FilterTypeUtil.getDescriptorIndex(string2);
            return new Integer(n);
        }
        if (string.equals(MODE)) {
            if ((iFilter.getType() & 1) != 0) {
                return new Integer(0);
            }
            return new Integer(1);
        }
        if (string.equals(TARGET)) {
            boolean bl;
            boolean bl2 = (iFilter.getType() & 4) != 0;
            boolean bl3 = bl = (iFilter.getType() & 8) != 0;
            if (bl2 && bl) {
                return new Integer(2);
            }
            if (bl2) {
                return new Integer(0);
            }
            if (bl) {
                return new Integer(1);
            }
        }
        if (string.equals(INHERITABLE)) {
            return new Boolean((iFilter.getType() & 0x10) != 0);
        }
        if (string.equals(ARGUMENTS)) {
            return iFilter.getArguments();
        }
        return null;
    }

    static String[] getTargets() {
        return new String[]{NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_files, null), NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_folders, null), NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_filesAndFolders, null)};
    }

    static String[] getFilterNames(boolean bl) {
        FilterTypeManager.Descriptor[] descriptorArray = FilterTypeManager.getDefault().getDescriptors();
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        while (n < descriptorArray.length) {
            if (!bl || descriptorArray[n].getArgumentType().equals("filter") || descriptorArray[n].getArgumentType().equals("filters")) {
                linkedList.add(descriptorArray[n].getName());
            }
            ++n;
        }
        return linkedList.toArray(new String[0]);
    }

    static String getDefaultFilterID() {
        FilterTypeManager.Descriptor[] descriptorArray = FilterTypeManager.getDefault().getDescriptors();
        int n = 0;
        while (n < descriptorArray.length) {
            if (descriptorArray[n].getArgumentType().equals("string")) {
                return descriptorArray[n].getId();
            }
            ++n;
        }
        return descriptorArray[0].getId();
    }

    static FilterTypeManager.Descriptor getDescriptorFromIndex(int n) {
        FilterTypeManager.Descriptor[] descriptorArray = FilterTypeManager.getDefault().getDescriptors();
        return descriptorArray[n];
    }

    static FilterTypeManager.Descriptor getDescriptorByName(String string) {
        FilterTypeManager.Descriptor[] descriptorArray = FilterTypeManager.getDefault().getDescriptors();
        int n = 0;
        while (n < descriptorArray.length) {
            if (descriptorArray[n].getName().equals(string)) {
                return descriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    FilterTypeUtil() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/file.gif");
        if (imageDescriptor != null) {
            this.fileIcon = imageDescriptor.createImage();
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/folder.gif")) != null) {
            this.folderIcon = imageDescriptor.createImage();
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/fileFolder.gif")) != null) {
            this.fileFolderIcon = imageDescriptor.createImage();
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/includeType.gif")) != null) {
            this.includeIcon = imageDescriptor.createImage();
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/excludeType.gif")) != null) {
            this.excludeIcon = imageDescriptor.createImage();
        }
    }

    Image getImage(String string, int n) {
        if (string.equals(MODE)) {
            return (new Image[]{this.includeIcon, this.excludeIcon})[n];
        }
        if (string.equals(TARGET)) {
            return (new Image[]{this.fileIcon, this.folderIcon, this.fileFolderIcon})[n];
        }
        return null;
    }
}

