/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IFileStoreFilter;
import org.eclipse.ui.statushandlers.StatusManager;

public class IDEResourceInfoUtils {
    private static String BYTES_LABEL = IDEWorkbenchMessages.ResourceInfo_bytes;
    public static final String EMPTY_STRING = "";
    private static String FILE_LABEL = IDEWorkbenchMessages.ResourceInfo_file;
    private static String FILE_NOT_EXIST_TEXT = IDEWorkbenchMessages.ResourceInfo_fileNotExist;
    private static String FILE_TYPE_FORMAT = IDEWorkbenchMessages.ResourceInfo_fileTypeFormat;
    private static String FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_folder;
    private static String LINKED_FILE_LABEL = IDEWorkbenchMessages.ResourceInfo_linkedFile;
    private static String LINKED_FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_linkedFolder;
    private static String GROUP_FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_groupFolder;
    private static String GROUP_TEXT = IDEWorkbenchMessages.ResourceInfo_isGroup;
    private static String MISSING_PATH_VARIABLE_TEXT = IDEWorkbenchMessages.ResourceInfo_undefinedPathVariable;
    private static String NOT_EXIST_TEXT = IDEWorkbenchMessages.ResourceInfo_notExist;
    private static String NOT_LOCAL_TEXT = IDEWorkbenchMessages.ResourceInfo_notLocal;
    private static String PROJECT_LABEL = IDEWorkbenchMessages.ResourceInfo_project;
    private static String UNKNOWN_LABEL = IDEWorkbenchMessages.ResourceInfo_unknown;

    public static boolean exists(String string) {
        IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(string);
        if (iFileInfo == null) {
            return false;
        }
        return iFileInfo.exists();
    }

    private static String getContentTypeString(IContentDescription iContentDescription) {
        IContentType iContentType;
        if (iContentDescription != null && (iContentType = iContentDescription.getContentType()) != null) {
            return iContentType.getName();
        }
        return null;
    }

    public static String getDateStringValue(IResource iResource) {
        if (!iResource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        if (!IDEResourceInfoUtils.isProjectAccessible(iResource)) {
            return UNKNOWN_LABEL;
        }
        URI uRI = iResource.getLocationURI();
        if (uRI == null) {
            if (iResource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(uRI);
        if (iFileInfo == null) {
            return UNKNOWN_LABEL;
        }
        if (iFileInfo.exists()) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance((int)1, (int)2);
            return dateFormat.format(new Date(iFileInfo.getLastModified()));
        }
        return NOT_EXIST_TEXT;
    }

    public static IFileInfo getFileInfo(IPath iPath) {
        IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(iPath.toFile().toURI());
        if (iFileStore == null) {
            return null;
        }
        return iFileStore.fetchInfo();
    }

    public static IFileInfo getFileInfo(String string) {
        IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(string);
        if (iFileStore == null) {
            return null;
        }
        return iFileStore.fetchInfo();
    }

    public static IFileInfo getFileInfo(URI uRI) {
        if (uRI.getScheme() == null) {
            return null;
        }
        IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(uRI);
        if (iFileStore == null) {
            return null;
        }
        return iFileStore.fetchInfo();
    }

    public static IFileStore getFileStore(String string) {
        return IDEResourceInfoUtils.getFileStore(new Path(string).toFile().toURI());
    }

    public static IFileStore getFileStore(URI uRI) {
        try {
            return EFS.getStore((URI)uRI);
        }
        catch (CoreException coreException) {
            IDEResourceInfoUtils.log(coreException);
            return null;
        }
    }

    public static String getLocationText(IResource iResource) {
        URI uRI;
        if (iResource.isGroup()) {
            return GROUP_TEXT;
        }
        if (!iResource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        URI uRI2 = uRI = iResource.getLocationURI();
        boolean bl = iResource.isLinked();
        if (bl) {
            uRI2 = iResource.getRawLocationURI();
        }
        if (uRI2 == null) {
            return NOT_EXIST_TEXT;
        }
        if (uRI.getScheme() == null) {
            return uRI2.toString();
        }
        IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(uRI);
        boolean bl2 = IDEResourceInfoUtils.isPathVariable(iResource);
        if (IDEResourceInfoUtils.isProjectAccessible(iResource) && uRI != null && !bl2) {
            if (iFileStore == null) {
                return UNKNOWN_LABEL;
            }
            if (!iFileStore.fetchInfo().exists()) {
                return NLS.bind((String)FILE_NOT_EXIST_TEXT, (Object)iFileStore.toString());
            }
        }
        if (bl && bl2) {
            return iResource.getRawLocationURI().toString();
        }
        if (iFileStore != null) {
            return iFileStore.toString();
        }
        return uRI2.toString();
    }

    public static String getResolvedLocationText(IResource iResource) {
        if (!iResource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        URI uRI = iResource.getLocationURI();
        if (uRI == null) {
            if (iResource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        if (uRI.getScheme() == null) {
            return UNKNOWN_LABEL;
        }
        IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(uRI);
        if (iFileStore == null) {
            return UNKNOWN_LABEL;
        }
        if (IDEResourceInfoUtils.isProjectAccessible(iResource) && !iFileStore.fetchInfo().exists()) {
            return NLS.bind((String)FILE_NOT_EXIST_TEXT, (Object)iFileStore.toString());
        }
        return iFileStore.toString();
    }

    public static String getSizeString(IResource iResource) {
        if (iResource.getType() != 1) {
            return EMPTY_STRING;
        }
        IFile iFile = (IFile)iResource;
        if (!iFile.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        URI uRI = iFile.getLocationURI();
        if (uRI == null) {
            if (iFile.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(uRI);
        if (iFileInfo == null) {
            return UNKNOWN_LABEL;
        }
        if (iFileInfo.exists()) {
            return NLS.bind((String)BYTES_LABEL, (Object)NumberFormat.getInstance().format((Object)new Long(iFileInfo.getLength())));
        }
        return NOT_EXIST_TEXT;
    }

    public static String getTypeString(IResource iResource, IContentDescription iContentDescription) {
        if (iResource.getType() == 1) {
            String string;
            if (iResource.isLinked()) {
                return LINKED_FILE_LABEL;
            }
            if (iResource instanceof IFile && (string = IDEResourceInfoUtils.getContentTypeString(iContentDescription)) != null) {
                return MessageFormat.format((String)FILE_TYPE_FORMAT, (Object[])new String[]{string});
            }
            return FILE_LABEL;
        }
        if (iResource.getType() == 2) {
            if (iResource.isLinked()) {
                return LINKED_FOLDER_LABEL;
            }
            if (iResource.isGroup()) {
                return GROUP_FOLDER_LABEL;
            }
            return FOLDER_LABEL;
        }
        if (iResource.getType() == 4) {
            return PROJECT_LABEL;
        }
        return UNKNOWN_LABEL;
    }

    private static boolean isPathVariable(IResource iResource) {
        if (!iResource.isLinked()) {
            return false;
        }
        URI uRI = iResource.getLocationURI();
        if (uRI == null) {
            return true;
        }
        URI uRI2 = iResource.getRawLocationURI();
        return !uRI.equals(uRI2);
    }

    private static boolean isProjectAccessible(IResource iResource) {
        IProject iProject = iResource.getProject();
        return iProject != null && iProject.isAccessible();
    }

    public static IFileStore[] listFileStores(IFileStore iFileStore, IFileStoreFilter iFileStoreFilter, IProgressMonitor iProgressMonitor) {
        IFileStore[] iFileStoreArray;
        ArrayList<IFileStore> arrayList = new ArrayList<IFileStore>();
        try {
            iFileStoreArray = iFileStore.childStores(0, iProgressMonitor);
        }
        catch (CoreException coreException) {
            IDEResourceInfoUtils.log(coreException);
            return new IFileStore[0];
        }
        int n = 0;
        while (n < iFileStoreArray.length) {
            if (iFileStoreFilter.accept(iFileStoreArray[n])) {
                arrayList.add(iFileStoreArray[n]);
            }
            ++n;
        }
        IFileStore[] iFileStoreArray2 = new IFileStore[arrayList.size()];
        arrayList.toArray(iFileStoreArray2);
        return iFileStoreArray2;
    }

    private static void log(CoreException coreException) {
        StatusManager.getManager().handle(coreException, "org.eclipse.ui.ide");
    }
}

