/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IDEWorkspacePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button autoBuildButton;
    private Button autoSaveAllButton;
    private IntegerFieldEditor saveInterval;
    private Button autoRefreshButton;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineSeparatorEditor;
    private boolean clearUserSettings = false;
    private RadioGroupFieldEditor openReferencesEditor;

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.workspace_preference_page_context");
        Composite composite2 = this.createComposite(composite);
        PreferenceLinkArea preferenceLinkArea = new PreferenceLinkArea(composite2, 0, "org.eclipse.ui.preferencePages.Startup", IDEWorkbenchMessages.IDEWorkspacePreference_relatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData gridData = new GridData(768);
        preferenceLinkArea.getControl().setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData());
        this.createAutoBuildPref(composite2);
        this.createAutoRefreshControls(composite2);
        this.createSaveAllBeforeBuildPref(composite2);
        IDEWorkspacePreferencePage.createSpace(composite2);
        this.createSaveIntervalGroup(composite2);
        IDEWorkspacePreferencePage.createSpace(composite2);
        this.createOpenPrefControls(composite2);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        this.createEncodingEditorControls(composite3);
        this.createLineSeparatorEditorControls(composite3);
        this.applyDialogFont(composite2);
        return composite2;
    }

    private void createOpenPrefControls(Composite composite) {
        String string = "OPEN_REQUIRED_PROJECTS";
        String string2 = IDEWorkbenchMessages.IDEWorkspacePreference_openReferencedProjects;
        String[][] stringArray = new String[][]{{IDEWorkbenchMessages.Always, "always"}, {IDEWorkbenchMessages.Never, "never"}, {IDEWorkbenchMessages.Prompt, "prompt"}};
        this.openReferencesEditor = new RadioGroupFieldEditor(string, string2, 3, stringArray, composite, true);
        this.openReferencesEditor.setPreferenceStore(this.getIDEPreferenceStore());
        this.openReferencesEditor.setPage((DialogPage)this);
        this.openReferencesEditor.load();
    }

    protected void createSaveAllBeforeBuildPref(Composite composite) {
        this.autoSaveAllButton = new Button(composite, 32);
        this.autoSaveAllButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuilding);
        this.autoSaveAllButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuildingToolTip);
        this.autoSaveAllButton.setSelection(this.getIDEPreferenceStore().getBoolean("SAVE_ALL_BEFORE_BUILD"));
    }

    protected void createAutoBuildPref(Composite composite) {
        this.autoBuildButton = new Button(composite, 32);
        this.autoBuildButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuild);
        this.autoBuildButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuildToolTip);
        this.autoBuildButton.setSelection(ResourcesPlugin.getWorkspace().isAutoBuilding());
    }

    private void createSaveIntervalGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 16384);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        this.saveInterval = new IntegerFieldEditor("saveInterval", IDEWorkbenchMessages.WorkbenchPreference_saveInterval, composite2);
        this.saveInterval.setPreferenceStore(this.getIDEPreferenceStore());
        this.saveInterval.setPage((DialogPage)this);
        this.saveInterval.setTextLimit(Integer.toString(9999).length());
        this.saveInterval.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_saveIntervalError, (Object)new Integer(9999)));
        this.saveInterval.setValidateStrategy(0);
        this.saveInterval.setValidRange(1, 9999);
        IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
        long l = iWorkspaceDescription.getSnapshotInterval() / 60000L;
        this.saveInterval.setStringValue(Long.toString(l));
        this.saveInterval.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
                    IDEWorkspacePreferencePage.this.setValid(IDEWorkspacePreferencePage.this.saveInterval.isValid());
                }
            }
        });
    }

    private void createAutoRefreshControls(Composite composite) {
        this.autoRefreshButton = new Button(composite, 32);
        this.autoRefreshButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonText);
        this.autoRefreshButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonToolTip);
        boolean bl = ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("refresh.enabled");
        this.autoRefreshButton.setSelection(bl);
    }

    private void createEncodingEditorControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(768));
        this.encodingEditor = new ResourceEncodingFieldEditor(IDEWorkbenchMessages.WorkbenchPreference_encoding, composite2, (IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
                    IDEWorkspacePreferencePage.this.setValid(IDEWorkspacePreferencePage.this.encodingEditor.isValid());
                }
            }
        });
    }

    private void createLineSeparatorEditorControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.lineSeparatorEditor = new LineDelimiterEditor(composite2);
        this.lineSeparatorEditor.doLoad();
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected static void createSpace(Composite composite) {
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        label.setLayoutData((Object)gridData);
    }

    protected Composite createComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        boolean bl = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("description.autobuilding");
        this.autoBuildButton.setSelection(bl);
        IPreferenceStore iPreferenceStore = this.getIDEPreferenceStore();
        this.autoSaveAllButton.setSelection(iPreferenceStore.getDefaultBoolean("SAVE_ALL_BEFORE_BUILD"));
        this.saveInterval.loadDefault();
        boolean bl2 = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("refresh.enabled");
        this.autoRefreshButton.setSelection(bl2);
        this.clearUserSettings = true;
        List list = WorkbenchEncoding.getDefinedEncodings();
        Collections.sort(list);
        this.encodingEditor.loadDefault();
        this.lineSeparatorEditor.loadDefault();
        this.openReferencesEditor.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
        if (this.autoBuildButton.getSelection() != ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            try {
                iWorkspaceDescription.setAutoBuilding(this.autoBuildButton.getSelection());
                ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
            }
            catch (CoreException coreException) {
                IDEWorkbenchPlugin.log("Error changing auto build workspace setting.", coreException.getStatus());
            }
        }
        IPreferenceStore iPreferenceStore = this.getIDEPreferenceStore();
        iPreferenceStore.setValue("SAVE_ALL_BEFORE_BUILD", this.autoSaveAllButton.getSelection());
        long l = iWorkspaceDescription.getSnapshotInterval() / 60000L;
        long l2 = new Long(this.saveInterval.getStringValue());
        if (l != l2) {
            try {
                iWorkspaceDescription.setSnapshotInterval(l2 * 60000L);
                ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
                iPreferenceStore.firePropertyChangeEvent("saveInterval", (Object)new Integer((int)l), (Object)new Integer((int)l2));
            }
            catch (CoreException coreException) {
                IDEWorkbenchPlugin.log("Error changing save interval preference", coreException.getStatus());
            }
        }
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        boolean bl = this.autoRefreshButton.getSelection();
        preferences.setValue("refresh.enabled", bl);
        if (this.clearUserSettings) {
            IDEEncoding.clearUserEncodings();
        }
        this.encodingEditor.store();
        this.lineSeparatorEditor.store();
        this.openReferencesEditor.store();
        return super.performOk();
    }
}

