/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InternalErrorDialog
extends MessageDialog {
    private Throwable detail;
    private int detailButtonID = -1;
    private Text text;
    private int defaultButtonIndex = 0;
    private static final int TEXT_LINE_COUNT = 15;

    public InternalErrorDialog(Shell shell, String string, Image image, String string2, Throwable throwable, int n, String[] stringArray, int n2) {
        super(shell, string, image, string2, n, stringArray, n2);
        this.defaultButtonIndex = n2;
        this.detail = throwable;
        this.setShellStyle(this.getShellStyle() | 0x10000);
    }

    public int open() {
        this.create();
        Button button = this.getButton(this.defaultButtonIndex);
        button.setFocus();
        button.getShell().setDefaultButton(button);
        return super.open();
    }

    public void setDetailButton(int n) {
        this.detailButtonID = n;
    }

    protected void buttonPressed(int n) {
        if (n == this.detailButtonID) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(n);
        }
    }

    private void toggleDetailsArea() {
        Point point = this.getShell().getSize();
        Point point2 = this.getContents().computeSize(-1, -1);
        if (this.text != null) {
            this.text.dispose();
            this.text = null;
            this.getButton(this.detailButtonID).setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDropDownText((Composite)this.getContents());
            this.getButton(this.detailButtonID).setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point point3 = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(point.x, point.y + (point3.y - point2.y)));
    }

    protected void createDropDownText(Composite composite) {
        ByteArrayOutputStream byteArrayOutputStream;
        this.text = new Text(composite, 2816);
        this.text.setFont(composite.getFont());
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            this.detail.printStackTrace(printStream);
            printStream.flush();
            byteArrayOutputStream.flush();
            this.text.setText(byteArrayOutputStream.toString());
        }
        catch (IOException iOException) {}
        byteArrayOutputStream = new GridData(1808);
        ((GridData)byteArrayOutputStream).heightHint = this.text.getLineHeight() * 15;
        ((GridData)byteArrayOutputStream).horizontalSpan = 2;
        this.text.setLayoutData((Object)byteArrayOutputStream);
    }

    public static boolean openQuestion(Shell shell, String string, String string2, Throwable throwable, int n) {
        String[] stringArray = throwable == null ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        InternalErrorDialog internalErrorDialog = new InternalErrorDialog(shell, string, null, string2, throwable, 3, stringArray, n);
        if (throwable != null) {
            internalErrorDialog.setDetailButton(2);
        }
        return internalErrorDialog.open() == 0;
    }
}

