/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LinkedResourceEditor {
    IResource[] fProjectFiles = null;
    TreeMap fBrokenResources = new TreeMap();
    TreeMap fAbsoluteResources = new TreeMap();
    TreeMap fFixedResources = new TreeMap();
    IProject fProject;
    TreeViewer fTree;
    Button fEditResourceButton;
    Button fConvertAbsoluteButton;
    Image fixedImg = null;
    Image brokenImg = null;
    Image absoluteImg = IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/warning.gif").createImage();
    String FIXED;
    String BROKEN;
    String ABSOLUTE;

    public LinkedResourceEditor() {
        this.brokenImg = IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/error_tsk.gif").createImage();
        this.fixedImg = IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/folder.gif").createImage();
        this.FIXED = IDEWorkbenchMessages.LinkedResourceEditor_fixed;
        this.BROKEN = IDEWorkbenchMessages.LinkedResourceEditor_broken;
        this.ABSOLUTE = IDEWorkbenchMessages.LinkedResourceEditor_absolute;
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    protected void createButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 4;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.fEditResourceButton = this.createButton(composite2, IDEWorkbenchMessages.LinkedResourceEditor_editLinkedLocation);
        this.fEditResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LinkedResourceEditor.this.editLocation();
            }
        });
        this.fConvertAbsoluteButton = this.createButton(composite2, IDEWorkbenchMessages.LinkedResourceEditor_convertToVariableLocation);
        this.fConvertAbsoluteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LinkedResourceEditor.this.convertLocation();
            }
        });
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        this.updateSelection();
    }

    private Button createButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        return button;
    }

    public Control createContents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 9;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fTree = new TreeViewer(composite, 65538);
        this.fTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                LinkedResourceEditor.this.updateSelection();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.fTree.getTree().getItemHeight() * 10;
        gridData.horizontalSpan = 5;
        this.fTree.getTree().setLayoutData((Object)gridData);
        this.fTree.getTree().setLinesVisible(true);
        this.fTree.setContentProvider((IContentProvider)new ContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fTree.setInput((Object)this);
        TreeColumn treeColumn = new TreeColumn(this.fTree.getTree(), 16384, 0);
        treeColumn.setText(IDEWorkbenchMessages.LinkedResourceEditor_resourceName);
        treeColumn.setResizable(true);
        treeColumn.setMoveable(false);
        treeColumn.setWidth(200);
        treeColumn = new TreeColumn(this.fTree.getTree(), 16384, 1);
        treeColumn.setText(IDEWorkbenchMessages.LinkedResourceEditor_path);
        treeColumn.setResizable(true);
        treeColumn.setMoveable(false);
        treeColumn.setWidth(160);
        treeColumn = new TreeColumn(this.fTree.getTree(), 16384, 2);
        treeColumn.setText(IDEWorkbenchMessages.LinkedResourceEditor_location);
        treeColumn.setResizable(true);
        treeColumn.setMoveable(false);
        treeColumn.setWidth(300);
        this.fTree.getTree().setHeaderVisible(true);
        this.createButtons(composite);
        return composite;
    }

    public void dispose() {
        this.fixedImg.dispose();
        this.brokenImg.dispose();
        this.absoluteImg.dispose();
    }

    void refreshContent() {
        if (this.fProjectFiles == null) {
            final LinkedList linkedList = new LinkedList();
            try {
                this.fProject.accept(new IResourceVisitor(){

                    public boolean visit(IResource iResource) throws CoreException {
                        if (iResource.isLinked() && !iResource.isGroup()) {
                            linkedList.add(iResource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
            this.fProjectFiles = linkedList.toArray(new IResource[0]);
        }
        this.fBrokenResources = new TreeMap();
        this.fFixedResources = new TreeMap();
        this.fAbsoluteResources = new TreeMap();
        int n = 0;
        while (n < this.fProjectFiles.length) {
            IResource iResource = this.fProjectFiles[n];
            String string = iResource.getFullPath().toPortableString();
            try {
                if (this.exists(iResource)) {
                    if (this.isAbsolute(iResource)) {
                        this.fAbsoluteResources.put(string, iResource);
                    } else {
                        this.fFixedResources.put(string, iResource);
                    }
                } else {
                    this.fBrokenResources.put(string, iResource);
                }
            }
            catch (CoreException coreException) {
                this.fBrokenResources.put(string, iResource);
            }
            ++n;
        }
    }

    boolean isAbsolute(IResource iResource) {
        IPath iPath = iResource.getRawLocation();
        return iPath != null && iPath.isAbsolute();
    }

    boolean areAbsolute(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            if (!this.isAbsolute(iResourceArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean exists(IResource iResource) throws CoreException {
        URI uRI = iResource.getLocationURI();
        if (uRI != null) {
            IFileStore iFileStore = EFS.getStore((URI)uRI);
            return iFileStore != null && iFileStore.fetchInfo().exists();
        }
        return false;
    }

    void updateSelection() {
        this.fEditResourceButton.setEnabled(this.getSelectedResource().length == 1);
        this.fConvertAbsoluteButton.setEnabled(this.getSelectedResource().length > 0 && (this.areAbsolute(this.getSelectedResource()) || this.areFixed(this.getSelectedResource())));
    }

    boolean areFixed(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            String string = iResourceArray[n].getFullPath().toPortableString();
            if (!this.fFixedResources.containsKey(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    IResource[] getSelectedResource() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTree.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                if (!(objectArray[n] instanceof IResource)) {
                    return new IResource[0];
                }
                ++n;
            }
            IResource[] iResourceArray = new IResource[objectArray.length];
            System.arraycopy(objectArray, 0, iResourceArray, 0, objectArray.length);
            return iResourceArray;
        }
        return new IResource[0];
    }

    private void convertLocation() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        IResource[] iResourceArray = this.getSelectedResource();
        arrayList.addAll(Arrays.asList(iResourceArray));
        if (this.areFixed(iResourceArray)) {
            this.convertToAbsolute(arrayList, iResourceArray);
        } else {
            this.convertToRelative(arrayList, iResourceArray);
        }
    }

    private void convertToAbsolute(ArrayList arrayList, IResource[] iResourceArray) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            IPath iPath = iResource.getLocation();
            try {
                iResource.setLinkLocation(iPath, 0, (IProgressMonitor)new NullProgressMonitor());
                arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{iResource.getProjectRelativePath().toPortableString(), iResource.getRawLocation().toPortableString(), iPath.toPortableString()}));
            }
            catch (CoreException coreException) {
                arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToSetLinkLocationForResource, (Object)iResource.getProjectRelativePath().toPortableString()));
            }
        }
        this.reportResult(iResourceArray, arrayList2, IDEWorkbenchMessages.LinkedResourceEditor_convertRelativePathLocations);
    }

    private void reportResult(IResource[] iResourceArray, ArrayList arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        final String string2 = stringBuffer.toString();
        MessageDialog messageDialog = new MessageDialog(this.fConvertAbsoluteButton.getShell(), string, null, IDEWorkbenchMessages.LinkedResourceEditor_convertionResults, 2, new String[]{IDEWorkbenchMessages.linkedResourceEditor_OK}, 0){

            protected boolean isResizable() {
                return true;
            }

            protected Control createCustomArea(Composite composite) {
                this.setShellStyle(this.getShellStyle() | 0x10);
                Composite composite2 = new Composite(composite, 0);
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                gridLayout.marginLeft = 2;
                gridLayout.numColumns = 1;
                gridLayout.verticalSpacing = 9;
                composite2.setLayout((Layout)gridLayout);
                composite2.setLayoutData((Object)new GridData(1808));
                Text text = new Text(composite2, 2818);
                text.setText(string2.toString());
                GridData gridData = new GridData(640, 300);
                text.setLayoutData((Object)gridData);
                return composite2;
            }
        };
        messageDialog.open();
        this.reparent(iResourceArray);
    }

    private IPath convertToProperCase(IPath iPath) {
        if (Platform.getOS().equals("win32")) {
            return Path.fromPortableString((String)iPath.toPortableString().toLowerCase());
        }
        return iPath;
    }

    private void convertToRelative(ArrayList arrayList, IResource[] iResourceArray) {
        int n;
        int n2;
        int n3;
        Object object;
        IResource iResource;
        IPath[] iPathArray;
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            iPathArray = stringArray.getLocation();
            try {
                IPath iPath = this.fProject.getPathVariableManager().convertToRelative((IPath)iPathArray, true, null);
                if (iPath == null || iPath.equals((Object)iPathArray)) {
                    arrayList3.add(stringArray);
                    continue;
                }
                stringArray.setLinkLocation(iPath, 0, (IProgressMonitor)new NullProgressMonitor());
                arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{stringArray.getProjectRelativePath().toPortableString(), iPathArray.toPortableString(), iPath.toPortableString()}));
            }
            catch (CoreException coreException) {
                arrayList3.add(stringArray);
            }
        }
        arrayList = arrayList3;
        arrayList3 = new ArrayList();
        stringArray = this.fProject.getPathVariableManager().getPathVariableNames();
        iPathArray = new IPath[stringArray.length];
        int n4 = 0;
        while (n4 < stringArray.length) {
            iPathArray[n4] = this.convertToProperCase(this.fProject.getPathVariableManager().resolvePath(Path.fromPortableString((String)stringArray[n4])));
            ++n4;
        }
        iterator = arrayList.iterator();
        n4 = 0;
        while (iterator.hasNext()) {
            iResource = (IResource)iterator.next();
            object = iResource.getLocation();
            int n5 = 0;
            n3 = -1;
            n2 = 0;
            while (n2 < stringArray.length) {
                if (iPathArray[n2].isPrefixOf(this.convertToProperCase((IPath)object)) && (n = object.matchingFirstSegments(iPathArray[n2])) > n5) {
                    n5 = n;
                    n3 = n2;
                }
                ++n2;
            }
            if (n3 != -1) {
                IPath iPath = Path.fromOSString((String)stringArray[n3]).append(object.removeFirstSegments(n5));
                try {
                    iResource.setLinkLocation(iPath, 0, (IProgressMonitor)new NullProgressMonitor());
                    arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{iResource.getProjectRelativePath().toPortableString(), object.toPortableString(), iPath.toPortableString()}));
                }
                catch (CoreException coreException) {
                    n3 = -1;
                }
            }
            if (n3 != -1) continue;
            ++n4;
            arrayList3.add(iResource);
        }
        arrayList = arrayList3;
        if (n4 > 1) {
            iterator = arrayList.iterator();
            iResource = null;
            while (iterator.hasNext()) {
                object = (IResource)iterator.next();
                IPath iPath = object.getLocation();
                if (iResource == null) {
                    iResource = iPath;
                } else {
                    n3 = iResource.matchingFirstSegments(iPath);
                    if (n3 < iResource.segmentCount()) {
                        iResource = iResource.removeLastSegments(iResource.segmentCount() - n3);
                    }
                }
                if (iResource.segmentCount() == 0) break;
            }
            if (iResource.segmentCount() > 1) {
                object = this.getSuitablePathVariable((IPath)iResource);
                try {
                    this.fProject.getPathVariableManager().setValue((String)object, (IPath)iResource);
                }
                catch (CoreException coreException) {
                    arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToCreateVariable, (Object)object, (Object)iResource.toPortableString()));
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    IResource iResource2 = (IResource)iterator.next();
                    IPath iPath = iResource2.getLocation();
                    n2 = iPath.matchingFirstSegments((IPath)iResource);
                    IPath iPath2 = Path.fromOSString((String)object).append(iPath.removeFirstSegments(n2));
                    try {
                        iResource2.setLinkLocation(iPath2, 0, (IProgressMonitor)new NullProgressMonitor());
                        arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{iResource2.getProjectRelativePath().toPortableString(), iPath.toPortableString(), iPath2.toPortableString()}));
                    }
                    catch (CoreException coreException) {
                        arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToSetLinkLocationForResource, (Object)iResource2.getProjectRelativePath().toPortableString()));
                    }
                }
            } else {
                arrayList2.add(IDEWorkbenchMessages.LinkedResourceEditor_unableToFindCommonPathSegments);
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (IResource)iterator.next();
                    arrayList2.add(object.getProjectRelativePath().toPortableString());
                }
            }
        } else if (!arrayList.isEmpty()) {
            iResource = (IResource)arrayList.get(0);
            object = iResource.getLocation();
            IPath iPath = object.removeLastSegments(1);
            String string = this.getSuitablePathVariable(iPath);
            try {
                this.fProject.getPathVariableManager().setValue(string, iPath);
            }
            catch (CoreException coreException) {
                arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToCreateVariable, (Object)string, (Object)iPath.toPortableString()));
            }
            IPath iPath3 = iResource.getLocation();
            n = iPath3.matchingFirstSegments(iPath);
            IPath iPath4 = Path.fromOSString((String)string).append(iPath3.removeFirstSegments(n));
            try {
                iResource.setLinkLocation(iPath4, 0, (IProgressMonitor)new NullProgressMonitor());
                arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{iResource.getProjectRelativePath().toPortableString(), iPath3.toPortableString(), iPath4.toPortableString()}));
            }
            catch (CoreException coreException) {
                arrayList2.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToSetLinkLocationForResource, (Object)iResource.getProjectRelativePath().toPortableString()));
            }
        }
        this.reportResult(iResourceArray, arrayList2, IDEWorkbenchMessages.LinkedResourceEditor_convertAbsolutePathLocations);
    }

    private String getSuitablePathVariable(IPath iPath) {
        String string = iPath.lastSegment();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isLetterOrDigit(c) || c == '_') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('_');
            }
            ++n;
        }
        string = stringBuffer.toString();
        n = 1;
        while (this.fProject.getPathVariableManager().isDefined(string)) {
            string = String.valueOf(string) + n;
            ++n;
        }
        return string;
    }

    void editLocation() {
        IResource iResource = this.getSelectedResource()[0];
        IPath iPath = iResource.getRawLocation();
        PathVariableDialog pathVariableDialog = new PathVariableDialog(this.fConvertAbsoluteButton.getShell(), 3, iResource.getType(), iResource.getProject().getPathVariableManager(), null);
        if (iPath != null) {
            pathVariableDialog.setLinkLocation(iPath);
        }
        pathVariableDialog.setProject(iResource.getProject());
        if (pathVariableDialog.open() == 1) {
            return;
        }
        iPath = Path.fromOSString((String)pathVariableDialog.getVariableValue());
        try {
            iResource.setLinkLocation(iPath, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.reparent(new IResource[]{iResource});
    }

    void reparent(IResource[] iResourceArray) {
        boolean bl = false;
        int n = 0;
        while (n < iResourceArray.length) {
            boolean bl2;
            IResource iResource = iResourceArray[n];
            try {
                bl2 = !this.exists(iResource);
            }
            catch (CoreException coreException) {
                bl2 = true;
            }
            TreeMap treeMap = null;
            treeMap = bl2 ? this.fBrokenResources : (this.isAbsolute(iResource) ? this.fAbsoluteResources : this.fFixedResources);
            String string = iResource.getFullPath().toPortableString();
            if (!treeMap.containsKey(string)) {
                this.fBrokenResources.remove(string);
                this.fAbsoluteResources.remove(string);
                this.fFixedResources.remove(string);
                treeMap.put(string, iResource);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.fTree.refresh();
        }
    }

    public boolean performOk() {
        return true;
    }

    public void setEnabled(boolean bl) {
    }

    public void reloadContent() {
        this.refreshContent();
        this.fTree.refresh();
        this.updateSelection();
        this.fTree.expandAll();
    }

    class ContentProvider
    implements IContentProvider,
    ITreeContentProvider {
        ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof LinkedResourceEditor) {
                return new Object[]{LinkedResourceEditor.this.BROKEN, LinkedResourceEditor.this.ABSOLUTE, LinkedResourceEditor.this.FIXED};
            }
            if (object instanceof String) {
                if (((String)object).equals(LinkedResourceEditor.this.BROKEN)) {
                    return LinkedResourceEditor.this.fBrokenResources.values().toArray();
                }
                if (((String)object).equals(LinkedResourceEditor.this.ABSOLUTE)) {
                    return LinkedResourceEditor.this.fAbsoluteResources.values().toArray();
                }
                return LinkedResourceEditor.this.fFixedResources.values().toArray();
            }
            return null;
        }

        public Object getParent(Object object) {
            if (object instanceof IResource) {
                String string = ((IResource)object).getFullPath().toPortableString();
                if (LinkedResourceEditor.this.fBrokenResources.containsKey(string)) {
                    return LinkedResourceEditor.this.BROKEN;
                }
                if (LinkedResourceEditor.this.fAbsoluteResources.containsKey(string)) {
                    return LinkedResourceEditor.this.ABSOLUTE;
                }
                return LinkedResourceEditor.this.FIXED;
            }
            if (object instanceof String) {
                return this;
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof LinkedResourceEditor) {
                return true;
            }
            if (object instanceof String) {
                if (((String)object).equals(LinkedResourceEditor.this.BROKEN)) {
                    return !LinkedResourceEditor.this.fBrokenResources.isEmpty();
                }
                if (((String)object).equals(LinkedResourceEditor.this.ABSOLUTE)) {
                    return !LinkedResourceEditor.this.fAbsoluteResources.isEmpty();
                }
                return !LinkedResourceEditor.this.fFixedResources.isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object object) {
            if (object instanceof LinkedResourceEditor) {
                return new Object[]{LinkedResourceEditor.this.BROKEN, LinkedResourceEditor.this.ABSOLUTE, LinkedResourceEditor.this.FIXED};
            }
            if (object instanceof String) {
                if (((String)object).equals(LinkedResourceEditor.this.BROKEN)) {
                    return LinkedResourceEditor.this.fBrokenResources.values().toArray();
                }
                if (((String)object).equals(LinkedResourceEditor.this.ABSOLUTE)) {
                    return LinkedResourceEditor.this.fAbsoluteResources.values().toArray();
                }
                return LinkedResourceEditor.this.fFixedResources.values().toArray();
            }
            return null;
        }
    }

    class LabelProvider
    implements ILabelProvider,
    ITableLabelProvider {
        WorkbenchLabelProvider stockProvider = new WorkbenchLabelProvider();

        public String getColumnText(Object object, int n) {
            if (object instanceof IResource) {
                if (n == 0) {
                    return ((IResource)object).getName();
                }
                if (n == 1) {
                    return ((IResource)object).getParent().getProjectRelativePath().toPortableString();
                }
                IPath iPath = ((IResource)object).getRawLocation();
                if (iPath != null) {
                    return iPath.toPortableString();
                }
            } else if (object instanceof String && n == 0) {
                return (String)object;
            }
            return null;
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                if (object instanceof String) {
                    if (object.equals(LinkedResourceEditor.this.BROKEN)) {
                        return LinkedResourceEditor.this.brokenImg;
                    }
                    if (object.equals(LinkedResourceEditor.this.ABSOLUTE)) {
                        return LinkedResourceEditor.this.absoluteImg;
                    }
                    return LinkedResourceEditor.this.fixedImg;
                }
                return this.stockProvider.getImage(object);
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
            this.stockProvider.dispose();
        }

        public boolean isLabelProperty(Object object, String string) {
            return this.stockProvider.isLabelProperty(object, string);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }

        public Image getImage(Object object) {
            return this.getColumnImage(object, 0);
        }

        public String getText(Object object) {
            return this.getColumnText(object, 0);
        }
    }
}

