/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.PathVariablesGroup;

public class LinkedResourcesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label topLabel;
    private PathVariablesGroup pathVariablesGroup = new PathVariablesGroup(true, 3);

    public LinkedResourcesPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite composite) {
        Font font = composite.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.linked_resource_preference_page_context");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        final Button button = new Button(composite2, 32);
        button.setText(IDEWorkbenchMessages.LinkedResourcesPreference_enableLinkedResources);
        button.setFont(font);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
                preferences.setValue("description.disableLinking", !bl);
                LinkedResourcesPreferencePage.this.updateWidgetState(bl);
                if (bl) {
                    MessageDialog.openWarning((Shell)LinkedResourcesPreferencePage.this.getShell(), (String)IDEWorkbenchMessages.LinkedResourcesPreference_linkedResourcesWarningTitle, (String)IDEWorkbenchMessages.LinkedResourcesPreference_linkedResourcesWarningMessage);
                }
            }
        });
        LinkedResourcesPreferencePage.createSpace(composite2);
        this.topLabel = new Label(composite2, 0);
        this.topLabel.setText(IDEWorkbenchMessages.LinkedResourcesPreference_explanation);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.topLabel.setLayoutData((Object)gridData);
        this.topLabel.setFont(font);
        this.pathVariablesGroup.createContents(composite2);
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        boolean bl = !preferences.getBoolean("description.disableLinking");
        button.setSelection(bl);
        this.updateWidgetState(bl);
        return composite2;
    }

    protected static void createSpace(Composite composite) {
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        label.setLayoutData((Object)gridData);
    }

    public void dispose() {
        this.pathVariablesGroup.dispose();
        super.dispose();
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performOk() {
        return this.pathVariablesGroup.performOk();
    }

    protected void updateWidgetState(boolean bl) {
        this.topLabel.setEnabled(bl);
        this.pathVariablesGroup.setEnabled(bl);
    }
}

