/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenResourceDialog
extends FilteredResourcesSelectionDialog {
    private Button openWithButton;

    public OpenResourceDialog(Shell shell, IContainer iContainer, int n) {
        super(shell, true, iContainer, n);
        this.setTitle(IDEWorkbenchMessages.OpenResourceDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.open_resource_dialog");
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        StructuredSelection structuredSelection = this.getSelectedItems();
        if (structuredSelection.isEmpty()) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = this.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        OpenFileAction openFileAction = new OpenFileAction(iWorkbenchPage){

            public void run() {
                OpenResourceDialog.this.okPressed();
            }
        };
        openFileAction.selectionChanged((IStructuredSelection)structuredSelection);
        if (!openFileAction.isEnabled()) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)openFileAction);
        IAdaptable iAdaptable = this.getSelectedAdaptable();
        if (iAdaptable == null) {
            return;
        }
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.OpenResourceDialog_openWithMenu_label);
        OpenWithMenu openWithMenu = new OpenWithMenu(iWorkbenchPage, iAdaptable){

            protected void openEditor(IEditorDescriptor iEditorDescriptor, boolean bl) {
                OpenResourceDialog.this.computeResult();
                OpenResourceDialog.this.setResult(Collections.EMPTY_LIST);
                OpenResourceDialog.this.close();
                super.openEditor(iEditorDescriptor, bl);
            }
        };
        menuManager.add((IContributionItem)openWithMenu);
        iMenuManager.add((IContributionItem)menuManager);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        int n;
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        final Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout2);
        Button button = this.createButton(composite2, 0, IDEWorkbenchMessages.OpenResourceDialog_openButton_text, true);
        ++((GridLayout)composite2.getLayout()).numColumns;
        this.openWithButton = new Button(composite2, 8);
        this.openWithButton.setToolTipText(IDEWorkbenchMessages.OpenResourceDialog_openWithButton_toolTip);
        this.openWithButton.setImage(WorkbenchImages.getImage((String)"IMG_LCL_BUTTON_MENU"));
        GridData gridData = new GridData(0x1000000, 4, false, true);
        this.openWithButton.setLayoutData((Object)gridData);
        this.openWithButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                OpenResourceDialog.this.showOpenWithMenu(composite2);
            }
        });
        this.openWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OpenResourceDialog.this.showOpenWithMenu(composite2);
            }
        });
        Button button2 = this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        GridData gridData2 = (GridData)button2.getLayoutData();
        GridData gridData3 = (GridData)button.getLayoutData();
        gridData2.widthHint = n = Math.max(gridData2.widthHint, gridData3.widthHint);
        gridData3.widthHint = n;
        if (composite2.getDisplay().getDismissalAlignment() == 131072) {
            composite2.moveBelow(null);
            if (Util.isCarbon()) {
                gridData3.horizontalIndent = -10;
            }
        }
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.openWithButton.getDisplay().getDismissalAlignment() == 131072 && !Util.isMac()) {
            this.openWithButton.moveBelow(null);
            this.openWithButton.getParent().layout();
        }
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        super.updateButtonsEnableState(iStatus);
        if (this.openWithButton != null && !this.openWithButton.isDisposed()) {
            this.openWithButton.setEnabled(!iStatus.matches(4) && this.getSelectedItems().size() == 1);
        }
    }

    private IAdaptable getSelectedAdaptable() {
        StructuredSelection structuredSelection = this.getSelectedItems();
        if (structuredSelection.size() != 1) {
            return null;
        }
        Object object = structuredSelection.getFirstElement();
        if (object instanceof IAdaptable) {
            return (IAdaptable)object;
        }
        return null;
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }

    private void showOpenWithMenu(Composite composite) {
        IWorkbenchPage iWorkbenchPage = this.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        IAdaptable iAdaptable = this.getSelectedAdaptable();
        if (iAdaptable == null) {
            return;
        }
        OpenWithMenu openWithMenu = new OpenWithMenu(iWorkbenchPage, iAdaptable){

            protected void openEditor(IEditorDescriptor iEditorDescriptor, boolean bl) {
                OpenResourceDialog.this.computeResult();
                OpenResourceDialog.this.setResult(Collections.EMPTY_LIST);
                OpenResourceDialog.this.close();
                super.openEditor(iEditorDescriptor, bl);
            }
        };
        Menu menu = new Menu((Control)composite.getParent());
        Composite composite2 = composite;
        Point point = composite2.getLocation();
        point.y += composite2.getSize().y;
        point = composite2.getParent().toDisplay(point);
        menu.setLocation(point);
        openWithMenu.fill(menu, -1);
        menu.setVisible(true);
    }
}

