/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class PathVariableDialog
extends TitleAreaDialog {
    private Button okButton;
    private Label variableNameLabel;
    private Label variableValueLabel;
    private Text variableNameField;
    private Text variableValueField;
    private Button fileButton;
    private Button folderButton;
    private Button variableButton;
    private int type;
    private int variableType;
    private String variableName;
    private String variableValue;
    private String originalName;
    private int operationMode = 0;
    private IPathVariableManager pathVariableManager;
    private Set namesInUse;
    private int validationStatus;
    private String validationMessage;
    private boolean nameEntered = false;
    private boolean locationEntered = false;
    private final String standardMessage;
    public static final int NEW_VARIABLE = 1;
    public static final int EXISTING_VARIABLE = 2;
    public static final int EDIT_LINK_LOCATION = 3;
    private IProject currentProject = null;

    public PathVariableDialog(Shell shell, int n, int n2, IPathVariableManager iPathVariableManager, Set set) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.type = n;
        this.operationMode = n;
        this.variableName = "";
        this.variableValue = "";
        this.variableType = n2;
        this.pathVariableManager = iPathVariableManager;
        this.namesInUse = set;
        this.standardMessage = this.operationMode == 1 ? IDEWorkbenchMessages.PathVariableDialog_message_newVariable : (this.operationMode == 2 ? IDEWorkbenchMessages.PathVariableDialog_message_existingVariable : IDEWorkbenchMessages.PathVariableDialog_message_editLocation);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.operationMode == 1) {
            shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_newVariable);
        } else if (this.operationMode == 2) {
            shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_existingVariable);
        } else {
            shell.setText(IDEWorkbenchMessages.PathVariableDialog_shellTitle_editLocation);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite2);
        Composite composite3 = this.createComposite(composite2);
        this.createWidgets(composite3);
        if (this.type == 2) {
            this.locationEntered = true;
            this.nameEntered = true;
            this.validateVariableValue();
        }
        Dialog.applyDialogFont((Control)composite2);
        return composite3;
    }

    private Composite createComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(4, false));
        composite2.setLayoutData((Object)new GridData(1808));
        if (this.operationMode == 1) {
            this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_newVariable);
        } else if (this.operationMode == 2) {
            this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_existingVariable);
        } else {
            this.setTitle(IDEWorkbenchMessages.PathVariableDialog_dialogTitle_editLinkLocation);
        }
        this.setMessage(this.standardMessage);
        return composite2;
    }

    private void createWidgets(Composite composite) {
        String string = IDEWorkbenchMessages.PathVariableDialog_variableName;
        String string2 = IDEWorkbenchMessages.PathVariableDialog_variableValue;
        if (this.operationMode != 3) {
            this.variableNameLabel = new Label(composite, 16384);
            this.variableNameLabel.setText(string);
            this.variableNameField = new Text(composite, 2052);
            this.variableNameField.setText(this.variableName);
            this.variableNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.variableNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    PathVariableDialog.this.variableNameModified();
                }
            });
        }
        this.variableValueLabel = new Label(composite, 16384);
        this.variableValueLabel.setText(string2);
        this.variableValueField = new Text(composite, 2052);
        this.variableValueField.setText(this.variableValue);
        this.variableValueField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.variableValueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PathVariableDialog.this.variableValueModified();
            }
        });
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        GridLayout gridLayout = new GridLayout(this.operationMode == 3 ? 3 : 2, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fileButton = new Button(composite2, 8);
        this.fileButton.setText(IDEWorkbenchMessages.PathVariableDialog_file);
        this.fileButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        if ((this.variableType & 1) == 0) {
            this.fileButton.setEnabled(false);
        }
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathVariableDialog.this.selectFile();
            }
        });
        if (this.operationMode == 3) {
            this.variableButton = new Button(composite2, 8);
            this.variableButton.setText(IDEWorkbenchMessages.PathVariableDialog_variable);
            this.variableButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PathVariableDialog.this.selectVariable();
                }
            });
        }
        this.folderButton = new Button(composite2, 8);
        this.folderButton.setText(IDEWorkbenchMessages.PathVariableDialog_folder);
        this.folderButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        if ((this.variableType & 2) == 0) {
            this.folderButton.setEnabled(false);
        }
        this.folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathVariableDialog.this.selectFolder();
            }
        });
    }

    private void variableNameModified() {
        this.variableName = this.variableNameField.getText();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableName() && this.validateVariableValue());
        this.nameEntered = true;
    }

    private void variableValueModified() {
        this.variableValue = this.variableValueField.getText().trim();
        this.validationStatus = 0;
        this.okButton.setEnabled(this.validateVariableValue() && this.validateVariableName());
        this.locationEntered = true;
    }

    private void selectFolder() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setText(IDEWorkbenchMessages.PathVariableDialog_selectFolderTitle);
        directoryDialog.setMessage(IDEWorkbenchMessages.PathVariableDialog_selectFolderMessage);
        directoryDialog.setFilterPath(this.variableValue);
        String string = directoryDialog.open();
        if (string != null) {
            this.variableValue = new Path(string).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    private void selectFile() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(IDEWorkbenchMessages.PathVariableDialog_selectFileTitle);
        fileDialog.setFilterPath(this.variableValue);
        String string = fileDialog.open();
        if (string != null) {
            this.variableValue = new Path(string).makeAbsolute().toOSString();
            this.variableValueField.setText(this.variableValue);
        }
    }

    private void selectVariable() {
        String[] stringArray;
        PathVariableSelectionDialog pathVariableSelectionDialog = new PathVariableSelectionDialog(this.getShell(), 3);
        pathVariableSelectionDialog.setProject(this.currentProject);
        if (pathVariableSelectionDialog.open() == 0 && (stringArray = (String[])pathVariableSelectionDialog.getResult()) != null && stringArray.length == 1) {
            String string;
            this.variableValue = string = stringArray[0];
            this.variableValueField.setText(string);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.type == 2);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean validateVariableName() {
        boolean bl = false;
        if (this.operationMode == 3) {
            return true;
        }
        if (this.validationStatus == 3) {
            return false;
        }
        String string = this.standardMessage;
        int n = 0;
        if (this.variableName.length() == 0) {
            if (this.nameEntered) {
                n = 3;
                string = IDEWorkbenchMessages.PathVariableDialog_variableNameEmptyMessage;
            }
        } else {
            IStatus iStatus = this.pathVariableManager.validateName(this.variableName);
            if (!iStatus.isOK()) {
                n = 3;
                string = iStatus.getMessage();
            } else if (this.namesInUse.contains(this.variableName) && !this.variableName.equals(this.originalName)) {
                string = IDEWorkbenchMessages.PathVariableDialog_variableAlreadyExistsMessage;
                n = 3;
            } else {
                bl = true;
            }
        }
        if (this.validationStatus == 0 || n == 3) {
            this.validationStatus = n;
            this.validationMessage = string;
        }
        if (!bl) {
            this.setMessage(this.validationMessage, this.validationStatus);
        }
        return bl;
    }

    private boolean validateVariableValue() {
        boolean bl = false;
        if (this.validationStatus == 3) {
            return false;
        }
        String string = this.standardMessage;
        int n = 0;
        if (this.variableValue.length() == 0 && this.locationEntered) {
            n = 3;
            string = IDEWorkbenchMessages.PathVariableDialog_variableValueEmptyMessage;
        }
        if (this.currentProject != null) {
            bl = true;
            IPath iPath = this.currentProject.getPathVariableManager().resolvePath(Path.fromPortableString((String)this.variableValue));
            if (!IDEResourceInfoUtils.exists(iPath.toOSString())) {
                string = IDEWorkbenchMessages.PathVariableDialog_pathDoesNotExistMessage;
                n = 2;
            } else {
                IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(iPath.toOSString());
                if (iFileInfo.isDirectory() != ((this.variableType & 2) != 0)) {
                    bl = false;
                    n = 3;
                    string = (this.variableType & 2) != 0 ? IDEWorkbenchMessages.PathVariableDialog_variableValueIsWrongTypeFolder : IDEWorkbenchMessages.PathVariableDialog_variableValueIsWrongTypeFile;
                }
            }
        } else if (!Path.EMPTY.isValidPath(this.variableValue)) {
            string = IDEWorkbenchMessages.PathVariableDialog_variableValueInvalidMessage;
            n = 3;
        } else if (!new Path(this.variableValue).isAbsolute()) {
            string = IDEWorkbenchMessages.PathVariableDialog_pathIsRelativeMessage;
            n = 3;
        } else if (!IDEResourceInfoUtils.exists(this.variableValue)) {
            string = IDEWorkbenchMessages.PathVariableDialog_pathDoesNotExistMessage;
            n = 2;
            bl = true;
        } else {
            bl = true;
        }
        if (this.validationStatus == 0 || n > this.validationStatus) {
            this.validationStatus = n;
            this.validationMessage = string;
        }
        this.setMessage(this.validationMessage, this.validationStatus);
        return bl;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setVariableName(String string) {
        this.originalName = this.variableName = string.trim();
    }

    public void setVariableValue(String string) {
        this.variableValue = string;
    }

    public void setProject(IProject iProject) {
        this.currentProject = iProject;
    }

    public void setLinkLocation(IPath iPath) {
        this.variableValue = iPath.toPortableString();
    }

    protected boolean isResizable() {
        return true;
    }
}

