/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectVariableProviderManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PathVariablesGroup {
    private static final int SIZING_SELECTION_PANE_WIDTH = 400;
    private Shell shell;
    private Label variableLabel;
    private Table variableTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private FontMetrics fontMetrics;
    private boolean multiSelect;
    private int variableType;
    private Listener selectionListener;
    private SortedMap tempPathVariables;
    private Set removedVariableNames;
    private IPathVariableManager pathVariableManager;
    private final Image FILE_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private final Image FOLDER_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image BUILTIN_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Image imageUnkown;
    private IProject currentProject = null;

    public PathVariablesGroup(boolean bl, int n) {
        this.multiSelect = bl;
        this.variableType = n;
        this.pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
    }

    public PathVariablesGroup(boolean bl, int n, Listener listener) {
        this(bl, n);
        this.selectionListener = listener;
    }

    private void addNewVariable() {
        PathVariableDialog pathVariableDialog = new PathVariableDialog(this.shell, 1, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        pathVariableDialog.setProject(this.currentProject);
        if (pathVariableDialog.open() == 1) {
            return;
        }
        String string = pathVariableDialog.getVariableName();
        Path path = new Path(pathVariableDialog.getVariableValue());
        this.tempPathVariables.put(string, path);
        this.updateWidgetState(string);
    }

    public Control createContents(Composite composite) {
        ImageDescriptor imageDescriptor;
        Font font = composite.getFont();
        if (this.imageUnkown == null) {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/warning.gif");
            this.imageUnkown = imageDescriptor.createImage();
        }
        this.initializeDialogUnits((Control)composite);
        this.shell = composite.getShell();
        imageDescriptor = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        imageDescriptor.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        imageDescriptor.setLayoutData((Object)gridData);
        imageDescriptor.setFont(font);
        this.variableLabel = new Label((Composite)imageDescriptor, 16384);
        if (this.currentProject == null) {
            this.variableLabel.setText(IDEWorkbenchMessages.PathVariablesBlock_variablesLabel);
        } else {
            this.variableLabel.setText(NLS.bind((String)IDEWorkbenchMessages.PathVariablesBlock_variablesLabelForProject, (Object)this.currentProject.getName()));
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.variableLabel.setLayoutData((Object)gridData);
        this.variableLabel.setFont(font);
        int n = 67584;
        if (this.multiSelect) {
            n |= 2;
        }
        this.variableTable = new Table((Composite)imageDescriptor, n);
        this.variableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathVariablesGroup.this.updateEnabledState();
                if (PathVariablesGroup.this.selectionListener != null) {
                    PathVariablesGroup.this.selectionListener.handleEvent(new Event());
                }
            }
        });
        TableColumn tableColumn = new TableColumn(this.variableTable, 0);
        tableColumn.setText(IDEWorkbenchMessages.PathVariablesBlock_nameColumn);
        tableColumn.setWidth(150);
        tableColumn = new TableColumn(this.variableTable, 0);
        tableColumn.setText(IDEWorkbenchMessages.PathVariablesBlock_valueColumn);
        tableColumn.setWidth(250);
        tableColumn = new TableColumn(this.variableTable, 0);
        tableColumn.setText(IDEWorkbenchMessages.PathVariablesBlock_resolvedValueColumn);
        tableColumn.setWidth(250);
        this.variableTable.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = this.variableTable.getItemHeight() * 7;
        this.variableTable.setLayoutData((Object)gridData);
        this.variableTable.setFont(font);
        this.createButtonGroup((Composite)imageDescriptor);
        this.updateWidgetState(null);
        return imageDescriptor;
    }

    public void dispose() {
        if (this.imageUnkown != null) {
            this.imageUnkown.dispose();
            this.imageUnkown = null;
        }
    }

    private void editSelectedVariable() {
        TableItem tableItem = this.variableTable.getItem(this.variableTable.getSelectionIndex());
        String string = (String)tableItem.getData();
        IPath iPath = (IPath)this.tempPathVariables.get(string);
        PathVariableDialog pathVariableDialog = new PathVariableDialog(this.shell, 2, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        pathVariableDialog.setVariableName(string);
        pathVariableDialog.setVariableValue(iPath.toOSString());
        pathVariableDialog.setProject(this.currentProject);
        if (pathVariableDialog.open() == 1) {
            return;
        }
        this.removedVariableNames.add(string);
        this.tempPathVariables.remove(string);
        String string2 = pathVariableDialog.getVariableName();
        Path path = new Path(pathVariableDialog.getVariableValue());
        this.tempPathVariables.put(string2, path);
        this.updateWidgetState(string2);
    }

    public boolean getEnabled() {
        if (this.variableTable != null && !this.variableTable.isDisposed()) {
            return this.variableTable.getEnabled();
        }
        return true;
    }

    public PathVariableElement[] getSelection() {
        if (this.variableTable == null) {
            return new PathVariableElement[0];
        }
        TableItem[] tableItemArray = this.variableTable.getSelection();
        PathVariableElement[] pathVariableElementArray = new PathVariableElement[tableItemArray.length];
        int n = 0;
        while (n < tableItemArray.length) {
            String string = (String)tableItemArray[n].getData();
            pathVariableElementArray[n] = new PathVariableElement();
            pathVariableElementArray[n].name = string;
            pathVariableElementArray[n].path = (IPath)this.tempPathVariables.get(string);
            ++n;
        }
        return pathVariableElementArray;
    }

    private void createButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        this.addButton = new Button(composite2, 8);
        this.addButton.setText(IDEWorkbenchMessages.PathVariablesBlock_addVariableButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathVariablesGroup.this.addNewVariable();
            }
        });
        this.addButton.setFont(font);
        this.setButtonLayoutData(this.addButton);
        this.editButton = new Button(composite2, 8);
        this.editButton.setText(IDEWorkbenchMessages.PathVariablesBlock_editVariableButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathVariablesGroup.this.editSelectedVariable();
            }
        });
        this.editButton.setFont(font);
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText(IDEWorkbenchMessages.PathVariablesBlock_removeVariableButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathVariablesGroup.this.removeSelectedVariables();
            }
        });
        this.removeButton.setFont(font);
        this.setButtonLayoutData(this.removeButton);
    }

    protected void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        this.fontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    private void initTemporaryState() {
        String[] stringArray = this.pathVariableManager.getPathVariableNames();
        this.tempPathVariables.clear();
        int n = 0;
        while (n < stringArray.length) {
            boolean bl;
            IPath iPath = this.pathVariableManager.getValue(stringArray[n]);
            if (iPath != null && ((bl = iPath.toFile().isFile()) && (this.variableType & 1) != 0 || !bl && (this.variableType & 2) != 0)) {
                this.tempPathVariables.put(stringArray[n], iPath);
            }
            ++n;
        }
        this.removedVariableNames.clear();
    }

    private void updateEnabledState() {
        int n = this.variableTable.getSelectionCount();
        this.editButton.setEnabled(n == 1 && this.canChangeSelection());
        this.removeButton.setEnabled(n > 0 && this.canChangeSelection());
    }

    private void updateVariableTable(String string) {
        this.variableTable.removeAll();
        int n = 0;
        Iterator iterator = this.tempPathVariables.keySet().iterator();
        while (iterator.hasNext()) {
            IPath iPath;
            TableItem tableItem = new TableItem(this.variableTable, 0);
            String string2 = (String)iterator.next();
            IPath iPath2 = iPath = (IPath)this.tempPathVariables.get(string2);
            if (this.currentProject != null) {
                iPath2 = this.currentProject.getPathVariableManager().resolvePath(iPath2);
            }
            IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(iPath2);
            tableItem.setText(0, string2);
            tableItem.setText(1, iPath.toOSString());
            tableItem.setText(2, iPath2.toOSString());
            tableItem.setData((Object)string2);
            if (!this.isBuiltInVariable(string2)) {
                tableItem.setImage(iFileInfo.exists() ? (iFileInfo.isDirectory() ? this.FOLDER_IMG : this.FILE_IMG) : this.imageUnkown);
            } else {
                tableItem.setImage(this.BUILTIN_IMG);
            }
            if (!string2.equals(string)) continue;
            n = this.variableTable.getItemCount() - 1;
        }
        if (this.variableTable.getItemCount() > n) {
            this.variableTable.setSelection(n);
            if (this.selectionListener != null) {
                this.selectionListener.handleEvent(new Event());
            }
        } else if (this.variableTable.getItemCount() == 0 && this.selectionListener != null) {
            this.selectionListener.handleEvent(new Event());
        }
    }

    public boolean performOk() {
        try {
            Object object;
            Iterator<Object> iterator = this.removedVariableNames.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (this.tempPathVariables.containsKey(object)) continue;
                this.pathVariableManager.setValue((String)object, null);
            }
            iterator = this.tempPathVariables.entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                String string = (String)object.getKey();
                IPath iPath = (IPath)object.getValue();
                if (this.isBuiltInVariable(string)) continue;
                this.pathVariableManager.setValue(string, iPath);
            }
            this.initTemporaryState();
            return true;
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)coreException.getStatus());
            return false;
        }
    }

    private void removeSelectedVariables() {
        int[] nArray = this.variableTable.getSelectionIndices();
        int n = 0;
        while (n < nArray.length) {
            TableItem tableItem = this.variableTable.getItem(nArray[n]);
            String string = (String)tableItem.getData();
            this.removedVariableNames.add(string);
            this.tempPathVariables.remove(string);
            ++n;
        }
        this.updateWidgetState(null);
    }

    private boolean canChangeSelection() {
        int[] nArray = this.variableTable.getSelectionIndices();
        int n = 0;
        while (n < nArray.length) {
            TableItem tableItem = this.variableTable.getItem(nArray[n]);
            String string = (String)tableItem.getData();
            if (this.isBuiltInVariable(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isBuiltInVariable(String string) {
        ProjectVariableProviderManager.Descriptor[] descriptorArray;
        if (this.currentProject != null && (descriptorArray = ProjectVariableProviderManager.getDefault().getDescriptors()) != null) {
            int n = 0;
            while (n < descriptorArray.length) {
                if (string.equals(descriptorArray[n].getName())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private GridData setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
        return gridData;
    }

    public void setEnabled(boolean bl) {
        if (this.variableTable != null && !this.variableTable.isDisposed()) {
            this.variableLabel.setEnabled(bl);
            this.variableTable.setEnabled(bl);
            this.addButton.setEnabled(bl);
            if (bl) {
                this.updateEnabledState();
            } else {
                this.editButton.setEnabled(bl);
                this.removeButton.setEnabled(bl);
            }
        }
    }

    private void updateWidgetState(String string) {
        this.updateVariableTable(string);
        this.updateEnabledState();
    }

    public void setProject(IProject iProject) {
        this.currentProject = iProject;
        this.pathVariableManager = iProject.getPathVariableManager();
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
    }

    public void reloadContent() {
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
        if (this.variableTable != null) {
            this.updateWidgetState(null);
        }
    }

    public static class PathVariableElement {
        public String name;
        public IPath path;
    }
}

