/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.FileSystemSelectionArea;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class ProjectContentsLocationArea {
    private static String BROWSE_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_browseLabel;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String FILE_SCHEME = "file";
    private static final String SAVED_LOCATION_ATTR = "OUTSIDE_LOCATION";
    private Label locationLabel;
    private Text locationPathField;
    private Button browseButton;
    private IErrorMessageReporter errorReporter;
    private String projectName = "";
    private String userPath = "";
    private Button useDefaultsButton;
    private IProject existingProject;
    private FileSystemSelectionArea fileSystemSelectionArea;

    public ProjectContentsLocationArea(IErrorMessageReporter iErrorMessageReporter, Composite composite, IProject iProject) {
        this.errorReporter = iErrorMessageReporter;
        this.projectName = iProject.getName();
        this.existingProject = iProject;
        this.createContents(composite, false);
    }

    public void setExistingProject(IProject iProject) {
        this.projectName = iProject.getName();
        this.existingProject = iProject;
    }

    public ProjectContentsLocationArea(IErrorMessageReporter iErrorMessageReporter, Composite composite) {
        this.errorReporter = iErrorMessageReporter;
        this.createContents(composite, true);
    }

    private void createContents(Composite composite, boolean bl) {
        int n = 4;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.useDefaultsButton = new Button(composite2, 131104);
        this.useDefaultsButton.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_useDefaultLabel);
        this.useDefaultsButton.setSelection(bl);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        this.useDefaultsButton.setLayoutData((Object)gridData);
        this.createUserEntryArea(composite2, bl);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = ProjectContentsLocationArea.this.useDefaultsButton.getSelection();
                if (bl) {
                    ProjectContentsLocationArea.this.userPath = ProjectContentsLocationArea.this.locationPathField.getText();
                    ProjectContentsLocationArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsLocationArea.this.getDefaultPathDisplayString()));
                } else {
                    ProjectContentsLocationArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsLocationArea.this.userPath));
                }
                String string = ProjectContentsLocationArea.this.checkValidLocation();
                ProjectContentsLocationArea.this.errorReporter.reportError(string, string != null && string.equals(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty));
                ProjectContentsLocationArea.this.setUserAreaEnabled(!bl);
            }
        });
        this.setUserAreaEnabled(!bl);
    }

    public boolean isDefault() {
        return this.useDefaultsButton.getSelection();
    }

    private void createUserEntryArea(Composite composite, boolean bl) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationLabel);
        this.locationPathField = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        gridData.horizontalSpan = 2;
        this.locationPathField.setLayoutData((Object)gridData);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectContentsLocationArea.this.handleLocationBrowseButtonPressed();
            }
        });
        this.createFileSystemSelection(composite);
        if (bl) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        } else if (this.existingProject == null) {
            this.locationPathField.setText("");
        } else {
            this.locationPathField.setText(TextProcessor.process((String)this.existingProject.getLocation().toOSString()));
        }
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProjectContentsLocationArea.this.errorReporter.reportError(ProjectContentsLocationArea.this.checkValidLocation(), false);
            }
        });
    }

    private void createFileSystemSelection(Composite composite) {
        if (FileSystemSupportRegistry.getInstance().hasOneFileSystem()) {
            return;
        }
        new Label(composite, 0);
        this.fileSystemSelectionArea = new FileSystemSelectionArea();
        this.fileSystemSelectionArea.createContents(composite);
    }

    private String getDefaultPathDisplayString() {
        URI uRI = null;
        if (this.existingProject != null) {
            uRI = this.existingProject.getLocationURI();
        }
        if (uRI == null || uRI.getScheme().equals(FILE_SCHEME)) {
            return Platform.getLocation().append(this.projectName).toOSString();
        }
        return uRI.toString();
    }

    private void setUserAreaEnabled(boolean bl) {
        this.locationLabel.setEnabled(bl);
        this.locationPathField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        if (this.fileSystemSelectionArea != null) {
            this.fileSystemSelectionArea.setEnabled(bl);
        }
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.getClass().getName());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.getClass().getName());
        }
        return iDialogSettings2;
    }

    private void handleLocationBrowseButtonPressed() {
        Object object;
        String string = null;
        String string2 = this.getPathFromLocationField();
        if (!string2.equals("")) {
            object = IDEResourceInfoUtils.getFileInfo(string2);
            if (object == null || !object.exists()) {
                string2 = "";
            }
        } else {
            object = this.getDialogSettings().get(SAVED_LOCATION_ATTR);
            if (object != null) {
                string2 = object;
            }
        }
        if ((object = this.getSelectedConfiguration()) == null || object.equals(FileSystemSupportRegistry.getInstance().getDefaultConfiguration())) {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.locationPathField.getShell());
            directoryDialog.setMessage(IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel);
            directoryDialog.setFilterPath(string2);
            string = directoryDialog.open();
        } else {
            URI uRI = this.getSelectedConfiguration().getContributor().browseFileSystem(string2, this.browseButton.getShell());
            if (uRI != null) {
                string = uRI.toString();
            }
        }
        if (string != null) {
            this.updateLocationField(string);
            this.getDialogSettings().put(SAVED_LOCATION_ATTR, string);
        }
    }

    private void updateLocationField(String string) {
        this.locationPathField.setText(TextProcessor.process((String)string));
    }

    private String getPathFromLocationField() {
        URI uRI;
        try {
            uRI = new URI(this.locationPathField.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.locationPathField.getText();
        }
        return uRI.getPath();
    }

    public String checkValidLocation() {
        URI uRI;
        String string = this.locationPathField.getText();
        if (string.length() == 0) {
            return IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        URI uRI2 = this.getProjectLocationURI();
        if (uRI2 == null) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
        }
        if (this.existingProject != null && (uRI = this.existingProject.getLocationURI()) != null && URIUtil.equals((URI)uRI, (URI)uRI2)) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationIsSelf;
        }
        if (!this.isDefault() && !(uRI = ResourcesPlugin.getWorkspace().validateProjectLocationURI(this.existingProject, uRI2)).isOK()) {
            return uRI.getMessage();
        }
        return null;
    }

    public URI getProjectLocationURI() {
        FileSystemConfiguration fileSystemConfiguration = this.getSelectedConfiguration();
        if (fileSystemConfiguration == null) {
            return null;
        }
        return fileSystemConfiguration.getContributor().getURI(this.locationPathField.getText());
    }

    private FileSystemConfiguration getSelectedConfiguration() {
        if (this.fileSystemSelectionArea == null) {
            return FileSystemSupportRegistry.getInstance().getDefaultConfiguration();
        }
        return this.fileSystemSelectionArea.getSelectedConfiguration();
    }

    public void updateProjectName(String string) {
        this.projectName = string;
        if (this.isDefault()) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        }
    }

    public String getProjectLocation() {
        if (this.isDefault()) {
            return Platform.getLocation().toOSString();
        }
        return this.locationPathField.getText();
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1, boolean var2);
    }
}

