/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.IProgressService;

public class ProjectReferencePage
extends PropertyPage {
    private IProject project;
    private boolean modified = false;
    private CheckboxTableViewer listViewer;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.project_reference_property_page_context");
        Composite composite2 = new Composite(composite, 0);
        this.initialize();
        this.createDescriptionLabel(composite2);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2176);
        if (!this.project.isOpen()) {
            this.listViewer.getControl().setEnabled(false);
        }
        this.listViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)this.getContentProvider(this.project));
        this.listViewer.setComparator(new ViewerComparator());
        this.listViewer.setInput((Object)this.project.getWorkspace());
        try {
            this.listViewer.setCheckedElements((Object[])this.project.getDescription().getReferencedProjects());
        }
        catch (CoreException coreException) {}
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ProjectReferencePage.this.modified = true;
            }
        });
        this.applyDialogFont(composite2);
        GridLayoutFactory.fillDefaults().generateLayout(composite2);
        return composite2;
    }

    protected IStructuredContentProvider getContentProvider(final IProject iProject) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (!(object instanceof IWorkspace)) {
                    return new Object[0];
                }
                IProject[] iProjectArray = ((IWorkspace)object).getRoot().getProjects();
                ArrayList<IProject> arrayList = new ArrayList<IProject>(iProjectArray.length);
                boolean bl = false;
                int n = 0;
                while (n < iProjectArray.length) {
                    if (!bl && iProjectArray[n].equals((Object)iProject)) {
                        bl = true;
                    } else {
                        arrayList.add(iProjectArray[n]);
                    }
                    ++n;
                }
                try {
                    iProjectArray = iProject.getDescription().getReferencedProjects();
                    n = 0;
                    while (n < iProjectArray.length) {
                        if (!arrayList.contains(iProjectArray[n])) {
                            arrayList.add(iProjectArray[n]);
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
                return arrayList.toArray();
            }
        };
    }

    protected void handle(InvocationTargetException invocationTargetException) {
        IStatus iStatus;
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
        } else {
            String string = throwable.getMessage();
            if (string == null) {
                string = IDEWorkbenchMessages.Internal_error;
            }
            iStatus = new Status(4, "org.eclipse.ui.ide", 1, string, throwable);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), null, null, (IStatus)iStatus);
    }

    private void initialize() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.project = (IProject)iAdaptable.getAdapter((Class)clazz);
        this.noDefaultAndApplyButton();
        this.setDescription(NLS.bind((String)IDEWorkbenchMessages.ProjectReferencesPage_label, (Object)this.project.getName()));
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        Object[] objectArray = this.listViewer.getCheckedElements();
        final IProject[] iProjectArray = new IProject[objectArray.length];
        System.arraycopy(objectArray, 0, iProjectArray, 0, objectArray.length);
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    IProjectDescription iProjectDescription = ProjectReferencePage.this.project.getDescription();
                    iProjectDescription.setReferencedProjects(iProjectArray);
                    ProjectReferencePage.this.project.setDescription(iProjectDescription, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
        try {
            iProgressService.run(false, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handle(invocationTargetException);
            return false;
        }
        return true;
    }
}

