/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class ResourceComparator
extends ViewerComparator {
    public static final int NAME = 1;
    public static final int TYPE = 2;
    private int criteria;

    public ResourceComparator(int n) {
        this.criteria = n;
    }

    protected int classComparison(Object object) {
        if (object instanceof IResource) {
            return 2;
        }
        return 0;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        if (!(object instanceof IResource) || !(object2 instanceof IResource)) {
            return this.compareClass(object, object2);
        }
        IResource iResource = (IResource)object;
        IResource iResource2 = (IResource)object2;
        if (iResource instanceof IContainer && iResource2 instanceof IContainer) {
            return this.compareNames(iResource, iResource2);
        }
        if (iResource instanceof IContainer) {
            return -1;
        }
        if (iResource2 instanceof IContainer) {
            return 1;
        }
        if (this.criteria == 1) {
            return this.compareNames(iResource, iResource2);
        }
        if (this.criteria == 2) {
            return this.compareTypes(iResource, iResource2);
        }
        return 0;
    }

    protected int compareClass(Object object, Object object2) {
        return this.classComparison(object) - this.classComparison(object2);
    }

    protected int compareNames(IResource iResource, IResource iResource2) {
        return this.getComparator().compare(iResource.getName(), iResource2.getName());
    }

    protected int compareTypes(IResource iResource, IResource iResource2) {
        String string = this.getExtensionFor(iResource);
        String string2 = this.getExtensionFor(iResource2);
        int n = this.getComparator().compare(string, string2);
        if (n != 0) {
            return n;
        }
        return this.compareNames(iResource, iResource2);
    }

    public int getCriteria() {
        return this.criteria;
    }

    private String getExtensionFor(IResource iResource) {
        String string = iResource.getFileExtension();
        return string == null ? "" : string;
    }
}

