/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterEditDialog;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ResourceFilterPage
extends PropertyPage {
    private Button addButton = null;
    private Button removeButton = null;
    private Button upButton = null;
    private Button downButton = null;
    private Button editButton = null;
    private TreeViewer filterView;
    private Filters filters;
    private LabelProvider labelProvider;
    private Image checkIcon = null;
    private boolean tableViewCellEditorAdequatlyUsable = false;
    private boolean allowReordering = false;
    Action addSubFilterAction = new AddSubFilterAction();
    private FilterCopyTransfer filterCopyTransfer = new FilterCopyTransfer();
    static /* synthetic */ Class class$0;

    public ResourceFilterPage() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/header_complete.gif");
        if (imageDescriptor != null) {
            this.checkIcon = imageDescriptor.createImage();
        }
    }

    protected Control createContents(Composite composite) {
        IContainer iContainer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.resource_filter_property_page_context");
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iContainer = (IContainer)iAdaptable.getAdapter((Class)clazz)) == null) {
            Label label = new Label(composite, 0);
            label.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_noResource, null));
            return label;
        }
        this.filters = new Filters(iContainer);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_title, null));
        gridData = new GridData(4);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.createViewerGroup(composite2);
        this.createButtonGroup(composite2);
        this.refreshEnablement();
        return composite2;
    }

    private void createViewerGroup(Composite composite) {
        this.filterView = new TreeViewer(composite, 67840);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.filterView.getTree().setLayoutData((Object)gridData);
        this.filterView.setColumnProperties(FilterTypeUtil.columnNames);
        this.filterView.setContentProvider((IContentProvider)new TreeContentProvider());
        this.filterView.setInput((Object)this.filters);
        this.filterView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ResourceFilterPage.this.refreshEnablement();
            }
        });
        TreeColumn treeColumn = new TreeColumn(this.filterView.getTree(), 0);
        treeColumn.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterMode, null));
        treeColumn.setData((Object)FilterTypeUtil.MODE);
        treeColumn.setResizable(true);
        treeColumn.setMoveable(false);
        treeColumn.setWidth(ResourceFilterPage.getMinimumColumnWidth(treeColumn, 130));
        treeColumn = new TreeColumn(this.filterView.getTree(), 0);
        treeColumn.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterArguments, null));
        treeColumn.setData((Object)FilterTypeUtil.ARGUMENTS);
        treeColumn.setResizable(true);
        treeColumn.setMoveable(true);
        treeColumn.setWidth(ResourceFilterPage.getMinimumColumnWidth(treeColumn, 120));
        treeColumn = new TreeColumn(this.filterView.getTree(), 0);
        treeColumn.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterInheritable, null));
        treeColumn.setData((Object)FilterTypeUtil.INHERITABLE);
        treeColumn.setResizable(true);
        treeColumn.setMoveable(false);
        treeColumn.setAlignment(0x1000000);
        treeColumn.setWidth(ResourceFilterPage.getMinimumColumnWidth(treeColumn, 70));
        this.filterView.getTree().setHeaderVisible(true);
        this.filterView.getTree().showColumn(this.filterView.getTree().getColumn(0));
        this.labelProvider = new LabelProvider();
        this.filterView.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        CellEditor[] cellEditorArray = new CellEditor[]{new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getFilterNames(false), 8), new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getModes(), 8), new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getTargets(), 8), new CheckboxCellEditor((Composite)this.filterView.getTree()), new TextCellEditor((Composite)this.filterView.getTree())};
        if (this.tableViewCellEditorAdequatlyUsable) {
            this.filterView.setCellEditors(cellEditorArray);
            this.filterView.setCellModifier((ICellModifier)new CellModifier());
        }
        this.filterView.getTree().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ResourceFilterPage.this.handleEdit();
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        FilterCopyDrag filterCopyDrag = new FilterCopyDrag();
        int n = 2;
        Transfer[] transferArray = new Transfer[]{this.filterCopyTransfer};
        this.filterView.addDragSupport(n, transferArray, (DragSourceListener)filterCopyDrag);
        this.filterView.addDropSupport(n, transferArray, (DropTargetListener)new FilterCopyDrop((Viewer)this.filterView));
        this.filterView.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent menuDetectEvent) {
                MenuManager menuManager = new MenuManager();
                menuManager.add((IAction)ResourceFilterPage.this.addSubFilterAction);
                ResourceFilterPage.this.filterView.getControl().setMenu(menuManager.createContextMenu(ResourceFilterPage.this.filterView.getControl()));
            }
        });
    }

    private static int getMinimumColumnWidth(TreeColumn treeColumn, int n) {
        FontMetrics fontMetrics;
        Assert.isNotNull((Object)treeColumn);
        GC gC = new GC((Drawable)treeColumn.getParent());
        try {
            gC.setFont(treeColumn.getParent().getFont());
            fontMetrics = gC.getFontMetrics();
        }
        finally {
            gC.dispose();
        }
        return Math.max(n, fontMetrics.getAverageCharWidth() * treeColumn.getText().length());
    }

    private void createButtonGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, false, false);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.addButton = new Button(composite2, 8);
        this.addButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_addButtonLabel, null));
        gridData = new GridData(4, 4, false, false);
        this.addButton.setLayoutData((Object)gridData);
        ResourceFilterPage.setButtonDimensionHint(this.addButton);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceFilterPage.this.handleAdd();
            }
        });
        this.editButton = new Button(composite2, 8);
        this.editButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_editButtonLabel, null));
        gridData = new GridData(4, 4, false, false);
        this.editButton.setLayoutData((Object)gridData);
        ResourceFilterPage.setButtonDimensionHint(this.editButton);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceFilterPage.this.handleEdit();
            }
        });
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_removeButtonLabel, null));
        gridData = new GridData(4, 4, false, false);
        this.removeButton.setLayoutData((Object)gridData);
        ResourceFilterPage.setButtonDimensionHint(this.removeButton);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceFilterPage.this.handleRemove();
            }
        });
        if (this.allowReordering) {
            this.upButton = new Button(composite2, 8);
            this.upButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_upButtonLabel, null));
            gridData = new GridData(4, 4, false, false);
            this.upButton.setLayoutData((Object)gridData);
            ResourceFilterPage.setButtonDimensionHint(this.upButton);
            this.upButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ResourceFilterPage.this.handleUp();
                }
            });
            this.downButton = new Button(composite2, 8);
            this.downButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_downButtonLabel, null));
            gridData = new GridData(4, 4, false, false);
            this.downButton.setLayoutData((Object)gridData);
            ResourceFilterPage.setButtonDimensionHint(this.downButton);
            this.downButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ResourceFilterPage.this.handleDown();
                }
            });
        }
    }

    private void refreshEnablement() {
        this.addButton.setEnabled(true);
        ISelection iSelection = this.filterView.getSelection();
        IStructuredSelection iStructuredSelection = null;
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
        }
        this.removeButton.setEnabled(iStructuredSelection != null && iStructuredSelection.size() > 0);
        this.editButton.setEnabled(iStructuredSelection != null && iStructuredSelection.size() == 1);
        if (this.upButton != null) {
            this.upButton.setEnabled(iStructuredSelection != null && iStructuredSelection.size() > 0 && !this.isFirst(iStructuredSelection.getFirstElement()));
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(iStructuredSelection != null && iStructuredSelection.size() > 0 && !this.isLast(iStructuredSelection.getFirstElement()));
        }
    }

    private boolean isFirst(Object object) {
        return this.filters.isFirst((FilterCopy)object);
    }

    private boolean isLast(Object object) {
        return this.filters.isLast((FilterCopy)object);
    }

    private void handleAdd() {
        FilterCopy filterCopy = new FilterCopy();
        FilterEditDialog filterEditDialog = new FilterEditDialog(this.getShell(), filterCopy);
        if (filterEditDialog.open() == 0) {
            this.filters.add(filterCopy);
            this.filterView.refresh();
        }
    }

    private void handleEdit() {
        ISelection iSelection = this.filterView.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            FilterCopy filterCopy = (FilterCopy)((IStructuredSelection)iSelection).getFirstElement();
            FilterCopy filterCopy2 = new FilterCopy(filterCopy);
            filterCopy2.setParent(filterCopy.getParent());
            FilterEditDialog filterEditDialog = new FilterEditDialog(this.getShell(), filterCopy2);
            if (filterEditDialog.open() == 0 && filterCopy2.hasChanged()) {
                filterCopy.copy(filterCopy2);
                this.filterView.refresh();
            }
        }
    }

    private FilterCopy[] getFilterCopySelection() {
        ISelection iSelection = this.filterView.getSelection();
        IStructuredSelection iStructuredSelection = null;
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
            FilterCopy[] filterCopyArray = new FilterCopy[iStructuredSelection.size()];
            System.arraycopy(iStructuredSelection.toArray(), 0, filterCopyArray, 0, filterCopyArray.length);
            return filterCopyArray;
        }
        return new FilterCopy[0];
    }

    private void handleRemove() {
        ISelection iSelection = this.filterView.getSelection();
        IStructuredSelection iStructuredSelection = null;
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                FilterCopy filterCopy = (FilterCopy)iterator.next();
                filterCopy.getParent().removeChild(filterCopy);
            }
            this.filterView.refresh();
        }
    }

    private void handleUp() {
        ISelection iSelection = this.filterView.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            FilterCopy filterCopy = (FilterCopy)((IStructuredSelection)iSelection).getFirstElement();
            this.filters.moveUp(filterCopy);
        }
        this.filterView.refresh();
        this.refreshEnablement();
    }

    private void handleDown() {
        ISelection iSelection = this.filterView.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            FilterCopy filterCopy = (FilterCopy)((IStructuredSelection)iSelection).getFirstElement();
            this.filters.moveDown(filterCopy);
        }
        this.filterView.refresh();
        this.refreshEnablement();
    }

    private static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object object = button.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = ResourceFilterPage.getButtonWidthHint(button);
            ((GridData)object).horizontalAlignment = 4;
        }
    }

    private static int getButtonWidthHint(Button button) {
        FontMetrics fontMetrics;
        button.setFont(JFaceResources.getDialogFont());
        GC gC = new GC((Drawable)button);
        try {
            gC.setFont(button.getFont());
            fontMetrics = gC.getFontMetrics();
        }
        finally {
            gC.dispose();
        }
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    protected void performDefaults() {
        IContainer iContainer;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iContainer = (IContainer)iAdaptable.getAdapter((Class)clazz)) == null) {
            return;
        }
        this.filters = new Filters(iContainer);
        this.filterView.setInput((Object)this.filters);
        this.filterView.refresh();
    }

    public boolean performOk() {
        if (this.filters.hasChanged()) {
            IContainer iContainer;
            IAdaptable iAdaptable = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iContainer = (IContainer)iAdaptable.getAdapter((Class)clazz)) == null) {
                return true;
            }
            try {
                IFilter[] iFilterArray = iContainer.getFilters();
                int n = 0;
                while (n < iFilterArray.length) {
                    iContainer.removeFilter(iFilterArray[n].getId(), iFilterArray[n].getType(), iFilterArray[n].getArguments(), 128, (IProgressMonitor)new NullProgressMonitor());
                    ++n;
                }
                FilterCopy[] filterCopyArray = this.filters.getChildren();
                int n2 = 0;
                while (n2 < filterCopyArray.length) {
                    iContainer.addFilter(filterCopyArray[n2].getId(), filterCopyArray[n2].getType(), filterCopyArray[n2].getArguments(), 128, (IProgressMonitor)new NullProgressMonitor());
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)IDEWorkbenchMessages.InternalError, null), (String)coreException.getLocalizedMessage(), (IStatus)coreException.getStatus());
            }
        }
        return true;
    }

    class AddSubFilterAction
    extends Action {
        public AddSubFilterAction() {
            this.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_addSubFilterActionLabel, null));
        }

        public void run() {
            FilterCopy filterCopy;
            ISelection iSelection = ResourceFilterPage.this.filterView.getSelection();
            if (iSelection instanceof IStructuredSelection && (filterCopy = (FilterCopy)((IStructuredSelection)iSelection).getFirstElement()).getChildrenLimit() > 0) {
                FilterCopy filterCopy2 = new FilterCopy();
                filterCopy2.setParent(filterCopy);
                FilterEditDialog filterEditDialog = new FilterEditDialog(ResourceFilterPage.this.getShell(), filterCopy2);
                if (filterEditDialog.open() == 0) {
                    filterCopy.addChild(filterCopy2);
                    ResourceFilterPage.this.filterView.refresh();
                }
            }
        }

        public boolean isEnabled() {
            ISelection iSelection = ResourceFilterPage.this.filterView.getSelection();
            if (iSelection instanceof IStructuredSelection) {
                FilterCopy filterCopy = (FilterCopy)((IStructuredSelection)iSelection).getFirstElement();
                return filterCopy.getChildrenLimit() > 0;
            }
            return false;
        }
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            FilterCopy filterCopy = (FilterCopy)object;
            return !string.equals(FilterTypeUtil.ARGUMENTS) || filterCopy.hasStringArguments();
        }

        public Object getValue(Object object, String string) {
            FilterCopy filterCopy = (FilterCopy)object;
            return FilterTypeUtil.getValue(filterCopy, string);
        }

        public void modify(Object object, String string, Object object2) {
            FilterCopy filterCopy = (FilterCopy)((TableItem)object).getData();
            FilterTypeUtil.setValue(filterCopy, string, object2);
            ResourceFilterPage.this.filterView.refresh((Object)filterCopy);
        }
    }

    class FilterCopyDrag
    implements DragSourceListener {
        FilterCopyDrag() {
        }

        public void dragFinished(DragSourceEvent dragSourceEvent) {
            int cfr_ignored_0 = dragSourceEvent.detail;
        }

        public void dragSetData(DragSourceEvent dragSourceEvent) {
            if (ResourceFilterPage.this.filterCopyTransfer.isSupportedType(dragSourceEvent.dataType)) {
                dragSourceEvent.data = ResourceFilterPage.this.getFilterCopySelection();
            }
        }

        public void dragStart(DragSourceEvent dragSourceEvent) {
            if (ResourceFilterPage.this.getFilterCopySelection().length == 0) {
                dragSourceEvent.doit = false;
            }
        }
    }

    class FilterCopyDrop
    extends ViewerDropAdapter {
        protected FilterCopyDrop(Viewer viewer) {
            super(viewer);
        }

        public boolean performDrop(Object object) {
            int n;
            Object object2 = this.getCurrentTarget();
            if (object2 == null) {
                object2 = ResourceFilterPage.this.filters;
            }
            FilterCopy[] filterCopyArray = (FilterCopy[])object;
            if (object2 instanceof FilterCopy) {
                n = 0;
                while (n < filterCopyArray.length) {
                    if (filterCopyArray[n].equals(object2) || ((FilterCopy)object2).hasParent(filterCopyArray[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            n = 0;
            while (n < filterCopyArray.length) {
                if (object2 instanceof Filters) {
                    ResourceFilterPage.this.filters.add(filterCopyArray[n]);
                }
                if (object2 instanceof FilterCopy) {
                    ((FilterCopy)object2).addChild(filterCopyArray[n]);
                }
                ResourceFilterPage.this.filterView.refresh();
                ResourceFilterPage.this.filterView.reveal((Object)filterCopyArray[n]);
                ++n;
            }
            return true;
        }

        public boolean validateDrop(Object object, int n, TransferData transferData) {
            if (ResourceFilterPage.this.filterCopyTransfer.isSupportedType(transferData)) {
                if (object instanceof FilterCopy) {
                    return ((FilterCopy)object).canAcceptDrop();
                }
                return true;
            }
            return false;
        }
    }

    class FilterCopyTransfer
    extends ByteArrayTransfer {
        private final String MYTYPENAME = "org.eclipse.ui.ide.internal.filterCopy";
        private final int MYTYPEID = FilterCopyTransfer.registerType((String)"org.eclipse.ui.ide.internal.filterCopy");

        private FilterCopyTransfer() {
        }

        public void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof FilterCopy[])) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                FilterCopy[] filterCopyArray = (FilterCopy[])object;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeInt(filterCopyArray.length);
                    int n = 0;
                    while (n < filterCopyArray.length) {
                        dataOutputStream.writeInt(filterCopyArray[n].getSerialNumber());
                        ++n;
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    super.javaToNative((Object)byArray, transferData);
                }
                catch (IOException iOException) {}
            }
        }

        public Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] byArray = (byte[])super.nativeToJava(transferData);
                if (byArray == null) {
                    return null;
                }
                FilterCopy[] filterCopyArray = new FilterCopy[]{};
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    int n = dataInputStream.readInt();
                    LinkedList<FilterCopy> linkedList = new LinkedList<FilterCopy>();
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = dataInputStream.readInt();
                        FilterCopy filterCopy = ResourceFilterPage.this.filters.findBySerialNumber(n3);
                        if (filterCopy != null) {
                            linkedList.add(filterCopy);
                        }
                        ++n2;
                    }
                    filterCopyArray = linkedList.toArray(new FilterCopy[0]);
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    return null;
                }
                return filterCopyArray;
            }
            return null;
        }

        protected String[] getTypeNames() {
            return new String[]{"org.eclipse.ui.ide.internal.filterCopy"};
        }

        protected int[] getTypeIds() {
            return new int[]{this.MYTYPEID};
        }
    }

    class Filters
    extends FilterCopy {
        boolean changed = false;
        public LinkedList trash = new LinkedList();

        public Filters(IContainer iContainer) {
            try {
                IFilter[] iFilterArray = iContainer.getFilters();
                this.children = new LinkedList();
                int n = 0;
                while (n < iFilterArray.length) {
                    this.addChild(new FilterCopy(iFilterArray[n]));
                    ++n;
                }
            }
            catch (CoreException coreException) {
                ErrorDialog.openError((Shell)ResourceFilterPage.this.getShell(), (String)NLS.bind((String)IDEWorkbenchMessages.InternalError, null), (String)coreException.getLocalizedMessage(), (IStatus)coreException.getStatus());
            }
        }

        public void add(FilterCopy filterCopy) {
            super.addChild(filterCopy);
            this.changed = true;
        }

        public void remove(FilterCopy filterCopy) {
            super.removeChild(filterCopy);
            if (filterCopy.original != null) {
                this.trash.add(filterCopy);
            }
            this.changed = true;
        }

        public void moveUp(IFilter iFilter) {
            FilterCopy[] filterCopyArray = this.getChildren();
            int n = 1;
            while (n < filterCopyArray.length) {
                if (filterCopyArray[n] == iFilter) {
                    FilterCopy filterCopy = filterCopyArray[n - 1];
                    filterCopyArray[n - 1] = filterCopyArray[n];
                    filterCopyArray[n] = filterCopy;
                }
                ++n;
            }
            this.children = new LinkedList<FilterCopy>(Arrays.asList(filterCopyArray));
            this.changed = true;
        }

        public void moveDown(IFilter iFilter) {
            FilterCopy[] filterCopyArray = this.getChildren();
            int n = 0;
            while (n < filterCopyArray.length - 1) {
                if (filterCopyArray[n] == iFilter) {
                    FilterCopy filterCopy = filterCopyArray[n + 1];
                    filterCopyArray[n + 1] = filterCopyArray[n];
                    filterCopyArray[n] = filterCopy;
                }
                ++n;
            }
            this.children = new LinkedList<FilterCopy>(Arrays.asList(filterCopyArray));
            this.changed = true;
        }

        public int getChildrenLimit() {
            return Integer.MAX_VALUE;
        }

        protected void argumentsChanged() {
            this.changed = true;
        }

        public boolean hasChanged() {
            if (this.changed) {
                return true;
            }
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                FilterCopy filterCopy = (FilterCopy)iterator.next();
                if (!filterCopy.hasChanged()) continue;
                return true;
            }
            return false;
        }

        public boolean isFirst(FilterCopy filterCopy) {
            if (this.children.size() > 0) {
                return this.children.getFirst().equals(filterCopy);
            }
            return false;
        }

        public boolean isLast(FilterCopy filterCopy) {
            if (this.children.size() > 0) {
                return this.children.getLast().equals(filterCopy);
            }
            return false;
        }
    }

    class LabelProvider
    implements ITableLabelProvider {
        FilterTypeUtil util = new FilterTypeUtil();

        String getColumnID(int n) {
            return (String)ResourceFilterPage.this.filterView.getColumnProperties()[n];
        }

        public boolean isPartialFilter(Object object) {
            FilterCopy filterCopy = (FilterCopy)object;
            return filterCopy.isUnderAGroupFilter();
        }

        public Image getColumnImage(Object object, int n) {
            if (!this.isPartialFilter(object)) {
                Object object2;
                if (this.getColumnID(n).equals(FilterTypeUtil.ARGUMENTS)) {
                    Object object3 = FilterTypeUtil.getValue((FilterCopy)object, FilterTypeUtil.TARGET);
                    return this.util.getImage(FilterTypeUtil.TARGET, (Integer)object3);
                }
                if (this.getColumnID(n).equals(FilterTypeUtil.MODE)) {
                    Object object4 = FilterTypeUtil.getValue((FilterCopy)object, FilterTypeUtil.MODE);
                    return this.util.getImage(FilterTypeUtil.MODE, (Integer)object4);
                }
                if (this.getColumnID(n).equals(FilterTypeUtil.INHERITABLE) && ((Boolean)(object2 = FilterTypeUtil.getValue((FilterCopy)object, FilterTypeUtil.INHERITABLE))).booleanValue()) {
                    return ResourceFilterPage.this.checkIcon;
                }
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            FilterCopy filterCopy = (FilterCopy)object;
            String string = this.getColumnID(n);
            return this.getValue(filterCopy, string);
        }

        private String getValue(FilterCopy filterCopy, String string) {
            String string2;
            FilterTypeManager.Descriptor descriptor;
            if (string.equals(FilterTypeUtil.ID) && (descriptor = FilterTypeUtil.getDescriptor(string2 = filterCopy.getId())) != null) {
                return descriptor.getName();
            }
            if (string.equals(FilterTypeUtil.MODE)) {
                if (!this.isPartialFilter(filterCopy)) {
                    if ((filterCopy.getType() & 1) != 0) {
                        return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_includeOnly, null);
                    }
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_excludeAll, null);
                }
                return this.getFilterTypeName(filterCopy);
            }
            if (string.equals(FilterTypeUtil.TARGET)) {
                boolean bl;
                boolean bl2 = (filterCopy.getType() & 4) != 0;
                boolean bl3 = bl = (filterCopy.getType() & 8) != 0;
                if (bl2 && bl) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_filesAndFolders, null);
                }
                if (bl2) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_files, null);
                }
                if (bl) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_folders, null);
                }
            }
            if (string.equals(FilterTypeUtil.ARGUMENTS)) {
                if (filterCopy.hasStringArguments()) {
                    return filterCopy.getArguments();
                }
                if (filterCopy.getChildrenLimit() > 0 && !filterCopy.isUnderAGroupFilter()) {
                    return "< " + this.getFilterTypeName(filterCopy) + " >";
                }
            }
            return null;
        }

        private String getFilterTypeName(FilterCopy filterCopy) {
            FilterTypeManager.Descriptor descriptor = FilterTypeUtil.getDescriptor(filterCopy.getId());
            if (descriptor != null) {
                return descriptor.getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof FilterCopy) {
                return ((FilterCopy)object).getChildren();
            }
            return null;
        }

        public Object getParent(Object object) {
            if (object instanceof FilterCopy) {
                if (((FilterCopy)object).getParent() != null) {
                    return ((FilterCopy)object).getParent();
                }
                return ResourceFilterPage.this.filters;
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof FilterCopy) {
                FilterCopy[] filterCopyArray = ((FilterCopy)object).getChildren();
                return filterCopyArray != null && filterCopyArray.length > 0;
            }
            return false;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

