/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;

public class ResourceInfoPage
extends PropertyPage {
    private Button editableBox;
    private Button executableBox;
    private Button archiveBox;
    private Button derivedBox;
    private boolean previousReadOnlyValue;
    private boolean previousExecutableValue;
    private boolean previousArchiveValue;
    private boolean previousDerivedValue;
    private IContentDescription cachedContentDescription;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineDelimiterEditor;
    private static String READ_ONLY = IDEWorkbenchMessages.ResourceInfo_readOnly;
    private static String EXECUTABLE = IDEWorkbenchMessages.ResourceInfo_executable;
    private static String ARCHIVE = IDEWorkbenchMessages.ResourceInfo_archive;
    private static String DERIVED = IDEWorkbenchMessages.ResourceInfo_derived;
    private static String TYPE_TITLE = IDEWorkbenchMessages.ResourceInfo_type;
    private static String LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_location;
    private static String RESOLVED_LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_resolvedLocation;
    private static String SIZE_TITLE = IDEWorkbenchMessages.ResourceInfo_size;
    private static String PATH_TITLE = IDEWorkbenchMessages.ResourceInfo_path;
    private static String TIMESTAMP_TITLE = IDEWorkbenchMessages.ResourceInfo_lastModified;
    private static String FILE_ENCODING_TITLE = IDEWorkbenchMessages.WorkbenchPreference_encoding;
    private static String CONTAINER_ENCODING_TITLE = IDEWorkbenchMessages.ResourceInfo_fileEncodingTitle;
    private static String EDIT_TITLE = IDEWorkbenchMessages.ResourceInfo_edit;
    private Text resolvedLocationValue = null;
    private Text locationValue = null;
    private Text sizeValue = null;
    private IPath newResourceLocation = null;
    private static final int MAX_VALUE_WIDTH = 80;
    static /* synthetic */ Class class$0;

    private Composite createBasicInfoGroup(Composite composite, IResource iResource) {
        Text text;
        Label label;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        label2.setText(PATH_TITLE);
        GridData gridData2 = new GridData();
        gridData2.verticalAlignment = 128;
        label2.setLayoutData((Object)gridData2);
        Text text2 = new Text(composite2, 72);
        String string = TextProcessor.process((String)iResource.getFullPath().toString());
        text2.setText(string);
        gridData2 = new GridData();
        gridData2.widthHint = this.convertWidthInCharsToPixels(80);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalAlignment = 4;
        text2.setLayoutData((Object)gridData2);
        text2.setBackground(text2.getDisplay().getSystemColor(22));
        Label label3 = new Label(composite2, 16384);
        label3.setText(TYPE_TITLE);
        Text text3 = new Text(composite2, 16392);
        text3.setText(IDEResourceInfoUtils.getTypeString(iResource, this.getContentDescription(iResource)));
        text3.setBackground(text3.getDisplay().getSystemColor(22));
        if (iResource.isLinked()) {
            label = new Label(composite2, 16384);
            label.setText(LOCATION_TITLE);
            gridData2 = new GridData();
            gridData2.verticalAlignment = 128;
            label.setLayoutData((Object)gridData2);
            text = new Composite(composite2, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            text.setLayout((Layout)gridLayout);
            gridData2 = new GridData();
            gridData2.widthHint = this.convertWidthInCharsToPixels(80);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData2);
            this.locationValue = new Text((Composite)text, 72);
            String string2 = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(iResource));
            this.locationValue.setText(string2);
            gridData2 = new GridData();
            gridData2.widthHint = this.convertWidthInCharsToPixels(80);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            this.locationValue.setLayoutData((Object)gridData2);
            this.locationValue.setBackground(this.locationValue.getDisplay().getSystemColor(22));
            Button button = new Button((Composite)text, 8);
            button.setText(EDIT_TITLE);
            gridData2 = new GridData();
            gridData2.widthHint = this.convertWidthInCharsToPixels(EDIT_TITLE.length()) * 2 + 40;
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            button.setLayoutData((Object)gridData2);
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ResourceInfoPage.this.editLinkLocation();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ResourceInfoPage.this.editLinkLocation();
                }
            });
            Label label4 = new Label(composite2, 16384);
            label4.setText(RESOLVED_LOCATION_TITLE);
            gridData2 = new GridData();
            gridData2.verticalAlignment = 128;
            label4.setLayoutData((Object)gridData2);
            this.resolvedLocationValue = new Text(composite2, 72);
            this.resolvedLocationValue.setText(IDEResourceInfoUtils.getResolvedLocationText(iResource));
            gridData2 = new GridData();
            gridData2.widthHint = this.convertWidthInCharsToPixels(80);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            this.resolvedLocationValue.setLayoutData((Object)gridData2);
            this.resolvedLocationValue.setBackground(this.resolvedLocationValue.getDisplay().getSystemColor(22));
        } else if (!iResource.isGroup()) {
            label = new Label(composite2, 16384);
            label.setText(LOCATION_TITLE);
            gridData2 = new GridData();
            gridData2.verticalAlignment = 128;
            label.setLayoutData((Object)gridData2);
            text = new Text(composite2, 72);
            String string3 = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(iResource));
            text.setText(string3);
            gridData2 = new GridData();
            gridData2.widthHint = this.convertWidthInCharsToPixels(80);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData2);
            text.setBackground(text.getDisplay().getSystemColor(22));
        }
        if (iResource.getType() == 1) {
            label = new Label(composite2, 16384);
            label.setText(SIZE_TITLE);
            text = new Text(composite2, 16392);
            text.setText(IDEResourceInfoUtils.getSizeString(iResource));
            gridData2 = new GridData();
            gridData2.widthHint = this.convertWidthInCharsToPixels(80);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData2);
            text.setBackground(text.getDisplay().getSystemColor(22));
        }
        return composite2;
    }

    protected void editLinkLocation() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
        IPath iPath = Path.fromPortableString((String)this.locationValue.getText());
        PathVariableDialog pathVariableDialog = new PathVariableDialog(this.getShell(), 3, iResource.getType(), iResource.getProject().getPathVariableManager(), null);
        pathVariableDialog.setLinkLocation(iPath);
        pathVariableDialog.setProject(iResource.getProject());
        if (pathVariableDialog.open() == 1) {
            return;
        }
        this.newResourceLocation = iPath = Path.fromOSString((String)pathVariableDialog.getVariableValue());
        this.refreshLinkLocation();
    }

    private void refreshLinkLocation() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
        this.locationValue.setText(this.newResourceLocation.toPortableString());
        IPath iPath = iResource.getProject().getPathVariableManager().resolvePath(this.newResourceLocation);
        if (!IDEResourceInfoUtils.exists(iPath.toOSString())) {
            this.resolvedLocationValue.setText(IDEWorkbenchMessages.ResourceInfo_undefinedPathVariable);
            if (this.sizeValue != null) {
                this.sizeValue.setText(IDEWorkbenchMessages.ResourceInfo_notExist);
            }
        } else {
            this.resolvedLocationValue.setText(iPath.toPortableString());
            if (this.sizeValue != null) {
                IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(iPath.toPortableString());
                if (iFileInfo != null) {
                    this.sizeValue.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_bytes, (Object)Long.toString(iFileInfo.getLength())));
                } else {
                    this.sizeValue.setText(IDEWorkbenchMessages.ResourceInfo_unknown);
                }
            }
        }
    }

    protected Control createContents(Composite composite) {
        ResourceAttributes resourceAttributes;
        IResource iResource;
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.resource_info_property_page_context");
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            Label label = new Label(composite, 0);
            label.setText(IDEWorkbenchMessages.ResourceInfoPage_noResource);
            return label;
        }
        if (iResource.getType() != 4) {
            resourceAttributes = iResource.getResourceAttributes();
            if (resourceAttributes != null) {
                this.previousReadOnlyValue = resourceAttributes.isReadOnly();
                this.previousExecutableValue = resourceAttributes.isExecutable();
                this.previousArchiveValue = resourceAttributes.isArchive();
            } else {
                this.previousArchiveValue = false;
                this.previousExecutableValue = false;
                this.previousReadOnlyValue = false;
            }
            this.previousDerivedValue = iResource.isDerived();
        }
        resourceAttributes = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        resourceAttributes.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4);
        gridData.grabExcessHorizontalSpace = true;
        resourceAttributes.setLayoutData((Object)gridData);
        this.createBasicInfoGroup((Composite)resourceAttributes, iResource);
        this.createSeparator((Composite)resourceAttributes);
        this.createStateGroup((Composite)resourceAttributes, iResource);
        new Label((Composite)resourceAttributes, 0);
        this.encodingEditor = new ResourceEncodingFieldEditor(this.getFieldEditorLabel(iResource), (Composite)resourceAttributes, iResource);
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
                    ResourceInfoPage.this.setValid(ResourceInfoPage.this.encodingEditor.isValid());
                }
            }
        });
        if (iResource.getType() == 4) {
            this.lineDelimiterEditor = new LineDelimiterEditor((Composite)resourceAttributes, iResource.getProject());
            this.lineDelimiterEditor.doLoad();
        }
        if (iResource.getType() == 4 && !((IProject)iResource).isOpen()) {
            this.encodingEditor.setEnabled(false, (Composite)resourceAttributes);
            this.lineDelimiterEditor.setEnabled(false);
        }
        Dialog.applyDialogFont((Control)resourceAttributes);
        return resourceAttributes;
    }

    private String getFieldEditorLabel(IResource iResource) {
        if (iResource instanceof IContainer) {
            return CONTAINER_ENCODING_TITLE;
        }
        return FILE_ENCODING_TITLE;
    }

    private void createEditableButton(Composite composite) {
        this.editableBox = new Button(composite, 131104);
        this.editableBox.setAlignment(16384);
        this.editableBox.setText(READ_ONLY);
        this.editableBox.setSelection(this.previousReadOnlyValue);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.editableBox.setLayoutData((Object)gridData);
    }

    private void createExecutableButton(Composite composite) {
        this.executableBox = new Button(composite, 131104);
        this.executableBox.setAlignment(16384);
        this.executableBox.setText(EXECUTABLE);
        this.executableBox.setSelection(this.previousExecutableValue);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.executableBox.setLayoutData((Object)gridData);
    }

    private void createArchiveButton(Composite composite) {
        this.archiveBox = new Button(composite, 131104);
        this.archiveBox.setAlignment(16384);
        this.archiveBox.setText(ARCHIVE);
        this.archiveBox.setSelection(this.previousArchiveValue);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.archiveBox.setLayoutData((Object)gridData);
    }

    private void createDerivedButton(Composite composite) {
        this.derivedBox = new Button(composite, 131104);
        this.derivedBox.setAlignment(16384);
        this.derivedBox.setText(DERIVED);
        this.derivedBox.setSelection(this.previousDerivedValue);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.derivedBox.setLayoutData((Object)gridData);
    }

    private void createSeparator(Composite composite) {
        Label label = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    private void createStateGroup(Composite composite, IResource iResource) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(TIMESTAMP_TITLE);
        Text text = new Text(composite2, 8);
        text.setText(IDEResourceInfoUtils.getDateStringValue(iResource));
        text.setBackground(text.getDisplay().getSystemColor(22));
        text.setLayoutData((Object)new GridData(768));
        if (iResource.getType() != 4) {
            IFileSystem iFileSystem;
            URI uRI;
            if (!iResource.isGroup() && (uRI = iResource.getLocationURI()) != null && uRI.getScheme() != null) {
                try {
                    iFileSystem = EFS.getFileSystem((String)uRI.getScheme());
                    int n = iFileSystem.attributes();
                    if ((n & 2) != 0) {
                        this.createEditableButton(composite2);
                    }
                    if ((n & 4) != 0) {
                        this.createExecutableButton(composite2);
                    }
                    if ((n & 8) != 0) {
                        this.createArchiveButton(composite2);
                    }
                }
                catch (CoreException coreException) {}
            }
            this.createDerivedButton(composite2);
            if (this.executableBox != null && iResource.getType() == 2) {
                uRI = this.createNoteComposite(font, composite2, IDEWorkbenchMessages.Preference_note, IDEWorkbenchMessages.ResourceInfo_exWarning);
                iFileSystem = new GridData();
                iFileSystem.horizontalSpan = 2;
                uRI.setLayoutData(iFileSystem);
            }
        }
    }

    private IContentDescription getContentDescription(IResource iResource) {
        if (iResource.getType() != 1) {
            return null;
        }
        if (this.cachedContentDescription == null) {
            try {
                this.cachedContentDescription = ((IFile)iResource).getContentDescription();
            }
            catch (CoreException coreException) {}
        }
        return this.cachedContentDescription;
    }

    protected void performDefaults() {
        IResource iResource;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (this.newResourceLocation != null) {
            this.newResourceLocation = null;
            this.resolvedLocationValue.setText(IDEResourceInfoUtils.getResolvedLocationText(iResource));
            String string = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(iResource));
            this.locationValue.setText(string);
            if (this.sizeValue != null) {
                this.sizeValue.setText(IDEResourceInfoUtils.getSizeString(iResource));
            }
        }
        if (this.editableBox != null) {
            this.editableBox.setSelection(false);
        }
        if (this.executableBox != null) {
            this.executableBox.setSelection(false);
        }
        if (this.derivedBox != null) {
            this.derivedBox.setSelection(false);
        }
        this.encodingEditor.loadDefault();
        if (this.lineDelimiterEditor != null) {
            this.lineDelimiterEditor.loadDefault();
        }
    }

    public boolean performOk() {
        IResource iResource;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
            return true;
        }
        this.encodingEditor.store();
        if (this.lineDelimiterEditor != null) {
            this.lineDelimiterEditor.store();
        }
        try {
            boolean bl;
            ResourceAttributes resourceAttributes;
            if (this.newResourceLocation != null) {
                iResource.setLinkLocation(this.newResourceLocation, 0, (IProgressMonitor)new NullProgressMonitor());
            }
            if ((resourceAttributes = iResource.getResourceAttributes()) != null) {
                bl = false;
                if (this.editableBox != null && this.editableBox.getSelection() != this.previousReadOnlyValue) {
                    resourceAttributes.setReadOnly(this.editableBox.getSelection());
                    bl = true;
                }
                if (this.executableBox != null && this.executableBox.getSelection() != this.previousExecutableValue) {
                    resourceAttributes.setExecutable(this.executableBox.getSelection());
                    bl = true;
                }
                if (this.archiveBox != null && this.archiveBox.getSelection() != this.previousArchiveValue) {
                    resourceAttributes.setArchive(this.archiveBox.getSelection());
                    bl = true;
                }
                if (bl) {
                    iResource.setResourceAttributes(resourceAttributes);
                    resourceAttributes = iResource.getResourceAttributes();
                    if (resourceAttributes != null) {
                        this.previousReadOnlyValue = resourceAttributes.isReadOnly();
                        this.previousExecutableValue = resourceAttributes.isExecutable();
                        this.previousArchiveValue = resourceAttributes.isArchive();
                        if (this.editableBox != null) {
                            this.editableBox.setSelection(resourceAttributes.isReadOnly());
                        }
                        if (this.executableBox != null) {
                            this.executableBox.setSelection(resourceAttributes.isExecutable());
                        }
                        if (this.archiveBox != null) {
                            this.archiveBox.setSelection(resourceAttributes.isArchive());
                        }
                    }
                }
            }
            if (this.derivedBox != null && this.previousDerivedValue != (bl = this.derivedBox.getSelection())) {
                boolean bl2;
                iResource.setDerived(bl);
                this.previousDerivedValue = bl2 = iResource.isDerived();
                this.derivedBox.setSelection(bl2);
            }
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.InternalError, (String)coreException.getLocalizedMessage(), (IStatus)coreException.getStatus());
            return false;
        }
        return true;
    }
}

