/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;

public class ResourceTreeAndListGroup
extends EventManager
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private Collection expandedTreeNodes = new HashSet();
    private Map checkedStateStore = new HashMap(9);
    private Collection whiteCheckedTreeItems = new HashSet();
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;
    private static int PREFERRED_HEIGHT = 150;

    public ResourceTreeAndListGroup(Composite composite, Object object, ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider, IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider2, int n, boolean bl) {
        this.root = object;
        this.treeContentProvider = iTreeContentProvider;
        this.listContentProvider = iStructuredContentProvider;
        this.treeLabelProvider = iLabelProvider;
        this.listLabelProvider = iLabelProvider2;
        this.createContents(composite, n, bl);
    }

    public void aboutToOpen() {
        Object object;
        this.determineWhiteCheckedDescendents(this.root);
        this.checkNewTreeElements(this.treeContentProvider.getElements(this.root));
        this.currentTreeSelection = null;
        Object[] objectArray = this.treeContentProvider.getElements(this.root);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : null;
        if (object != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
        this.treeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.addListenerObject(iCheckStateListener);
    }

    protected boolean areAllChildrenWhiteChecked(Object object) {
        Object[] objectArray = this.treeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (!this.whiteCheckedTreeItems.contains(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean areAllElementsChecked(Object object) {
        List list = (List)this.checkedStateStore.get(object);
        if (list == null) {
            return false;
        }
        return this.getListItemsSize(object) == list.size();
    }

    protected void checkNewTreeElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            boolean bl = this.checkedStateStore.containsKey(object);
            this.treeViewer.setChecked(object, bl);
            this.treeViewer.setGrayed(object, bl && !this.whiteCheckedTreeItems.contains(object));
            ++n;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (checkStateChangedEvent.getCheckable().equals(ResourceTreeAndListGroup.this.treeViewer)) {
                    ResourceTreeAndListGroup.this.treeItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked());
                } else {
                    ResourceTreeAndListGroup.this.listItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked(), true);
                }
                ResourceTreeAndListGroup.this.notifyCheckStateChangeListeners(checkStateChangedEvent);
            }
        });
    }

    protected void createContents(Composite composite, int n, boolean bl) {
        Composite composite2 = new Composite(composite, n);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite2, bl);
        this.createListViewer(composite2, bl);
        this.initialize();
    }

    protected void createListViewer(Composite composite, boolean bl) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gridData = new GridData(1808);
        if (bl) {
            gridData.heightHint = PREFERRED_HEIGHT;
        }
        this.listViewer.getTable().setLayoutData((Object)gridData);
        this.listViewer.getTable().setFont(composite.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite composite, boolean bl) {
        Tree tree = new Tree(composite, 2080);
        GridData gridData = new GridData(1808);
        if (bl) {
            gridData.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)gridData);
        tree.setFont(composite.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object object) {
        List list = (List)this.checkedStateStore.get(object);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        if (this.expandedTreeNodes.contains(object)) {
            Object[] objectArray = this.treeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                if (this.checkedStateStore.containsKey(objectArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected boolean determineShouldBeWhiteChecked(Object object) {
        return this.areAllChildrenWhiteChecked(object) && this.areAllElementsChecked(object);
    }

    protected void determineWhiteCheckedDescendents(Object object) {
        Object[] objectArray = this.treeContentProvider.getElements(object);
        int n = 0;
        while (n < objectArray.length) {
            this.determineWhiteCheckedDescendents(objectArray[n]);
            ++n;
        }
        if (this.determineShouldBeWhiteChecked(object)) {
            this.setWhiteChecked(object, true);
        }
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    private void expandTreeElement(final Object object) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (ResourceTreeAndListGroup.this.expandedTreeNodes.contains(object)) {
                    ResourceTreeAndListGroup.this.checkNewTreeElements(ResourceTreeAndListGroup.this.treeContentProvider.getChildren(object));
                } else {
                    ResourceTreeAndListGroup.this.expandedTreeNodes.add(object);
                    if (ResourceTreeAndListGroup.this.whiteCheckedTreeItems.contains(object)) {
                        Object[] objectArray = ResourceTreeAndListGroup.this.treeContentProvider.getChildren(object);
                        int n = 0;
                        while (n < objectArray.length) {
                            if (!ResourceTreeAndListGroup.this.whiteCheckedTreeItems.contains(objectArray[n])) {
                                Object object2 = objectArray[n];
                                ResourceTreeAndListGroup.this.setWhiteChecked(object2, true);
                                ResourceTreeAndListGroup.this.treeViewer.setChecked(object2, true);
                                ResourceTreeAndListGroup.this.checkedStateStore.put(object2, new ArrayList());
                            }
                            ++n;
                        }
                        ResourceTreeAndListGroup.this.setListForWhiteSelection(object);
                    }
                }
            }
        });
    }

    private void findAllSelectedListElements(Object object, String string, boolean bl, IElementFilter iElementFilter, IProgressMonitor iProgressMonitor) throws InterruptedException {
        String string2 = null;
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        if (iProgressMonitor != null) {
            string2 = this.getFullLabel(object, string);
            iProgressMonitor.subTask(string2);
        }
        if (bl) {
            iElementFilter.filterElements(this.listContentProvider.getElements(object), iProgressMonitor);
        } else if (this.checkedStateStore.containsKey(object)) {
            iElementFilter.filterElements((Collection)this.checkedStateStore.get(object), iProgressMonitor);
        }
        Object[] objectArray = this.treeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (bl) {
                this.findAllSelectedListElements(object2, string2, true, iElementFilter, iProgressMonitor);
            } else if (this.checkedStateStore.containsKey(object2)) {
                this.findAllSelectedListElements(object2, string2, this.whiteCheckedTreeItems.contains(object2), iElementFilter, iProgressMonitor);
            }
            ++n;
        }
    }

    private void findAllWhiteCheckedItems(Object object, Collection collection) {
        if (this.whiteCheckedTreeItems.contains(object)) {
            collection.add(object);
        } else {
            Collection collection2 = (Collection)this.checkedStateStore.get(object);
            if (collection2 == null) {
                return;
            }
            collection.addAll(collection2);
            Object[] objectArray = this.treeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                this.findAllWhiteCheckedItems(objectArray[n], collection);
                ++n;
            }
        }
    }

    public void getAllCheckedListItems(IElementFilter iElementFilter, IProgressMonitor iProgressMonitor) throws InterruptedException {
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = 0;
        while (n < objectArray.length) {
            this.findAllSelectedListElements(objectArray[n], null, this.whiteCheckedTreeItems.contains(objectArray[n]), iElementFilter, iProgressMonitor);
            ++n;
        }
    }

    public List getAllCheckedListItems() {
        final ArrayList arrayList = new ArrayList();
        IElementFilter iElementFilter = new IElementFilter(){

            public void filterElements(Collection collection, IProgressMonitor iProgressMonitor) {
                arrayList.addAll(collection);
            }

            public void filterElements(Object[] objectArray, IProgressMonitor iProgressMonitor) {
                int n = 0;
                while (n < objectArray.length) {
                    arrayList.add(objectArray[n]);
                    ++n;
                }
            }
        };
        try {
            this.getAllCheckedListItems(iElementFilter, null);
        }
        catch (InterruptedException interruptedException) {
            return new ArrayList();
        }
        return arrayList;
    }

    public List getAllWhiteCheckedItems() {
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = 0;
        while (n < objectArray.length) {
            this.findAllWhiteCheckedItems(objectArray[n], arrayList);
            ++n;
        }
        return arrayList;
    }

    public int getCheckedElementCount() {
        return this.checkedStateStore.size();
    }

    protected String getFullLabel(Object object, String string) {
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        Path path = new Path(string2);
        String string3 = this.treeLabelProvider.getText(object);
        if (string3 == null) {
            return path.toString();
        }
        return path.append(string3).toString();
    }

    protected int getListItemsSize(Object object) {
        Object[] objectArray = this.listContentProvider.getElements(object);
        return objectArray.length;
    }

    public Table getListTable() {
        return this.listViewer.getTable();
    }

    protected void grayCheckHierarchy(Object object) {
        this.expandTreeElement(object);
        if (this.checkedStateStore.containsKey(object)) {
            return;
        }
        this.checkedStateStore.put(object, new ArrayList());
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 != null) {
            this.grayCheckHierarchy(object2);
        }
    }

    private void grayUpdateHierarchy(Object object) {
        Object object2;
        boolean bl = this.determineShouldBeAtLeastGrayChecked(object);
        this.treeViewer.setGrayChecked(object, bl);
        if (this.whiteCheckedTreeItems.contains(object)) {
            this.whiteCheckedTreeItems.remove(object);
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.grayUpdateHierarchy(object2);
        }
    }

    public void initialCheckListItem(Object object) {
        Object object2 = this.treeContentProvider.getParent(object);
        this.selectAndReveal(object2);
        this.listViewer.setChecked(object, true);
        this.listItemChecked(object, true, false);
        this.grayUpdateHierarchy(object2);
    }

    public void initialCheckTreeItem(Object object) {
        this.treeItemChecked(object, true);
        this.selectAndReveal(object);
    }

    private void selectAndReveal(Object object) {
        this.treeViewer.reveal(object);
        StructuredSelection structuredSelection = new StructuredSelection(object);
        this.treeViewer.setSelection((ISelection)structuredSelection);
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
        this.expandedTreeNodes = new ArrayList();
        this.expandedTreeNodes.add(this.root);
    }

    protected void listItemChecked(Object object, boolean bl, boolean bl2) {
        List list = (List)this.checkedStateStore.get(this.currentTreeSelection);
        if (!this.expandedTreeNodes.contains(this.currentTreeSelection)) {
            this.expandTreeElement(this.currentTreeSelection);
        }
        if (bl) {
            if (list == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                list = (List)this.checkedStateStore.get(this.currentTreeSelection);
            }
            list.add(object);
        } else {
            list.remove(object);
            if (list.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (list.size() > 0) {
            this.checkedStateStore.put(this.currentTreeSelection, list);
        }
        if (bl2) {
            this.grayUpdateHierarchy(this.currentTreeSelection);
        }
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent checkStateChangedEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICheckStateListener iCheckStateListener = (ICheckStateListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iCheckStateListener.checkStateChanged(checkStateChangedEvent);
                }
            });
            ++n;
        }
    }

    protected void populateListViewer(final Object object) {
        this.listViewer.setInput(object);
        if (!this.expandedTreeNodes.contains(object) && this.whiteCheckedTreeItems.contains(object)) {
            BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ResourceTreeAndListGroup.this.setListForWhiteSelection(object);
                    ResourceTreeAndListGroup.this.listViewer.setAllChecked(true);
                }
            });
        } else {
            List list = (List)this.checkedStateStore.get(object);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.listViewer.setChecked(iterator.next(), true);
                }
            }
        }
    }

    private void primeHierarchyForSelection(Object object, Set set) {
        if (set.contains(object)) {
            return;
        }
        this.checkedStateStore.put(object, new ArrayList());
        this.expandedTreeNodes.add(object);
        set.add(object);
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 != null) {
            this.primeHierarchyForSelection(object2, set);
        }
    }

    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.removeListenerObject(iCheckStateListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (object != this.currentTreeSelection) {
            this.populateListViewer(object);
        }
        this.currentTreeSelection = object;
    }

    public void setAllSelections(final boolean bl) {
        if (this.root == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResourceTreeAndListGroup.this.setTreeChecked(ResourceTreeAndListGroup.this.root, bl);
                ResourceTreeAndListGroup.this.listViewer.setAllChecked(bl);
            }
        });
    }

    private void setListForWhiteSelection(Object object) {
        Object[] objectArray = this.listContentProvider.getElements(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        this.checkedStateStore.put(object, arrayList);
    }

    public void setListProviders(IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider) {
        this.listViewer.setContentProvider((IContentProvider)iStructuredContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setListComparator(ViewerComparator viewerComparator) {
        this.listViewer.setComparator(viewerComparator);
    }

    public void setRoot(Object object) {
        this.root = object;
        this.initialize();
    }

    protected void setTreeChecked(Object object, boolean bl) {
        if (object.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(bl);
        }
        if (bl) {
            this.setListForWhiteSelection(object);
        } else {
            this.checkedStateStore.remove(object);
        }
        this.setWhiteChecked(object, bl);
        this.treeViewer.setChecked(object, bl);
        this.treeViewer.setGrayed(object, false);
        if (this.expandedTreeNodes.contains(object)) {
            Object[] objectArray = this.treeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                this.setTreeChecked(objectArray[n], bl);
                ++n;
            }
        }
    }

    public void setTreeProviders(ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)iTreeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setTreeComparator(ViewerComparator viewerComparator) {
        this.treeViewer.setComparator(viewerComparator);
    }

    protected void setWhiteChecked(Object object, boolean bl) {
        if (bl) {
            if (!this.whiteCheckedTreeItems.contains(object)) {
                this.whiteCheckedTreeItems.add(object);
            }
        } else {
            this.whiteCheckedTreeItems.remove(object);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.expandTreeElement(treeExpansionEvent.getElement());
    }

    protected void treeItemChecked(Object object, boolean bl) {
        this.setTreeChecked(object, bl);
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        if (bl) {
            this.grayCheckHierarchy(object2);
        } else {
            this.ungrayCheckHierarchy(object2);
        }
        this.grayUpdateHierarchy(object2);
    }

    protected void ungrayCheckHierarchy(Object object) {
        Object object2;
        if (!this.determineShouldBeAtLeastGrayChecked(object)) {
            this.checkedStateStore.remove(object);
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.ungrayCheckHierarchy(object2);
        }
    }

    protected void updateHierarchy(Object object) {
        boolean bl = this.determineShouldBeWhiteChecked(object);
        boolean bl2 = this.determineShouldBeAtLeastGrayChecked(object);
        this.treeViewer.setChecked(object, bl2);
        this.setWhiteChecked(object, bl);
        if (bl) {
            this.treeViewer.setGrayed(object, false);
        } else {
            this.treeViewer.setGrayed(object, bl2);
        }
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 != null) {
            this.grayUpdateHierarchy(object2);
        }
    }

    public void updateSelections(Map map) {
        Object object;
        this.listViewer.setAllChecked(false);
        this.treeViewer.setCheckedElements(new Object[0]);
        this.whiteCheckedTreeItems = new HashSet();
        HashSet hashSet = new HashSet();
        this.checkedStateStore = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            List list = (List)map.get(object);
            this.checkedStateStore.put(object, list);
            hashSet.add(object);
            Object object2 = this.treeContentProvider.getParent(object);
            if (object2 == null) continue;
            this.primeHierarchyForSelection(object2, hashSet);
        }
        this.treeViewer.setCheckedElements(this.checkedStateStore.keySet().toArray());
        this.treeViewer.setGrayedElements(this.checkedStateStore.keySet().toArray());
        if (this.currentTreeSelection != null && (object = map.get(this.currentTreeSelection)) != null) {
            this.listViewer.setCheckedElements(((List)object).toArray());
        }
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }
}

