/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer tree;
    private IWorkingSet workingSet;
    private boolean firstCheck = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ResourceWorkingSetPage() {
        super("resourceWorkingSetPage", IDEWorkbenchMessages.ResourceWorkingSetPage_title, IDEInternalWorkbenchImages.getImageDescriptor("IMG_WIZBAN_EXPORTZIP_WIZ"));
        this.setDescription(IDEWorkbenchMessages.ResourceWorkingSetPage_description);
    }

    private void addWorkingSetElements(List list, IContainer iContainer) {
        IAdaptable[] iAdaptableArray = this.workingSet.getElements();
        IPath iPath = iContainer.getFullPath();
        int n = 0;
        while (n < iAdaptableArray.length) {
            IPath iPath2;
            IResource iResource = null;
            if (iAdaptableArray[n] instanceof IResource) {
                iResource = (IResource)iAdaptableArray[n];
            } else {
                IAdaptable iAdaptable = iAdaptableArray[n];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null && iPath.isPrefixOf(iPath2 = iResource.getFullPath())) {
                list.add(iAdaptableArray[n]);
            }
            ++n;
        }
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.ide.working_set_resource_page");
        Label label = new Label(composite2, 64);
        label.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_message);
        GridData gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.text = new Text(composite2, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite2, 64);
        label.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_label_tree);
        gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.tree = new CheckboxTreeViewer(composite2);
        this.tree.setUseHashlookup(true);
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        this.tree.setContentProvider((IContentProvider)workbenchContentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), IDEWorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tree.setInput((Object)IDEWorkbenchPlugin.getPluginWorkspace().getRoot());
        this.tree.setComparator((ViewerComparator)new ResourceComparator(1));
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 50;
        this.tree.getControl().setLayoutData((Object)gridData);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ResourceWorkingSetPage.this.handleCheckStateChange(checkStateChangedEvent);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Object object = treeExpansionEvent.getElement();
                if (!ResourceWorkingSetPage.this.tree.getGrayed(object)) {
                    BusyIndicator.showWhile((Display)ResourceWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, object){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            ResourceWorkingSetPage.access$3(3.access$0(this.this$1), (IContainer)this.val$element, ResourceWorkingSetPage.access$2(3.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ ResourceWorkingSetPage access$0(3 var0) {
                return var0.ResourceWorkingSetPage.this;
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(256));
        Button button = new Button(composite3, 8);
        button.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_selectAll_label);
        button.setToolTipText(IDEWorkbenchMessages.ResourceWorkingSetPage_selectAll_toolTip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter((ITreeContentProvider)workbenchContentProvider){
            private final /* synthetic */ ITreeContentProvider val$treeContentProvider;
            {
                this.val$treeContentProvider = iTreeContentProvider;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                BusyIndicator.showWhile((Display)ResourceWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, this.val$treeContentProvider){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ ITreeContentProvider val$treeContentProvider;
                    {
                        this.this$1 = var1_1;
                        this.val$treeContentProvider = iTreeContentProvider;
                    }

                    public void run() {
                        ResourceWorkingSetPage.access$2(5.access$0(this.this$1)).setCheckedElements(this.val$treeContentProvider.getElements(ResourceWorkingSetPage.access$2(5.access$0(this.this$1)).getInput()));
                        ResourceWorkingSetPage.access$3(5.access$0(this.this$1), (IContainer)ResourceWorkingSetPage.access$2(5.access$0(this.this$1)).getInput(), true, false);
                    }
                });
                ResourceWorkingSetPage.this.validateInput();
            }

            static /* synthetic */ ResourceWorkingSetPage access$0(5 var0) {
                return var0.ResourceWorkingSetPage.this;
            }
        });
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite3, 8);
        button2.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_deselectAll_label);
        button2.setToolTipText(IDEWorkbenchMessages.ResourceWorkingSetPage_deselectAll_toolTip);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter((ITreeContentProvider)workbenchContentProvider){
            private final /* synthetic */ ITreeContentProvider val$treeContentProvider;
            {
                this.val$treeContentProvider = iTreeContentProvider;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                BusyIndicator.showWhile((Display)ResourceWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, this.val$treeContentProvider){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ ITreeContentProvider val$treeContentProvider;
                    {
                        this.this$1 = var1_1;
                        this.val$treeContentProvider = iTreeContentProvider;
                    }

                    public void run() {
                        ResourceWorkingSetPage.access$2(7.access$0(this.this$1)).setCheckedElements(this.val$treeContentProvider.getElements(ResourceWorkingSetPage.access$2(7.access$0(this.this$1)).getInput()));
                        ResourceWorkingSetPage.access$3(7.access$0(this.this$1), (IContainer)ResourceWorkingSetPage.access$2(7.access$0(this.this$1)).getInput(), false, false);
                    }
                });
                ResourceWorkingSetPage.this.validateInput();
            }

            static /* synthetic */ ResourceWorkingSetPage access$0(7 var0) {
                return var0.ResourceWorkingSetPage.this;
            }
        });
        this.setButtonLayoutData(button2);
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
        Dialog.applyDialogFont((Control)composite2);
    }

    private void findCheckedResources(List list, IContainer iContainer) {
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, this.getShell(), IDEWorkbenchMessages.ResourceWorkingSetPage_error, IDEWorkbenchMessages.ResourceWorkingSetPage_error_updateCheckedState);
        }
        int n = 0;
        while (n < iResourceArray.length) {
            if (this.tree.getGrayed((Object)iResourceArray[n])) {
                if (iResourceArray[n].isAccessible()) {
                    this.findCheckedResources(list, (IContainer)iResourceArray[n]);
                } else {
                    this.addWorkingSetElements(list, (IContainer)iResourceArray[n]);
                }
            } else if (this.tree.getChecked((Object)iResourceArray[n])) {
                list.add(iResourceArray[n]);
            }
            ++n;
        }
    }

    public void finish() {
        ArrayList arrayList = new ArrayList(10);
        this.findCheckedResources(arrayList, (IContainer)this.tree.getInput());
        if (this.workingSet == null) {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = iWorkingSetManager.createWorkingSet(this.getWorkingSetName(), arrayList.toArray(new IAdaptable[arrayList.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    private void handleCheckStateChange(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IResource iResource = (IResource)checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                ResourceWorkingSetPage.this.tree.setGrayed((Object)iResource, false);
                if (iResource instanceof IContainer) {
                    ResourceWorkingSetPage.this.setSubtreeChecked((IContainer)iResource, bl, true);
                }
                ResourceWorkingSetPage.this.updateParentState(iResource);
                ResourceWorkingSetPage.this.validateInput();
            }
        });
    }

    private void handleCoreException(CoreException coreException, Shell shell, String string, String string2) {
        IStatus iStatus = coreException.getStatus();
        if (iStatus != null) {
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
        } else {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.InternalError, (String)coreException.getLocalizedMessage());
        }
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ISelection iSelection;
                IWorkbenchPart iWorkbenchPart;
                Object[] objectArray = null;
                if (ResourceWorkingSetPage.this.workingSet == null) {
                    IWorkbenchPage iWorkbenchPage = IDEWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (iWorkbenchPage == null) {
                        return;
                    }
                    iWorkbenchPart = iWorkbenchPage.getActivePart();
                    if (iWorkbenchPart == null) {
                        return;
                    }
                    iSelection = iWorkbenchPage.getSelection();
                    if (iSelection instanceof IStructuredSelection) {
                        objectArray = ((IStructuredSelection)iSelection).toArray();
                    }
                } else {
                    objectArray = ResourceWorkingSetPage.this.workingSet.getElements();
                }
                if (objectArray == null) {
                    return;
                }
                ResourceWorkingSetPage.this.tree.setCheckedElements(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    iWorkbenchPart = null;
                    if (objectArray[n] instanceof IAdaptable) {
                        iWorkbenchPart = (IAdaptable)objectArray[n];
                        iSelection = null;
                        IResource iResource = null;
                        if (iWorkbenchPart instanceof IContainer) {
                            iSelection = (IContainer)iWorkbenchPart;
                        } else {
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.core.resources.IContainer");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iSelection = (IContainer)iWorkbenchPart.getAdapter((Class)clazz);
                        }
                        if (iSelection != null) {
                            ResourceWorkingSetPage.this.setSubtreeChecked((IContainer)iSelection, true, true);
                        }
                        if (iWorkbenchPart instanceof IResource) {
                            iResource = (IResource)iWorkbenchPart;
                        } else {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iResource = (IResource)iWorkbenchPart.getAdapter((Class)clazz);
                        }
                        if (iResource != null && !iResource.isAccessible()) {
                            IProject iProject = iResource.getProject();
                            if (!ResourceWorkingSetPage.this.tree.getChecked((Object)iProject)) {
                                ResourceWorkingSetPage.this.tree.setGrayChecked((Object)iProject, true);
                            }
                        } else {
                            ResourceWorkingSetPage.this.updateParentState(iResource);
                        }
                    }
                    ++n;
                }
            }
        });
    }

    public void setSelection(IWorkingSet iWorkingSet) {
        if (iWorkingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.workingSet = iWorkingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(iWorkingSet.getName());
        }
    }

    private void setSubtreeChecked(IContainer iContainer, boolean bl, boolean bl2) {
        if (!iContainer.isAccessible() || !this.tree.getExpandedState((Object)iContainer) && bl && bl2) {
            return;
        }
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, this.getShell(), IDEWorkbenchMessages.ResourceWorkingSetPage_error, IDEWorkbenchMessages.ResourceWorkingSetPage_error_updateCheckedState);
        }
        int n = iResourceArray.length - 1;
        while (n >= 0) {
            boolean bl3;
            IResource iResource = iResourceArray[n];
            boolean bl4 = bl3 = this.tree.getGrayed((Object)iResource) || this.tree.getChecked((Object)iResource);
            if (bl) {
                this.tree.setChecked((Object)iResource, true);
                this.tree.setGrayed((Object)iResource, false);
            } else {
                this.tree.setGrayChecked((Object)iResource, false);
            }
            if (iResource instanceof IContainer && (bl || bl3)) {
                this.setSubtreeChecked((IContainer)iResource, bl, true);
            }
            --n;
        }
    }

    private void updateParentState(IResource iResource) {
        if (iResource == null || iResource.getParent() == null) {
            return;
        }
        IContainer iContainer = iResource.getParent();
        boolean bl = false;
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, this.getShell(), IDEWorkbenchMessages.ResourceWorkingSetPage_error, IDEWorkbenchMessages.ResourceWorkingSetPage_error_updateCheckedState);
        }
        int n = iResourceArray.length - 1;
        while (n >= 0) {
            if (this.tree.getChecked((Object)iResourceArray[n]) || this.tree.getGrayed((Object)iResourceArray[n])) {
                bl = true;
                break;
            }
            --n;
        }
        this.tree.setGrayChecked((Object)iContainer, bl);
        this.updateParentState((IResource)iContainer);
    }

    private void validateInput() {
        String string = null;
        String string2 = null;
        String string3 = this.text.getText();
        if (!string3.equals(string3.trim())) {
            string = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_nameWhitespace;
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if (string3.equals("")) {
            string = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        if (!(string != null || this.workingSet != null && string3.equals(this.workingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (string3.equals(iWorkingSetArray[n].getName())) {
                    string = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_workingSetExists;
                }
                ++n;
            }
        }
        if (string2 == null && this.tree.getCheckedElements().length == 0) {
            string2 = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_resourceMustBeChecked;
        }
        this.setMessage(string2, 1);
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }
}

