/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorCopyAction;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.internal.ide.dialogs.WelcomeItem;
import org.eclipse.ui.internal.ide.dialogs.WelcomeParser;
import org.eclipse.ui.part.EditorPart;
import org.xml.sax.SAXException;

public class WelcomeEditor
extends EditorPart {
    private static final int HORZ_SCROLL_INCREMENT = 20;
    private static final int VERT_SCROLL_INCREMENT = 20;
    private static final int WRAP_MIN_WIDTH = 150;
    private Composite editorComposite;
    private Cursor handCursor;
    private Cursor busyCursor;
    private WelcomeParser parser;
    private ArrayList hyperlinkRanges = new ArrayList();
    private ArrayList texts = new ArrayList();
    private ScrolledComposite scrolledComposite;
    private IPropertyChangeListener colorListener;
    private boolean mouseDown = false;
    private boolean dragEvent = false;
    private StyledText firstText;
    private StyledText lastText;
    private StyledText lastNavigatedText;
    private StyledText currentText;
    private boolean nextTabAbortTraversal;
    private boolean previousTabAbortTraversal = false;
    private WelcomeEditorCopyAction copyAction;

    public WelcomeEditor() {
        this.setPartName(IDEWorkbenchMessages.WelcomeEditor_title);
        this.copyAction = new WelcomeEditorCopyAction(this);
        this.copyAction.setEnabled(false);
    }

    private void focusOn(StyledText styledText, int n) {
        if (styledText == null) {
            return;
        }
        styledText.setFocus();
        styledText.setCaretOffset(n);
        this.scrolledComposite.setOrigin(0, styledText.getLocation().y);
    }

    private StyledText nextText(StyledText styledText) {
        int n = 0;
        if (styledText == null) {
            return (StyledText)this.texts.get(0);
        }
        n = this.texts.indexOf(styledText);
        if (n < this.texts.size() - 1) {
            return (StyledText)this.texts.get(n + 1);
        }
        return (StyledText)this.texts.get(0);
    }

    private StyledText previousText(StyledText styledText) {
        int n = 0;
        if (styledText == null) {
            return (StyledText)this.texts.get(0);
        }
        n = this.texts.indexOf(styledText);
        if (n == 0) {
            return (StyledText)this.texts.get(this.texts.size() - 1);
        }
        return (StyledText)this.texts.get(n - 1);
    }

    protected StyledText getCurrentText() {
        return this.currentText;
    }

    protected WelcomeEditorCopyAction getCopyAction() {
        return this.copyAction;
    }

    private StyleRange findNextLink(StyledText styledText) {
        if (styledText == null) {
            return null;
        }
        WelcomeItem welcomeItem = (WelcomeItem)styledText.getData();
        StyleRange[] styleRangeArray = styledText.getStyleRanges();
        int n = styledText.getSelection().y;
        int n2 = 0;
        while (n2 < styleRangeArray.length) {
            if (styleRangeArray[n2].start >= n && welcomeItem.isLinkAt(styleRangeArray[n2].start)) {
                return styleRangeArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private StyleRange findPreviousLink(StyledText styledText) {
        if (styledText == null) {
            return null;
        }
        WelcomeItem welcomeItem = (WelcomeItem)styledText.getData();
        StyleRange[] styleRangeArray = styledText.getStyleRanges();
        int n = styledText.getSelection().x;
        int n2 = styleRangeArray.length - 1;
        while (n2 > -1) {
            if (styleRangeArray[n2].start + styleRangeArray[n2].length < n && welcomeItem.isLinkAt(styleRangeArray[n2].start + styleRangeArray[n2].length - 1)) {
                return styleRangeArray[n2];
            }
            --n2;
        }
        return null;
    }

    protected StyleRange getCurrentLink(StyledText styledText) {
        StyleRange[] styleRangeArray = styledText.getStyleRanges();
        int n = styledText.getSelection().y;
        int n2 = styledText.getSelection().x;
        int n3 = 0;
        while (n3 < styleRangeArray.length) {
            if (n2 >= styleRangeArray[n3].start && n <= styleRangeArray[n3].start + styleRangeArray[n3].length) {
                return styleRangeArray[n3];
            }
            ++n3;
        }
        return null;
    }

    private void addListeners(StyledText styledText) {
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button != 1) {
                    return;
                }
                WelcomeEditor.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent mouseEvent) {
                WelcomeEditor.this.mouseDown = false;
                StyledText styledText = (StyledText)mouseEvent.widget;
                WelcomeItem welcomeItem = (WelcomeItem)mouseEvent.widget.getData();
                int n = styledText.getCaretOffset();
                if (WelcomeEditor.this.dragEvent) {
                    WelcomeEditor.this.dragEvent = false;
                    if (welcomeItem.isLinkAt(n)) {
                        styledText.setCursor(WelcomeEditor.this.handCursor);
                    }
                } else if (welcomeItem.isLinkAt(n)) {
                    styledText.setCursor(WelcomeEditor.this.busyCursor);
                    if (mouseEvent.button == 1) {
                        welcomeItem.triggerLinkAt(n);
                        StyleRange styleRange = WelcomeEditor.this.getCurrentLink(styledText);
                        styledText.setSelectionRange(styleRange.start, styleRange.length);
                        styledText.setCursor(null);
                    }
                }
            }
        });
        styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (WelcomeEditor.this.mouseDown) {
                    if (!WelcomeEditor.this.dragEvent) {
                        StyledText styledText = (StyledText)mouseEvent.widget;
                        styledText.setCursor(null);
                    }
                    WelcomeEditor.this.dragEvent = true;
                    return;
                }
                StyledText styledText = (StyledText)mouseEvent.widget;
                WelcomeItem welcomeItem = (WelcomeItem)mouseEvent.widget.getData();
                int n = -1;
                try {
                    n = styledText.getOffsetAtLocation(new Point(mouseEvent.x, mouseEvent.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (n == -1) {
                    styledText.setCursor(null);
                } else if (welcomeItem.isLinkAt(n)) {
                    styledText.setCursor(WelcomeEditor.this.handCursor);
                } else {
                    styledText.setCursor(null);
                }
            }
        });
        styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                StyledText styledText = (StyledText)traverseEvent.widget;
                switch (traverseEvent.detail) {
                    case 2: {
                        traverseEvent.doit = true;
                        break;
                    }
                    case 16: {
                        if ((traverseEvent.stateMask & 0x40000) != 0) {
                            if (traverseEvent.widget == WelcomeEditor.this.lastText) {
                                return;
                            }
                            traverseEvent.doit = false;
                            WelcomeEditor.this.nextTabAbortTraversal = true;
                            WelcomeEditor.this.lastText.traverse(16);
                            return;
                        }
                        if (WelcomeEditor.this.nextTabAbortTraversal) {
                            WelcomeEditor.this.nextTabAbortTraversal = false;
                            return;
                        }
                        StyleRange styleRange = WelcomeEditor.this.findNextLink(styledText);
                        if (styleRange == null) {
                            StyledText styledText2 = WelcomeEditor.this.nextText(styledText);
                            styledText2.setSelection(0);
                            WelcomeEditor.this.focusOn(styledText2, 0);
                        } else {
                            WelcomeEditor.this.focusOn(styledText, styledText.getSelection().x);
                            styledText.setSelectionRange(styleRange.start, styleRange.length);
                        }
                        traverseEvent.detail = 0;
                        traverseEvent.doit = true;
                        break;
                    }
                    case 8: {
                        if ((traverseEvent.stateMask & 0x40000) != 0) {
                            if (traverseEvent.widget == WelcomeEditor.this.firstText) {
                                return;
                            }
                            traverseEvent.doit = false;
                            WelcomeEditor.this.previousTabAbortTraversal = true;
                            WelcomeEditor.this.firstText.traverse(8);
                            return;
                        }
                        if (WelcomeEditor.this.previousTabAbortTraversal) {
                            WelcomeEditor.this.previousTabAbortTraversal = false;
                            return;
                        }
                        StyleRange styleRange = WelcomeEditor.this.findPreviousLink(styledText);
                        if (styleRange == null) {
                            if (styledText.getSelection().x == 0) {
                                StyledText styledText3 = WelcomeEditor.this.previousText(styledText);
                                styledText3.setSelection(styledText3.getCharCount());
                                styleRange = WelcomeEditor.this.findPreviousLink(styledText3);
                                if (styleRange == null) {
                                    WelcomeEditor.this.focusOn(styledText3, 0);
                                } else {
                                    WelcomeEditor.this.focusOn(styledText3, styledText3.getSelection().x);
                                    styledText3.setSelectionRange(styleRange.start, styleRange.length);
                                }
                            } else {
                                WelcomeEditor.this.focusOn(styledText, 0);
                            }
                        } else {
                            WelcomeEditor.this.focusOn(styledText, styledText.getSelection().x);
                            styledText.setSelectionRange(styleRange.start, styleRange.length);
                        }
                        traverseEvent.detail = 0;
                        traverseEvent.doit = true;
                        break;
                    }
                }
            }
        });
        styledText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                StyledText styledText = (StyledText)keyEvent.widget;
                if (keyEvent.character == ' ' || keyEvent.character == '\r') {
                    int n;
                    WelcomeItem welcomeItem;
                    if (styledText != null && (welcomeItem = (WelcomeItem)styledText.getData()).isLinkAt(n = styledText.getSelection().x + 1)) {
                        styledText.setCursor(WelcomeEditor.this.busyCursor);
                        welcomeItem.triggerLinkAt(n);
                        StyleRange styleRange = WelcomeEditor.this.getCurrentLink(styledText);
                        styledText.setSelectionRange(styleRange.start, styleRange.length);
                        styledText.setCursor(null);
                    }
                    return;
                }
                if (keyEvent.keyCode == 0x1000006) {
                    WelcomeEditor.this.focusOn(WelcomeEditor.this.nextText(styledText), 0);
                    return;
                }
                if (keyEvent.keyCode == 0x1000005) {
                    WelcomeEditor.this.focusOn(WelcomeEditor.this.previousText(styledText), 0);
                    return;
                }
            }
        });
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                WelcomeEditor.this.lastNavigatedText = (StyledText)focusEvent.widget;
            }

            public void focusGained(FocusEvent focusEvent) {
                WelcomeEditor.this.currentText = (StyledText)focusEvent.widget;
                if (WelcomeEditor.this.currentText != WelcomeEditor.this.lastNavigatedText && WelcomeEditor.this.lastNavigatedText != null) {
                    WelcomeEditor.this.lastNavigatedText.setSelection(((WelcomeEditor)WelcomeEditor.this).lastNavigatedText.getSelection().x);
                }
                WelcomeEditor.this.copyAction.setEnabled(WelcomeEditor.this.currentText.getSelectionCount() > 0);
            }
        });
        styledText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StyledText styledText = (StyledText)selectionEvent.widget;
                WelcomeEditor.this.copyAction.setEnabled(styledText.getSelectionCount() > 0);
            }
        });
    }

    private Composite createInfoArea(Composite composite) {
        Label label;
        GridData gridData;
        StyledText styledText;
        this.scrolledComposite = new ScrolledComposite(composite, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(1808));
        final Composite composite2 = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(1808);
        composite2.setLayoutData((Object)gridData2);
        boolean bl = this.parser.isFormatWrapped();
        int n = 20;
        Display display = composite.getDisplay();
        Color color = JFaceColors.getBannerBackground((Display)display);
        Color color2 = JFaceColors.getBannerForeground((Display)display);
        composite2.setBackground(color);
        int n2 = 10;
        if (bl) {
            n2 |= 0x40;
        }
        StyledText styledText2 = null;
        WelcomeItem welcomeItem = this.getIntroItem();
        if (welcomeItem != null) {
            styledText = new StyledText(composite2, n2);
            this.texts.add(styledText);
            styledText2 = styledText;
            styledText.setCursor(null);
            JFaceColors.setColors((Control)styledText, (Color)color2, (Color)color);
            styledText.setText(this.getIntroItem().getText());
            this.setBoldRanges(styledText, welcomeItem.getBoldRanges());
            this.setLinkRanges(styledText, welcomeItem.getActionRanges());
            this.setLinkRanges(styledText, welcomeItem.getHelpRanges());
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.horizontalIndent = n;
            gridData.verticalAlignment = 2;
            styledText.setLayoutData((Object)gridData);
            styledText.setData((Object)welcomeItem);
            this.addListeners(styledText);
            Label label2 = new Label(composite2, 0);
            label2.setBackground(color);
            gridData = new GridData(2);
            gridData.horizontalSpan = 2;
            label2.setLayoutData((Object)gridData);
        }
        this.firstText = styledText2;
        styledText = null;
        gridData = this.getItems();
        int n3 = 0;
        while (n3 < ((WelcomeItem[])gridData).length) {
            label = new Label(composite2, 0);
            label.setBackground(color);
            label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WELCOME_ITEM"));
            GridData gridData3 = new GridData();
            gridData3.horizontalIndent = n;
            gridData3.verticalAlignment = 2;
            label.setLayoutData((Object)gridData3);
            if (styledText == null) {
                styledText = label;
            }
            StyledText styledText3 = new StyledText(composite2, n2);
            this.texts.add(styledText3);
            styledText2 = styledText3;
            styledText3.setCursor(null);
            JFaceColors.setColors((Control)styledText3, (Color)color2, (Color)color);
            styledText3.setText(gridData[n3].getText());
            this.setBoldRanges(styledText3, gridData[n3].getBoldRanges());
            this.setLinkRanges(styledText3, gridData[n3].getActionRanges());
            this.setLinkRanges(styledText3, gridData[n3].getHelpRanges());
            gridData3 = new GridData(768);
            gridData3.verticalAlignment = 2;
            gridData3.verticalSpan = 2;
            styledText3.setLayoutData((Object)gridData3);
            styledText3.setData((Object)gridData[n3]);
            this.addListeners(styledText3);
            Label label3 = new Label(composite2, 0);
            label3.setBackground(color);
            gridData3 = new GridData(2);
            gridData3.horizontalSpan = 2;
            label3.setLayoutData((Object)gridData3);
            MenuManager menuManager = new MenuManager("#PopUp");
            menuManager.add((IAction)this.copyAction);
            styledText3.setMenu(menuManager.createContextMenu((Control)styledText3));
            ++n3;
        }
        this.lastText = styledText2;
        this.scrolledComposite.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1, true);
        this.scrolledComposite.setMinHeight(point.y);
        if (bl) {
            this.scrolledComposite.setMinWidth(150);
        } else {
            this.scrolledComposite.setMinWidth(point.x);
        }
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        if (bl && styledText != null) {
            label = styledText.getBounds();
            final int n4 = n + label.width + gridLayout.verticalSpacing + gridLayout.marginWidth * 2;
            final int n5 = n + gridLayout.marginWidth * 2;
            composite2.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    int n = ((WelcomeEditor)WelcomeEditor.this).scrolledComposite.getClientArea().width;
                    if (n < 150) {
                        n = 150;
                    }
                    int n2 = 0;
                    while (n2 < WelcomeEditor.this.texts.size()) {
                        int n3 = n2 == 0 ? n - n5 : n - n4;
                        StyledText styledText = (StyledText)WelcomeEditor.this.texts.get(n2);
                        Point point = styledText.computeSize(n3, -1, false);
                        ((GridData)styledText.getLayoutData()).widthHint = point.x;
                        ++n2;
                    }
                    Point point = composite2.computeSize(-1, -1, true);
                    WelcomeEditor.this.scrolledComposite.setMinHeight(point.y);
                }
            });
        }
        if (styledText2 == null) {
            this.scrolledComposite.getHorizontalBar().setIncrement(20);
            this.scrolledComposite.getVerticalBar().setIncrement(20);
        } else {
            label = new GC((Drawable)styledText2);
            int n6 = label.getFontMetrics().getAverageCharWidth();
            label.dispose();
            this.scrolledComposite.getHorizontalBar().setIncrement(n6);
            this.scrolledComposite.getVerticalBar().setIncrement(styledText2.getLineHeight());
        }
        return composite2;
    }

    public void createPartControl(Composite composite) {
        this.readFile();
        if (this.parser == null) {
            return;
        }
        this.handCursor = new Cursor((Device)composite.getDisplay(), 21);
        this.busyCursor = new Cursor((Device)composite.getDisplay(), 1);
        this.editorComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.editorComposite.setLayout((Layout)gridLayout);
        this.createTitleArea(this.editorComposite);
        Label label = new Label(this.editorComposite, 258);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.createInfoArea(this.editorComposite);
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)this.editorComposite, "org.eclipse.ui.ide.welcome_editor_context");
        this.colorListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("HYPERLINK_COLOR")) {
                    Color color = JFaceColors.getHyperlinkText((Display)WelcomeEditor.this.editorComposite.getDisplay());
                    Iterator iterator = WelcomeEditor.this.hyperlinkRanges.iterator();
                    while (iterator.hasNext()) {
                        StyleRange styleRange = (StyleRange)iterator.next();
                        styleRange.foreground = color;
                    }
                }
            }
        };
        JFacePreferences.getPreferenceStore().addPropertyChangeListener(this.colorListener);
    }

    private Composite createTitleArea(Composite composite) {
        Display display = composite.getDisplay();
        Color color = JFaceColors.getBannerBackground((Display)display);
        Color color2 = JFaceColors.getBannerForeground((Display)display);
        Composite composite2 = new Composite(composite, 524288);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setBackground(color);
        final CLabel cLabel = new CLabel(composite2, 16384){

            protected String shortenText(GC gC, String string, int n) {
                if (gC.textExtent((String)string, (int)8).x <= n) {
                    return string;
                }
                int n2 = gC.textExtent((String)"...", (int)8).x;
                int n3 = string.length();
                int n4 = n3 - 1;
                while (n4 > 0) {
                    string = string.substring(0, n4);
                    int n5 = gC.textExtent((String)string, (int)8).x;
                    if (n5 + n2 <= n) {
                        return String.valueOf(string) + "...";
                    }
                    --n4;
                }
                return String.valueOf(string) + "...";
            }
        };
        JFaceColors.setColors((Control)cLabel, (Color)color2, (Color)color);
        cLabel.setText(this.getBannerTitle());
        cLabel.setFont(JFaceResources.getHeaderFont());
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.eclipse.jface.headerfont".equals(propertyChangeEvent.getProperty())) {
                    cLabel.setFont(JFaceResources.getHeaderFont());
                }
            }
        };
        cLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        GridData gridData = new GridData(1808);
        cLabel.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setBackground(color);
        label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WELCOME_BANNER"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        label.setLayoutData((Object)gridData);
        return composite2;
    }

    public void dispose() {
        super.dispose();
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        if (this.colorListener != null) {
            JFacePreferences.getPreferenceStore().removePropertyChangeListener(this.colorListener);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    private String getBannerTitle() {
        if (this.parser.getTitle() == null) {
            return "";
        }
        return this.parser.getTitle();
    }

    private WelcomeItem getIntroItem() {
        return this.parser.getIntroItem();
    }

    private WelcomeItem[] getItems() {
        return this.parser.getItems();
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof WelcomeEditorInput)) {
            throw new PartInitException("Invalid Input: Must be WelcomeEditorInput");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void read(InputStream inputStream) throws IOException {
        try {
            this.parser = new WelcomeParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (IOException)new IOException().initCause(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException().initCause(sAXException);
        }
        this.parser.parse(inputStream);
    }

    public void readFile() {
        block15: {
            URL uRL = ((WelcomeEditorInput)this.getEditorInput()).getAboutInfo().getWelcomePageURL();
            if (uRL == null) {
                return;
            }
            InputStream inputStream = null;
            try {
                try {
                    inputStream = uRL.openStream();
                    this.read(inputStream);
                }
                catch (IOException iOException) {
                    Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.WelcomeEditor_accessException, (Throwable)iOException);
                    IDEWorkbenchPlugin.log(IDEWorkbenchMessages.WelcomeEditor_readFileError, (IStatus)status);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void setBoldRanges(StyledText styledText, int[][] nArray) {
        int n = 0;
        while (n < nArray.length) {
            StyleRange styleRange = new StyleRange(nArray[n][0], nArray[n][1], null, null, 1);
            styledText.setStyleRange(styleRange);
            ++n;
        }
    }

    public void setFocus() {
        if (this.editorComposite != null && this.lastNavigatedText == null && this.currentText == null) {
            this.editorComposite.setFocus();
        }
    }

    private void setLinkRanges(StyledText styledText, int[][] nArray) {
        Color color = JFaceColors.getHyperlinkText((Display)styledText.getShell().getDisplay());
        int n = 0;
        while (n < nArray.length) {
            StyleRange styleRange = new StyleRange(nArray[n][0], nArray[n][1], color, null);
            styledText.setStyleRange(styleRange);
            this.hyperlinkRanges.add(styleRange);
            ++n;
        }
    }
}

