/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.framework.Bundle;

public class WelcomeItem {
    private String text;
    private int[][] boldRanges;
    private int[][] helpRanges;
    private String[] helpIds;
    private String[] helpHrefs;
    private int[][] actionRanges;
    private String[] actionPluginIds;
    private String[] actionClasses;

    public WelcomeItem(String string, int[][] nArray, int[][] nArray2, String[] stringArray, String[] stringArray2, int[][] nArray3, String[] stringArray3, String[] stringArray4) {
        this.text = string;
        this.boldRanges = nArray;
        this.actionRanges = nArray2;
        this.actionPluginIds = stringArray;
        this.actionClasses = stringArray2;
        this.helpRanges = nArray3;
        this.helpIds = stringArray3;
        this.helpHrefs = stringArray4;
    }

    public int[][] getActionRanges() {
        return this.actionRanges;
    }

    public int[][] getBoldRanges() {
        return this.boldRanges;
    }

    public int[][] getHelpRanges() {
        return this.helpRanges;
    }

    public String getText() {
        return this.text;
    }

    public boolean isLinkAt(int n) {
        int n2 = 0;
        while (n2 < this.helpRanges.length) {
            if (n >= this.helpRanges[n2][0] && n < this.helpRanges[n2][0] + this.helpRanges[n2][1]) {
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.actionRanges.length) {
            if (n >= this.actionRanges[n2][0] && n < this.actionRanges[n2][0] + this.actionRanges[n2][1]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void logActionLinkError(String string, String string2) {
        IDEWorkbenchPlugin.log(String.valueOf(IDEWorkbenchMessages.WelcomeItem_unableToLoadClass) + string + " " + string2);
    }

    private void openHelpTopic(String string, String string2) {
        if (string2 != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string2);
        } else {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
        }
    }

    private void runAction(String string, String string2) {
        IAction iAction;
        Class clazz;
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            this.logActionLinkError(string, string2);
            return;
        }
        try {
            clazz = bundle.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logActionLinkError(string, string2);
            return;
        }
        try {
            iAction = (IAction)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.logActionLinkError(string, string2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logActionLinkError(string, string2);
            return;
        }
        catch (ClassCastException classCastException) {
            this.logActionLinkError(string, string2);
            return;
        }
        iAction.run();
    }

    public void triggerLinkAt(int n) {
        int n2 = 0;
        while (n2 < this.helpRanges.length) {
            if (n >= this.helpRanges[n2][0] && n < this.helpRanges[n2][0] + this.helpRanges[n2][1]) {
                this.openHelpTopic(this.helpIds[n2], this.helpHrefs[n2]);
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.actionRanges.length) {
            if (n >= this.actionRanges[n2][0] && n < this.actionRanges[n2][0] + this.actionRanges[n2][1]) {
                this.runAction(this.actionPluginIds[n2], this.actionClasses[n2]);
                return;
            }
            ++n2;
        }
    }
}

