/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeItem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WelcomeParser
extends DefaultHandler {
    private static final String TAG_WELCOME_PAGE = "welcomePage";
    private static final String TAG_INTRO = "intro";
    private static final String TAG_ITEM = "item";
    private static final String TAG_BOLD = "b";
    private static final String TAG_ACTION = "action";
    private static final String TAG_PARAGRAPH = "p";
    private static final String TAG_TOPIC = "topic";
    private static final String ATT_TITLE = "title";
    private static final String ATT_FORMAT = "format";
    private static final String ATT_PLUGIN_ID = "pluginId";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ID = "id";
    private static final String ATT_HREF = "href";
    private static final String FORMAT_WRAP = "wrap";
    private static final char DELIMITER = '\n';
    private SAXParser parser;
    private String title;
    private WelcomeItem introItem;
    private ArrayList items = new ArrayList();
    private String format;

    public WelcomeParser() throws ParserConfigurationException, SAXException, FactoryConfigurationError {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        this.parser = sAXParserFactory.newSAXParser();
        this.parser.getXMLReader().setContentHandler(this);
        this.parser.getXMLReader().setDTDHandler(this);
        this.parser.getXMLReader().setEntityResolver(this);
        this.parser.getXMLReader().setErrorHandler(this);
    }

    public WelcomeItem getIntroItem() {
        return this.introItem;
    }

    public WelcomeItem[] getItems() {
        return this.items.toArray(new WelcomeItem[this.items.size()]);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isFormatWrapped() {
        return FORMAT_WRAP.equals(this.format);
    }

    public void parse(InputStream inputStream) {
        try {
            this.parser.parse(new InputSource(inputStream), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.WelcomeParser_parseException, (Throwable)sAXException);
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.WelcomeParser_parseError, (IStatus)status);
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.WelcomeParser_parseException, (Throwable)iOException);
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.WelcomeParser_parseError, (IStatus)status);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals(TAG_WELCOME_PAGE)) {
            WelcomePageHandler welcomePageHandler = new WelcomePageHandler(attributes.getValue(ATT_TITLE));
            this.format = attributes.getValue(ATT_FORMAT);
            welcomePageHandler.setParent(this);
            this.parser.getXMLReader().setContentHandler(welcomePageHandler);
        }
    }

    private class IntroItemHandler
    extends ItemHandler {
        private IntroItemHandler() {
            super(null, null);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals(WelcomeParser.TAG_INTRO)) {
                WelcomeParser.this.introItem = this.constructWelcomeItem();
                WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
            } else if (string2.equals(WelcomeParser.TAG_PARAGRAPH)) {
                this.wrapRanges.add(new int[]{this.wrapStart, this.offset - this.wrapStart});
            }
        }
    }

    private class ItemHandler
    extends WelcomeContentHandler {
        private ArrayList boldRanges = new ArrayList();
        protected ArrayList wrapRanges = new ArrayList();
        private ArrayList actionRanges = new ArrayList();
        private ArrayList pluginIds = new ArrayList();
        private ArrayList classes = new ArrayList();
        private ArrayList helpRanges = new ArrayList();
        private ArrayList helpIds = new ArrayList();
        private ArrayList helpHrefs = new ArrayList();
        private StringBuffer text = new StringBuffer();
        protected int offset = 0;
        protected int textStart;
        protected int wrapStart;

        private ItemHandler() {
        }

        protected WelcomeItem constructWelcomeItem() {
            if (WelcomeParser.this.isFormatWrapped()) {
                int n = 0;
                while (n < this.wrapRanges.size()) {
                    int[] nArray = (int[])this.wrapRanges.get(n);
                    int n2 = nArray[0];
                    int n3 = nArray[1];
                    int n4 = n2;
                    while (n4 < n2 + n3) {
                        char c = this.text.charAt(n4);
                        if (c == '\n') {
                            this.text.replace(n4, n4 + 1, " ");
                        }
                        ++n4;
                    }
                    ++n;
                }
            }
            return new WelcomeItem(this.text.toString(), (int[][])this.boldRanges.toArray((T[])new int[this.boldRanges.size()][2]), (int[][])this.actionRanges.toArray((T[])new int[this.actionRanges.size()][2]), this.pluginIds.toArray(new String[this.pluginIds.size()]), this.classes.toArray(new String[this.classes.size()]), (int[][])this.helpRanges.toArray((T[])new int[this.helpRanges.size()][2]), this.helpIds.toArray(new String[this.helpIds.size()]), this.helpHrefs.toArray(new String[this.helpHrefs.size()]));
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            int n3 = 0;
            while (n3 < n2) {
                this.text.append(cArray[n + n3]);
                ++n3;
            }
            this.offset += n2;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.textStart = this.offset;
            if (string2.equals(WelcomeParser.TAG_BOLD)) {
                BoldHandler boldHandler = new BoldHandler();
                boldHandler.setParent(this);
                WelcomeParser.this.parser.getXMLReader().setContentHandler(boldHandler);
            } else if (string2.equals(WelcomeParser.TAG_ACTION)) {
                ActionHandler actionHandler = new ActionHandler(attributes.getValue(WelcomeParser.ATT_PLUGIN_ID), attributes.getValue(WelcomeParser.ATT_CLASS));
                actionHandler.setParent(this);
                WelcomeParser.this.parser.getXMLReader().setContentHandler(actionHandler);
            } else if (string2.equals(WelcomeParser.TAG_PARAGRAPH)) {
                this.wrapStart = this.textStart;
            } else if (string2.equals(WelcomeParser.TAG_TOPIC)) {
                TopicHandler topicHandler = new TopicHandler(attributes.getValue(WelcomeParser.ATT_ID), attributes.getValue(WelcomeParser.ATT_HREF));
                topicHandler.setParent(this);
                WelcomeParser.this.parser.getXMLReader().setContentHandler(topicHandler);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals(WelcomeParser.TAG_ITEM)) {
                WelcomeParser.this.items.add(this.constructWelcomeItem());
                WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
            } else if (string2.equals(WelcomeParser.TAG_PARAGRAPH)) {
                this.wrapRanges.add(new int[]{this.wrapStart, this.offset - this.wrapStart});
            }
        }

        /* synthetic */ ItemHandler(ItemHandler itemHandler, ItemHandler itemHandler2) {
            this();
        }

        private class ActionHandler
        extends WelcomeContentHandler {
            public ActionHandler(String string, String string2) {
                ItemHandler.this.pluginIds.add(string);
                ItemHandler.this.classes.add(string2);
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                ItemHandler.this.characters(cArray, n, n2);
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (string2.equals(WelcomeParser.TAG_ACTION)) {
                    ItemHandler.this.actionRanges.add(new int[]{ItemHandler.this.textStart, ItemHandler.this.offset - ItemHandler.this.textStart});
                    WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
                }
            }
        }

        private class BoldHandler
        extends WelcomeContentHandler {
            private BoldHandler() {
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                ItemHandler.this.characters(cArray, n, n2);
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (string2.equals(WelcomeParser.TAG_BOLD)) {
                    ItemHandler.this.boldRanges.add(new int[]{ItemHandler.this.textStart, ItemHandler.this.offset - ItemHandler.this.textStart});
                    WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
                }
            }
        }

        private class TopicHandler
        extends WelcomeContentHandler {
            public TopicHandler(String string, String string2) {
                ItemHandler.this.helpIds.add(string);
                ItemHandler.this.helpHrefs.add(string2);
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                ItemHandler.this.characters(cArray, n, n2);
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (string2.equals(WelcomeParser.TAG_TOPIC)) {
                    ItemHandler.this.helpRanges.add(new int[]{ItemHandler.this.textStart, ItemHandler.this.offset - ItemHandler.this.textStart});
                    WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
                }
            }
        }
    }

    private class WelcomeContentHandler
    implements ContentHandler {
        protected ContentHandler parent;

        private WelcomeContentHandler() {
        }

        public void setParent(ContentHandler contentHandler) {
            this.parent = contentHandler;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }
    }

    private class WelcomePageHandler
    extends WelcomeContentHandler {
        public WelcomePageHandler(String string) {
            WelcomeParser.this.title = string;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals(WelcomeParser.TAG_INTRO)) {
                IntroItemHandler introItemHandler = new IntroItemHandler();
                introItemHandler.setParent(this);
                WelcomeParser.this.parser.getXMLReader().setContentHandler(introItemHandler);
            } else if (string2.equals(WelcomeParser.TAG_ITEM)) {
                ItemHandler itemHandler = new ItemHandler();
                itemHandler.setParent(this);
                WelcomeParser.this.parser.getXMLReader().setContentHandler(itemHandler);
            }
        }
    }
}

