/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.filesystem;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemMessages;

public class FileSystemSupportRegistry
implements IExtensionChangeHandler {
    private static final String FILESYSTEM_SUPPORT = "filesystemSupport";
    protected static final String ATT_CLASS = "class";
    private static final String LABEL = "label";
    private static final String SCHEME = "scheme";
    private static FileSystemSupportRegistry singleton;
    private Collection registeredContributions = new HashSet(0);
    FileSystemConfiguration defaultConfiguration = new FileSystemConfiguration(FileSystemMessages.DefaultFileSystem_name, new FileSystemContributor(){

        public URI browseFileSystem(String string, Shell shell) {
            Object object;
            DirectoryDialog directoryDialog = new DirectoryDialog(shell);
            directoryDialog.setMessage(IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel);
            if (!string.equals("") && (object = IDEResourceInfoUtils.getFileInfo(string)) != null && object.exists()) {
                directoryDialog.setFilterPath(string);
            }
            if ((object = directoryDialog.open()) == null) {
                return null;
            }
            return new File((String)object).toURI();
        }
    }, null);
    private FileSystemConfiguration[] allConfigurations;

    public static FileSystemSupportRegistry getInstance() {
        if (singleton == null) {
            singleton = new FileSystemSupportRegistry();
        }
        return singleton;
    }

    public FileSystemSupportRegistry() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.ide", FILESYSTEM_SUPPORT);
        if (iExtensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            this.processExtension(iExtensionTracker, iExtension);
            ++n;
        }
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)iExtensionPoint));
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        this.processExtension(iExtensionTracker, iExtension);
        this.allConfigurations = null;
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.registeredContributions.remove(objectArray[n]);
            ++n;
        }
        this.allConfigurations = null;
    }

    private void processExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            FileSystemConfiguration fileSystemConfiguration = this.newConfiguration(iConfigurationElement);
            this.registeredContributions.add(fileSystemConfiguration);
            iExtensionTracker.registerObject(iExtension, (Object)fileSystemConfiguration, 0);
            ++n;
        }
    }

    private FileSystemConfiguration newConfiguration(final IConfigurationElement iConfigurationElement) {
        final FileSystemContributor[] fileSystemContributorArray = new FileSystemContributor[1];
        final CoreException[] coreExceptionArray = new CoreException[1];
        Platform.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    fileSystemContributorArray[0] = (FileSystemContributor)IDEWorkbenchPlugin.createExtension(iConfigurationElement, FileSystemSupportRegistry.ATT_CLASS);
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }

            public void handleException(Throwable throwable) {
            }
        });
        if (coreExceptionArray[0] != null) {
            return null;
        }
        String string = iConfigurationElement.getAttribute(LABEL);
        String string2 = iConfigurationElement.getAttribute(SCHEME);
        FileSystemConfiguration fileSystemConfiguration = new FileSystemConfiguration(string, fileSystemContributorArray[0], string2);
        return fileSystemConfiguration;
    }

    public FileSystemConfiguration[] getConfigurations() {
        if (this.allConfigurations == null) {
            this.allConfigurations = new FileSystemConfiguration[this.registeredContributions.size() + 1];
            this.allConfigurations[0] = this.defaultConfiguration;
            Iterator iterator = this.registeredContributions.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.allConfigurations[++n] = (FileSystemConfiguration)iterator.next();
            }
        }
        return this.allConfigurations;
    }

    public FileSystemConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public boolean hasOneFileSystem() {
        return this.registeredContributions.size() == 0;
    }
}

