/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.dialogs.OpenResourceDialog;

public final class OpenResourceHandler
extends Action
implements IHandler,
IWorkbenchWindowActionDelegate {
    private static final String PARAM_ID_FILE_PATH = "filePath";
    private transient ListenerList listenerList = null;

    public OpenResourceHandler() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_workspace_file_action_context");
    }

    public final void addHandlerListener(IHandlerListener iHandlerListener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)iHandlerListener);
    }

    public final void dispose() {
        this.listenerList = null;
    }

    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IResource iResource;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (executionEvent.getParameter(PARAM_ID_FILE_PATH) == null) {
            iResource = this.queryFileResource();
            if (iResource != null) {
                int n = 0;
                while (n < ((IResource)iResource).length) {
                    if (iResource[n] instanceof IFile) {
                        arrayList.add(iResource[n]);
                    }
                    ++n;
                }
            }
        } else {
            iResource = (IResource)executionEvent.getObjectParameterForExecution(PARAM_ID_FILE_PATH);
            if (!(iResource instanceof IFile)) {
                throw new ExecutionException("filePath parameter must identify a file");
            }
            arrayList.add(iResource);
        }
        if (arrayList.size() > 0) {
            iResource = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (iResource == null) {
                throw new ExecutionException("no active workbench window");
            }
            IWorkbenchPage iWorkbenchPage = iResource.getActivePage();
            if (iWorkbenchPage == null) {
                throw new ExecutionException("no active workbench page");
            }
            try {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    IDE.openEditor(iWorkbenchPage, (IFile)iterator.next(), true);
                }
            }
            catch (PartInitException partInitException) {
                throw new ExecutionException("error opening file in editor", (Throwable)partInitException);
            }
        }
        return null;
    }

    public final void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    private final Object[] queryFileResource() {
        IWorkspaceRoot iWorkspaceRoot;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        Shell shell = iWorkbenchWindow.getShell();
        OpenResourceDialog openResourceDialog = new OpenResourceDialog(shell, (IContainer)(iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()), 1);
        int n = openResourceDialog.open();
        if (n != 0) {
            return null;
        }
        Object[] objectArray = openResourceDialog.getResult();
        return objectArray;
    }

    public final void removeHandlerListener(IHandlerListener iHandlerListener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)iHandlerListener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    public final void run(IAction iAction) {
        try {
            this.execute(new ExecutionEvent());
        }
        catch (ExecutionException executionException) {}
    }

    public final void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

