/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class CheckboxTreeAndListGroup
extends EventManager
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private List expandedTreeNodes = new ArrayList();
    private Map checkedStateStore = new HashMap(9);
    private List whiteCheckedTreeItems = new ArrayList();
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;

    public CheckboxTreeAndListGroup(Composite composite, Object object, ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider, IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider2, int n, int n2, int n3) {
        this.root = object;
        this.treeContentProvider = iTreeContentProvider;
        this.listContentProvider = iStructuredContentProvider;
        this.treeLabelProvider = iLabelProvider;
        this.listLabelProvider = iLabelProvider2;
        this.createContents(composite, n2, n3, n);
    }

    public void aboutToOpen() {
        Object object;
        this.determineWhiteCheckedDescendents(this.root);
        this.checkNewTreeElements(this.treeContentProvider.getElements(this.root));
        this.currentTreeSelection = null;
        Object[] objectArray = this.treeContentProvider.getElements(this.root);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : null;
        if (object != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
        this.treeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.addListenerObject(iCheckStateListener);
    }

    private void addToHierarchyToCheckedStore(Object object) {
        Object object2;
        if (!this.checkedStateStore.containsKey(object)) {
            this.checkedStateStore.put(object, new ArrayList());
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.addToHierarchyToCheckedStore(object2);
        }
    }

    protected boolean areAllChildrenWhiteChecked(Object object) {
        Object[] objectArray = this.treeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (!this.whiteCheckedTreeItems.contains(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean areAllElementsChecked(Object object) {
        List list = (List)this.checkedStateStore.get(object);
        if (list == null) {
            return false;
        }
        return this.getListItemsSize(object) == list.size();
    }

    protected void checkNewTreeElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            boolean bl = this.checkedStateStore.containsKey(object);
            this.treeViewer.setChecked(object, bl);
            this.treeViewer.setGrayed(object, bl && !this.whiteCheckedTreeItems.contains(object));
            ++n;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (checkStateChangedEvent.getCheckable().equals(CheckboxTreeAndListGroup.this.treeViewer)) {
                    CheckboxTreeAndListGroup.this.treeItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked());
                } else {
                    CheckboxTreeAndListGroup.this.listItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked(), true);
                }
                CheckboxTreeAndListGroup.this.notifyCheckStateChangeListeners(checkStateChangedEvent);
            }
        });
    }

    protected void createContents(Composite composite, int n, int n2, int n3) {
        Composite composite2 = new Composite(composite, n3);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        this.createTreeViewer(composite2, n / 2, n2);
        this.createListViewer(composite2, n / 2, n2);
        this.initialize();
    }

    protected void createListViewer(Composite composite, int n, int n2) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        this.listViewer.getTable().setLayoutData((Object)gridData);
        this.listViewer.getTable().setFont(composite.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite composite, int n, int n2) {
        Tree tree = new Tree(composite, 2080);
        GridData gridData = new GridData(1808);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        tree.setLayoutData((Object)gridData);
        tree.setFont(composite.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object object) {
        List list = (List)this.checkedStateStore.get(object);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        Object[] objectArray = this.treeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (this.checkedStateStore.containsKey(objectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean determineShouldBeWhiteChecked(Object object) {
        return this.areAllChildrenWhiteChecked(object) && this.areAllElementsChecked(object);
    }

    protected void determineWhiteCheckedDescendents(Object object) {
        Object[] objectArray = this.treeContentProvider.getElements(object);
        int n = 0;
        while (n < objectArray.length) {
            this.determineWhiteCheckedDescendents(objectArray[n]);
            ++n;
        }
        if (this.determineShouldBeWhiteChecked(object)) {
            this.setWhiteChecked(object, true);
        }
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    public Iterator getAllCheckedListItems() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.checkedStateStore.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList.iterator();
    }

    public Set getAllCheckedTreeItems() {
        return this.checkedStateStore.keySet();
    }

    public int getCheckedElementCount() {
        return this.checkedStateStore.size();
    }

    protected int getListItemsSize(Object object) {
        Object[] objectArray = this.listContentProvider.getElements(object);
        return objectArray.length;
    }

    public Table getListTable() {
        return this.listViewer.getTable();
    }

    protected void grayCheckHierarchy(Object object) {
        Object object2;
        if (this.checkedStateStore.containsKey(object)) {
            return;
        }
        this.checkedStateStore.put(object, new ArrayList());
        if (this.determineShouldBeWhiteChecked(object)) {
            this.setWhiteChecked(object, true);
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.grayCheckHierarchy(object2);
        }
    }

    public void initialCheckListItem(Object object) {
        Object object2;
        this.currentTreeSelection = object2 = this.treeContentProvider.getParent(object);
        this.listItemChecked(object, true, false);
        this.updateHierarchy(object2);
    }

    public void initialCheckTreeItem(Object object) {
        this.treeItemChecked(object, true);
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
    }

    protected void listItemChecked(Object object, boolean bl, boolean bl2) {
        List list = (List)this.checkedStateStore.get(this.currentTreeSelection);
        if (bl) {
            if (list == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                list = (List)this.checkedStateStore.get(this.currentTreeSelection);
            }
            list.add(object);
        } else {
            list.remove(object);
            if (list.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (bl2) {
            this.updateHierarchy(this.currentTreeSelection);
        }
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent checkStateChangedEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICheckStateListener iCheckStateListener = (ICheckStateListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iCheckStateListener.checkStateChanged(checkStateChangedEvent);
                }
            });
            ++n;
        }
    }

    protected void populateListViewer(Object object) {
        this.listViewer.setInput(object);
        List list = (List)this.checkedStateStore.get(object);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.listViewer.setChecked(iterator.next(), true);
            }
        }
    }

    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.removeListenerObject(iCheckStateListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (object != this.currentTreeSelection) {
            this.populateListViewer(object);
        }
        this.currentTreeSelection = object;
    }

    public void setAllSelections(final boolean bl) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CheckboxTreeAndListGroup.this.setTreeChecked(CheckboxTreeAndListGroup.this.root, bl);
                CheckboxTreeAndListGroup.this.listViewer.setAllChecked(bl);
            }
        });
    }

    public void setListProviders(IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider) {
        this.listViewer.setContentProvider((IContentProvider)iStructuredContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setListComparator(ViewerComparator viewerComparator) {
        this.listViewer.setComparator(viewerComparator);
    }

    public void setRoot(Object object) {
        this.root = object;
        this.initialize();
    }

    protected void setTreeChecked(Object object, boolean bl) {
        Object[] objectArray;
        if (object.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(bl);
        }
        if (bl) {
            objectArray = this.listContentProvider.getElements(object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n]);
                ++n;
            }
            this.checkedStateStore.put(object, arrayList);
        } else {
            this.checkedStateStore.remove(object);
        }
        this.setWhiteChecked(object, bl);
        this.treeViewer.setChecked(object, bl);
        this.treeViewer.setGrayed(object, false);
        objectArray = this.treeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            this.setTreeChecked(objectArray[n], bl);
            ++n;
        }
    }

    public void setTreeProviders(ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)iTreeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setTreeComparator(ViewerComparator viewerComparator) {
        this.treeViewer.setComparator(viewerComparator);
    }

    protected void setWhiteChecked(Object object, boolean bl) {
        if (bl) {
            if (!this.whiteCheckedTreeItems.contains(object)) {
                this.whiteCheckedTreeItems.add(object);
            }
        } else {
            this.whiteCheckedTreeItems.remove(object);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getElement();
        if (!this.expandedTreeNodes.contains(object)) {
            this.expandedTreeNodes.add(object);
            this.checkNewTreeElements(this.treeContentProvider.getChildren(object));
        }
    }

    protected void treeItemChecked(Object object, boolean bl) {
        this.setTreeChecked(object, bl);
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        if (bl) {
            this.grayCheckHierarchy(object2);
        } else {
            this.ungrayCheckHierarchy(object2);
        }
        this.updateHierarchy(object);
    }

    protected void ungrayCheckHierarchy(Object object) {
        Object object2;
        if (!this.determineShouldBeAtLeastGrayChecked(object)) {
            this.checkedStateStore.remove(object);
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.ungrayCheckHierarchy(object2);
        }
    }

    protected void updateHierarchy(Object object) {
        Object object2;
        boolean bl = this.determineShouldBeWhiteChecked(object);
        boolean bl2 = this.determineShouldBeAtLeastGrayChecked(object);
        this.treeViewer.setChecked(object, bl2);
        this.setWhiteChecked(object, bl);
        if (!bl) {
            this.treeViewer.setGrayed(object, bl2);
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.updateHierarchy(object2);
        }
    }

    public void updateSelections(final Map map) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object k;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    k = iterator.next();
                    List list = (List)map.get(k);
                    if (list.size() == 0) {
                        CheckboxTreeAndListGroup.this.checkedStateStore.remove(k);
                        continue;
                    }
                    CheckboxTreeAndListGroup.this.checkedStateStore.put(k, list);
                    Object object = CheckboxTreeAndListGroup.this.treeContentProvider.getParent(k);
                    if (object == null) continue;
                    CheckboxTreeAndListGroup.this.addToHierarchyToCheckedStore(object);
                }
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    k = iterator.next();
                    CheckboxTreeAndListGroup.this.updateHierarchy(k);
                    if (CheckboxTreeAndListGroup.this.currentTreeSelection == null || !CheckboxTreeAndListGroup.this.currentTreeSelection.equals(k)) continue;
                    CheckboxTreeAndListGroup.this.listViewer.setAllChecked(false);
                    CheckboxTreeAndListGroup.this.listViewer.setCheckedElements(((List)map.get(k)).toArray());
                }
            }
        });
    }
}

