/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.resources.IFilterType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class CompoundFilter {
    private static final String T_FILTERS = "filters";
    private static final String T_FILTER = "filter";
    private static final String T_TYPE = "type";
    private static final String T_ID = "id";
    private static final String T_ARGUMENTS = "arguments";

    protected IFilterType instantiate(IProject iProject, IFilter iFilter) {
        FilterTypeManager.Descriptor descriptor = FilterTypeManager.getDefault().findDescriptor(iFilter.getId());
        if (descriptor != null) {
            return descriptor.getFactory().instantiate(iProject, iFilter.getArguments());
        }
        return null;
    }

    public static IFilter[] unserialize(final IProject iProject, String string) {
        LinkedList<1> linkedList = new LinkedList<1>();
        XMLMemento xMLMemento = null;
        try {
            xMLMemento = XMLMemento.createReadRoot((Reader)new StringReader(string));
        }
        catch (WorkbenchException workbenchException) {
            return new IFilter[0];
        }
        IMemento iMemento = xMLMemento.getChild(T_FILTERS);
        if (iMemento != null) {
            IMemento[] iMementoArray = iMemento.getChildren(T_FILTER);
            int n = 0;
            while (n < iMementoArray.length) {
                final String string2 = iMementoArray[n].getString(T_ID);
                final int n2 = iMementoArray[n].getInteger(T_TYPE);
                IMemento iMemento2 = iMementoArray[n].getChild(T_ARGUMENTS);
                final String string3 = iMemento2 != null ? iMemento2.getTextData() : "";
                linkedList.add(new IFilter(){

                    public String getArguments() {
                        return string3;
                    }

                    public String getId() {
                        return string2;
                    }

                    public IPath getPath() {
                        return null;
                    }

                    public IProject getProject() {
                        return iProject;
                    }

                    public int getType() {
                        return n2;
                    }
                });
                ++n;
            }
        }
        return linkedList.toArray(new IFilter[0]);
    }

    public static String serialize(IFilter[] iFilterArray) {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"memento");
        IMemento iMemento = xMLMemento.createChild(T_FILTERS);
        int n = 0;
        while (n < iFilterArray.length) {
            IMemento iMemento2 = iMemento.createChild(T_FILTER);
            iMemento2.putString(T_ID, iFilterArray[n].getId());
            iMemento2.putInteger(T_TYPE, iFilterArray[n].getType());
            IMemento iMemento3 = iMemento2.createChild(T_ARGUMENTS);
            iMemento3.putTextData(iFilterArray[n].getArguments());
            ++n;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            xMLMemento.save((Writer)stringWriter);
        }
        catch (IOException iOException) {
            return "";
        }
        return stringWriter.toString();
    }

    protected abstract class FilterType
    implements IFilterType {
        protected IFilterType[] filterTypes;
        protected IFilter[] filters;

        public FilterType(IProject iProject, IFilter[] iFilterArray) {
            this.filters = iFilterArray;
            this.filterTypes = new IFilterType[iFilterArray.length];
            int n = 0;
            while (n < iFilterArray.length) {
                this.filterTypes[n] = CompoundFilter.this.instantiate(iProject, iFilterArray[n]);
                ++n;
            }
        }
    }
}

