/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DisjointSet {
    private final HashMap objectsToNodes = new HashMap();

    public Object findSet(Object object) {
        Node node = (Node)this.objectsToNodes.get(object);
        if (node == null) {
            return null;
        }
        if (object != node.parent) {
            node.parent = this.findSet(node.parent);
        }
        return node.parent;
    }

    public void makeSet(Object object) {
        this.objectsToNodes.put(object, new Node(object, 0));
    }

    public void removeSet(Object object) {
        Object object2 = this.findSet(object);
        if (object2 == null) {
            return;
        }
        Iterator iterator = this.objectsToNodes.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k == object2 || this.findSet(k) != object2) continue;
            iterator.remove();
        }
        this.objectsToNodes.remove(object2);
    }

    public void toList(List list) {
        list.addAll(this.objectsToNodes.keySet());
    }

    public void union(Object object, Object object2) {
        Object object3 = this.findSet(object);
        Object object4 = this.findSet(object2);
        if (object3 == null || object4 == null || object3 == object4) {
            return;
        }
        Node node = (Node)this.objectsToNodes.get(object3);
        Node node2 = (Node)this.objectsToNodes.get(object4);
        if (node.rank > node2.rank) {
            node2.parent = object;
        } else {
            node.parent = object2;
            if (node.rank == node2.rank) {
                ++node2.rank;
            }
        }
    }

    private static class Node {
        int rank;
        Object parent;

        Node(Object object, int n) {
            this.parent = object;
            this.rank = n;
        }
    }
}

