/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayIcon
extends CompositeImageDescriptor {
    static final int DEFAULT_WIDTH = 22;
    static final int DEFAULT_HEIGHT = 16;
    private Point fSize = null;
    private ImageDescriptor fBase;
    private ImageDescriptor[][] fOverlays;

    public OverlayIcon(ImageDescriptor imageDescriptor, ImageDescriptor[][] imageDescriptorArray, Point point) {
        this.fBase = imageDescriptor;
        this.fOverlays = imageDescriptorArray;
        this.fSize = point;
    }

    protected void drawBottomLeft(ImageDescriptor[] imageDescriptorArray) {
        if (imageDescriptorArray == null) {
            return;
        }
        int n = imageDescriptorArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            if (n3 < n && imageDescriptorArray[n3] != null) {
                ImageData imageData = imageDescriptorArray[n3].getImageData();
                this.drawImage(imageData, n2, this.getSize().y - imageData.height);
                n2 += imageData.width;
            }
            ++n3;
        }
    }

    protected void drawBottomRight(ImageDescriptor[] imageDescriptorArray) {
        if (imageDescriptorArray == null) {
            return;
        }
        int n = imageDescriptorArray.length;
        int n2 = this.getSize().x;
        int n3 = 2;
        while (n3 >= 0) {
            if (n3 < n && imageDescriptorArray[n3] != null) {
                ImageData imageData = imageDescriptorArray[n3].getImageData();
                this.drawImage(imageData, n2 -= imageData.width, this.getSize().y - imageData.height);
            }
            --n3;
        }
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData;
        if (this.fBase == null || (imageData = this.fBase.getImageData()) == null) {
            imageData = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(imageData, 0, 0);
        if (this.fOverlays != null) {
            if (this.fOverlays.length > 0) {
                this.drawTopRight(this.fOverlays[0]);
            }
            if (this.fOverlays.length > 1) {
                this.drawBottomRight(this.fOverlays[1]);
            }
            if (this.fOverlays.length > 2) {
                this.drawBottomLeft(this.fOverlays[2]);
            }
            if (this.fOverlays.length > 3) {
                this.drawTopLeft(this.fOverlays[3]);
            }
        }
    }

    protected void drawTopLeft(ImageDescriptor[] imageDescriptorArray) {
        if (imageDescriptorArray == null) {
            return;
        }
        int n = imageDescriptorArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            if (n3 < n && imageDescriptorArray[n3] != null) {
                ImageData imageData = imageDescriptorArray[n3].getImageData();
                this.drawImage(imageData, n2, 0);
                n2 += imageData.width;
            }
            ++n3;
        }
    }

    protected void drawTopRight(ImageDescriptor[] imageDescriptorArray) {
        if (imageDescriptorArray == null) {
            return;
        }
        int n = imageDescriptorArray.length;
        int n2 = this.getSize().x;
        int n3 = 2;
        while (n3 >= 0) {
            if (n3 < n && imageDescriptorArray[n3] != null) {
                ImageData imageData = imageDescriptorArray[n3].getImageData();
                this.drawImage(imageData, n2 -= imageData.width, 0);
            }
            --n3;
        }
    }

    protected Point getSize() {
        return this.fSize;
    }
}

