/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;

public class ResourceAndContainerGroup
implements Listener {
    public static final int PROBLEM_NONE = 0;
    public static final int PROBLEM_RESOURCE_EMPTY = 1;
    public static final int PROBLEM_RESOURCE_EXIST = 2;
    public static final int PROBLEM_PATH_INVALID = 4;
    public static final int PROBLEM_CONTAINER_EMPTY = 5;
    public static final int PROBLEM_PROJECT_DOES_NOT_EXIST = 6;
    public static final int PROBLEM_NAME_INVALID = 7;
    public static final int PROBLEM_PATH_OCCUPIED = 8;
    private Listener client;
    private boolean allowExistingResources = false;
    private String resourceType = IDEWorkbenchMessages.ResourceGroup_resource;
    private boolean showClosedProjects = true;
    private String problemMessage = "";
    private int problemType = 0;
    private ContainerSelectionGroup containerGroup;
    private Text resourceNameField;
    private String resourceExtension;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public ResourceAndContainerGroup(Composite composite, Listener listener, String string, String string2) {
        this(composite, listener, string, string2, true);
    }

    public ResourceAndContainerGroup(Composite composite, Listener listener, String string, String string2, boolean bl) {
        this(composite, listener, string, string2, bl, -1);
    }

    public ResourceAndContainerGroup(Composite composite, Listener listener, String string, String string2, boolean bl, int n) {
        this.resourceType = string2;
        this.showClosedProjects = bl;
        this.createContents(composite, string, n);
        this.client = listener;
    }

    public boolean areAllValuesValid() {
        return this.problemType == 0;
    }

    protected void createContents(Composite composite, String string, int n) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setFont(font);
        this.containerGroup = n == -1 ? new ContainerSelectionGroup(composite2, this, true, null, this.showClosedProjects) : new ContainerSelectionGroup(composite2, this, true, null, this.showClosedProjects, n, 250);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        composite3.setFont(font);
        Label label = new Label(composite3, 0);
        label.setText(string);
        label.setFont(font);
        this.resourceNameField = new Text(composite3, 2048);
        this.resourceNameField.addListener(24, (Listener)this);
        this.resourceNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ResourceAndContainerGroup.this.handleResourceNameFocusLostEvent();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.resourceNameField.setLayoutData((Object)gridData);
        this.resourceNameField.setFont(font);
        this.validateControls();
    }

    public IPath getContainerFullPath() {
        return this.containerGroup.getContainerFullPath();
    }

    public String getProblemMessage() {
        return this.problemMessage;
    }

    public int getProblemType() {
        return this.problemType;
    }

    public String getResource() {
        String string = this.resourceNameField.getText();
        if (this.useResourceExtension()) {
            return String.valueOf(string) + '.' + this.resourceExtension;
        }
        return string;
    }

    public String getResourceExtension() {
        return this.resourceExtension;
    }

    private boolean useResourceExtension() {
        String string = this.resourceNameField.getText();
        return this.resourceExtension != null && this.resourceExtension.length() > 0 && string.length() > 0 && !string.endsWith(String.valueOf('.') + this.resourceExtension);
    }

    private void handleResourceNameFocusLostEvent() {
        if (this.useResourceExtension()) {
            this.setResource(String.valueOf(this.resourceNameField.getText()) + '.' + this.resourceExtension);
        }
    }

    public void handleEvent(Event event) {
        this.validateControls();
        if (this.client != null) {
            this.client.handleEvent(event);
        }
    }

    public void setAllowExistingResources(boolean bl) {
        this.allowExistingResources = bl;
    }

    public void setContainerFullPath(IPath iPath) {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (iResource != null) {
            if (!(iResource instanceof IContainer)) {
                iResource = iResource.getParent();
            }
            this.containerGroup.setSelectedContainer((IContainer)iResource);
        }
        this.validateControls();
    }

    public void setFocus() {
        this.resourceNameField.setSelection(0, this.resourceNameField.getText().length());
        this.resourceNameField.setFocus();
    }

    public void setResource(String string) {
        this.resourceNameField.setText(string);
        this.validateControls();
    }

    public void setResourceExtension(String string) {
        this.resourceExtension = string;
        this.validateControls();
    }

    protected boolean validateContainer() {
        IPath iPath = this.containerGroup.getContainerFullPath();
        if (iPath == null) {
            this.problemType = 5;
            this.problemMessage = IDEWorkbenchMessages.ResourceGroup_folderEmpty;
            return false;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string = iPath.segment(0);
        if (string == null || !iWorkspace.getRoot().getProject(string).exists()) {
            this.problemType = 6;
            this.problemMessage = IDEWorkbenchMessages.ResourceGroup_noProject;
            return false;
        }
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        while (iPath.segmentCount() > 1) {
            if (iWorkspaceRoot.getFile(iPath).exists()) {
                this.problemType = 8;
                this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_pathOccupied, (Object)iPath.makeRelative());
                return false;
            }
            iPath = iPath.removeLastSegments(1);
        }
        return true;
    }

    protected boolean validateControls() {
        if (this.containerGroup == null) {
            return false;
        }
        this.problemType = 0;
        this.problemMessage = "";
        if (!this.validateContainer() || !this.validateResourceName()) {
            return false;
        }
        IPath iPath = this.containerGroup.getContainerFullPath().append(this.getResource());
        return this.validateFullResourcePath(iPath);
    }

    protected boolean validateFullResourcePath(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 2);
        if (!iStatus.isOK()) {
            this.problemType = 4;
            this.problemMessage = iStatus.getMessage();
            return false;
        }
        if (!this.allowExistingResources && (iWorkspace.getRoot().getFolder(iPath).exists() || iWorkspace.getRoot().getFile(iPath).exists())) {
            this.problemType = 2;
            this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)this.getResource());
            return false;
        }
        return true;
    }

    protected boolean validateResourceName() {
        String string = this.getResource();
        if (string.length() == 0) {
            this.problemType = 1;
            this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_emptyName, (Object)this.resourceType);
            return false;
        }
        if (!Path.ROOT.isValidPath(string)) {
            this.problemType = 7;
            this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_invalidFilename, (Object)string);
            return false;
        }
        return true;
    }

    public boolean getAllowExistingResources() {
        return this.allowExistingResources;
    }
}

