/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class ResourceFactory
implements IElementFactory,
IPersistableElement {
    private static final String TAG_PATH = "path";
    private static final String TAG_TYPE = "type";
    private static final String FACTORY_ID = "org.eclipse.ui.internal.model.ResourceFactory";
    private IResource res;

    public ResourceFactory() {
    }

    public ResourceFactory(IResource iResource) {
        this.res = iResource;
    }

    public IAdaptable createElement(IMemento iMemento) {
        String string = iMemento.getString(TAG_PATH);
        if (string == null) {
            return null;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String string2 = iMemento.getString(TAG_TYPE);
        if (string2 == null) {
            this.res = iWorkspaceRoot.findMember((IPath)new Path(string));
        } else {
            int n = Integer.parseInt(string2);
            if (n == 8) {
                this.res = iWorkspaceRoot;
            } else if (n == 4) {
                this.res = iWorkspaceRoot.getProject(string);
            } else if (n == 2) {
                this.res = iWorkspaceRoot.getFolder((IPath)new Path(string));
            } else if (n == 1) {
                this.res = iWorkspaceRoot.getFile((IPath)new Path(string));
            }
        }
        return this.res;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString(TAG_PATH, this.res.getFullPath().toString());
        iMemento.putString(TAG_TYPE, Integer.toString(this.res.getType()));
    }
}

