/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IResourceActionFilter;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.model.WorkbenchAdapter;

public abstract class WorkbenchResource
extends WorkbenchAdapter
implements IResourceActionFilter {
    static /* synthetic */ Class class$0;

    protected abstract ImageDescriptor getBaseImage(IResource var1);

    public ImageDescriptor getImageDescriptor(Object object) {
        IResource iResource = this.getResource(object);
        return iResource == null ? null : this.getBaseImage(iResource);
    }

    public String getLabel(Object object) {
        IResource iResource = this.getResource(object);
        return iResource == null ? null : iResource.getName();
    }

    public Object getParent(Object object) {
        IResource iResource = this.getResource(object);
        return iResource == null ? null : iResource.getParent();
    }

    protected IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean testAttribute(Object object, String string, String string2) {
        if (!(object instanceof IResource)) {
            return false;
        }
        IResource iResource = (IResource)object;
        if (string.equals("name")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)string2, (String)iResource.getName());
        }
        if (string.equals("path")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)string2, (String)iResource.getFullPath().toString());
        }
        if (string.equals("extension")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)string2, (String)iResource.getFileExtension());
        }
        if (string.equals("readOnly")) {
            return iResource.isReadOnly() == string2.equalsIgnoreCase("true");
        }
        if (string.equals("projectNature")) {
            try {
                IProject iProject = iResource.getProject();
                return iProject.isAccessible() && iProject.hasNature(string2);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (string.equals("persistentProperty")) {
            return this.testProperty(iResource, true, false, string2);
        }
        if (string.equals("projectPersistentProperty")) {
            return this.testProperty(iResource, true, true, string2);
        }
        if (string.equals("sessionProperty")) {
            return this.testProperty(iResource, false, false, string2);
        }
        if (string.equals("projectSessionProperty")) {
            return this.testProperty(iResource, false, true, string2);
        }
        if (string.equals("contentTypeId")) {
            return this.testContentTypeProperty(iResource, string2);
        }
        return false;
    }

    private final boolean testContentTypeProperty(IResource iResource, String string) {
        String string2 = string.trim();
        if (!(iResource instanceof IFile)) {
            return false;
        }
        IFile iFile = (IFile)iResource;
        String string3 = null;
        try {
            IContentDescription iContentDescription = iFile.getContentDescription();
            if (iContentDescription != null) {
                IContentType iContentType = iContentDescription.getContentType();
                string3 = iContentType.getId();
            }
        }
        catch (CoreException coreException) {}
        return string2 == null || string2.equals(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testProperty(IResource iResource, boolean bl, boolean bl2, String string) {
        String string2;
        String string3;
        int n = string.indexOf(61);
        if (n != -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1).trim();
        } else {
            string3 = string.trim();
            string2 = null;
        }
        try {
            IResource iResource2;
            int n2 = string3.lastIndexOf(46);
            QualifiedName qualifiedName = n2 != -1 ? new QualifiedName(string3.substring(0, n2), string3.substring(n2 + 1)) : new QualifiedName(null, string3);
            Object object = iResource2 = bl2 ? iResource.getProject() : iResource;
            if (iResource2 == null) {
                return false;
            }
            if (bl) {
                String string4 = iResource2.getPersistentProperty(qualifiedName);
                if (string4 == null) {
                    return false;
                }
                return string2 == null || string2.equals(string4);
            }
            Object object2 = iResource2.getSessionProperty(qualifiedName);
            if (object2 == null) {
                return false;
            }
            return string2 == null || string2.equals(object2.toString());
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

