/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.ide.model.WorkingSetAdapterFactory;

public class WorkingSetResourceMapping
extends ResourceMapping {
    private IWorkingSet set;

    public WorkingSetResourceMapping(IWorkingSet iWorkingSet) {
        this.set = iWorkingSet;
    }

    public Object getModelObject() {
        return this.set;
    }

    public String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    public IProject[] getProjects() {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        ResourceMapping[] resourceMappingArray = this.getMappings();
        int n = 0;
        while (n < resourceMappingArray.length) {
            ResourceMapping resourceMapping = resourceMappingArray[n];
            IProject[] iProjectArray = resourceMapping.getProjects();
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                IProject iProject = iProjectArray[n2];
                hashSet.add(iProject);
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new IProject[hashSet.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            ResourceMapping[] resourceMappingArray = this.getMappings();
            iProgressMonitor.beginTask("", 100 * resourceMappingArray.length);
            ArrayList<ResourceTraversal> arrayList = new ArrayList<ResourceTraversal>();
            int n = 0;
            while (n < resourceMappingArray.length) {
                ResourceMapping resourceMapping = resourceMappingArray[n];
                arrayList.addAll(Arrays.asList(resourceMapping.getTraversals(resourceMappingContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100))));
                ++n;
            }
            ResourceTraversal[] resourceTraversalArray = arrayList.toArray(new ResourceTraversal[arrayList.size()]);
            return resourceTraversalArray;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private ResourceMapping[] getMappings() {
        IAdaptable[] iAdaptableArray = this.set.getElements();
        ArrayList<ResourceMapping> arrayList = new ArrayList<ResourceMapping>();
        int n = 0;
        while (n < iAdaptableArray.length) {
            IAdaptable iAdaptable = iAdaptableArray[n];
            ResourceMapping resourceMapping = WorkingSetAdapterFactory.getContributedResourceMapping(iAdaptable);
            if (resourceMapping == null) {
                resourceMapping = WorkingSetAdapterFactory.getResourceMapping(iAdaptable);
            }
            if (resourceMapping != null) {
                arrayList.add(resourceMapping);
            }
            ++n;
        }
        return arrayList.toArray(new ResourceMapping[arrayList.size()]);
    }

    public boolean contains(ResourceMapping resourceMapping) {
        ResourceMapping[] resourceMappingArray = this.getMappings();
        int n = 0;
        while (n < resourceMappingArray.length) {
            ResourceMapping resourceMapping2 = resourceMappingArray[n];
            if (resourceMapping2.contains(resourceMapping)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

