/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class IDERegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    protected static Hashtable extensionPoints = new Hashtable();
    private static final Comparator comparer = new Comparator(){

        public int compare(Object object, Object object2) {
            IExtension iExtension = (IExtension)object;
            String string = iExtension.getNamespace();
            IExtension iExtension2 = (IExtension)object2;
            String string2 = iExtension2.getNamespace();
            return string.compareToIgnoreCase(string2);
        }
    };

    protected IDERegistryReader() {
    }

    protected String getDescription(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(TAG_DESCRIPTION);
        if (iConfigurationElementArray.length >= 1) {
            return iConfigurationElementArray[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement iConfigurationElement, String string) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string2 = iExtension.getNamespace();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Plugin " + string2 + ", extension " + iExtension.getExtensionPointUniqueIdentifier());
        stringBuffer.append("\n" + string);
        IDEWorkbenchPlugin.log(stringBuffer.toString());
    }

    protected void logMissingAttribute(IConfigurationElement iConfigurationElement, String string) {
        this.logError(iConfigurationElement, "Required attribute '" + string + "' not defined");
    }

    protected void logMissingElement(IConfigurationElement iConfigurationElement, String string) {
        this.logError(iConfigurationElement, "Required sub element '" + string + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement iConfigurationElement) {
        this.logError(iConfigurationElement, "Unknown extension tag found: " + iConfigurationElement.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] iExtensionArray) {
        IExtension[] iExtensionArray2 = new IExtension[iExtensionArray.length];
        System.arraycopy(iExtensionArray, 0, iExtensionArray2, 0, iExtensionArray.length);
        Collections.sort(Arrays.asList(iExtensionArray2), comparer);
        return iExtensionArray2;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement iConfigurationElement) {
        this.readElements(iConfigurationElement.getChildren());
    }

    protected void readElements(IConfigurationElement[] iConfigurationElementArray) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (!this.readElement(iConfigurationElementArray[n])) {
                this.logUnknownElement(iConfigurationElementArray[n]);
            }
            ++n;
        }
    }

    protected void readExtension(IExtension iExtension) {
        this.readElements(iExtension.getConfigurationElements());
    }

    protected void readRegistry(IExtensionRegistry iExtensionRegistry, String string, String string2) {
        String string3 = String.valueOf(string) + "-" + string2;
        IExtension[] iExtensionArray = (IExtension[])extensionPoints.get(string3);
        if (iExtensionArray == null) {
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string, string2);
            if (iExtensionPoint == null) {
                return;
            }
            iExtensionArray = iExtensionPoint.getExtensions();
            iExtensionArray = this.orderExtensions(iExtensionArray);
            extensionPoints.put(string3, iExtensionArray);
        }
        int n = 0;
        while (n < iExtensionArray.length) {
            this.readExtension(iExtensionArray[n]);
            ++n;
        }
    }
}

