/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.MarkerQuery;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;
import org.eclipse.ui.statushandlers.StatusManager;

public class MarkerHelpRegistry
implements IMarkerHelpRegistry {
    private Map helpQueries = new HashMap();
    private List sortedHelpQueries;
    private Map resolutionQueries = new LinkedHashMap();
    private static final String ATT_HELP = "helpContextId";
    private static final String ATT_CLASS = "class";

    public String getHelp(IMarker iMarker) {
        Object object;
        if (this.sortedHelpQueries == null) {
            object = this.helpQueries.keySet();
            this.sortedHelpQueries = new ArrayList(object.size());
            this.sortedHelpQueries.addAll(object);
            Collections.sort(this.sortedHelpQueries, new QueryComparator());
        }
        object = this.sortedHelpQueries.iterator();
        while (object.hasNext()) {
            Iterator iterator;
            Map map;
            MarkerQuery markerQuery = (MarkerQuery)object.next();
            MarkerQueryResult markerQueryResult = markerQuery.performQuery(iMarker);
            if (markerQueryResult == null || !(map = (Map)this.helpQueries.get(markerQuery)).containsKey(markerQueryResult) || !(iterator = ((Collection)map.get(markerQueryResult)).iterator()).hasNext()) continue;
            IConfigurationElement iConfigurationElement = (IConfigurationElement)iterator.next();
            return iConfigurationElement.getAttribute(ATT_HELP);
        }
        return null;
    }

    public boolean hasResolutions(IMarker iMarker) {
        Iterator iterator = this.resolutionQueries.keySet().iterator();
        while (iterator.hasNext()) {
            Map map;
            MarkerQuery markerQuery = (MarkerQuery)iterator.next();
            MarkerQueryResult markerQueryResult = markerQuery.performQuery(iMarker);
            if (markerQueryResult == null || !(map = (Map)this.resolutionQueries.get(markerQuery)).containsKey(markerQueryResult)) continue;
            Iterator iterator2 = ((Collection)map.get(markerQueryResult)).iterator();
            while (iterator2.hasNext()) {
                IConfigurationElement iConfigurationElement = (IConfigurationElement)iterator2.next();
                if (!this.hasResolution(iMarker, iConfigurationElement)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasResolution(IMarker iMarker, IConfigurationElement iConfigurationElement) {
        IMarkerResolutionGenerator iMarkerResolutionGenerator = null;
        if (Platform.getBundle((String)iConfigurationElement.getNamespace()).getState() == 32) {
            try {
                iMarkerResolutionGenerator = (IMarkerResolutionGenerator)iConfigurationElement.createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
            }
            if (iMarkerResolutionGenerator != null) {
                if (iMarkerResolutionGenerator instanceof IMarkerResolutionGenerator2) {
                    if (((IMarkerResolutionGenerator2)iMarkerResolutionGenerator).hasResolutions(iMarker)) {
                        return true;
                    }
                } else {
                    IMarkerResolution[] iMarkerResolutionArray = iMarkerResolutionGenerator.getResolutions(iMarker);
                    if (iMarkerResolutionArray == null) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Failure in " + iMarkerResolutionGenerator.getClass().getName() + " from plugin " + iConfigurationElement.getContributor().getName() + ": getResolutions(IMarker) must not return null", null), 1);
                        return false;
                    }
                    if (iMarkerResolutionArray.length > 0) {
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public IMarkerResolution[] getResolutions(IMarker iMarker) {
        ArrayList<IMarkerResolution> arrayList = new ArrayList<IMarkerResolution>();
        Iterator iterator = this.resolutionQueries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map map;
            Map.Entry entry = iterator.next();
            MarkerQuery markerQuery = (MarkerQuery)entry.getKey();
            MarkerQueryResult markerQueryResult = markerQuery.performQuery(iMarker);
            if (markerQueryResult == null || !(map = (Map)entry.getValue()).containsKey(markerQueryResult)) continue;
            Iterator iterator2 = ((Collection)map.get(markerQueryResult)).iterator();
            while (iterator2.hasNext()) {
                IConfigurationElement iConfigurationElement = (IConfigurationElement)iterator2.next();
                IMarkerResolutionGenerator iMarkerResolutionGenerator = null;
                try {
                    iMarkerResolutionGenerator = (IMarkerResolutionGenerator)iConfigurationElement.createExecutableExtension(ATT_CLASS);
                }
                catch (CoreException coreException) {
                    Policy.handle(coreException);
                }
                if (iMarkerResolutionGenerator == null) continue;
                IMarkerResolution[] iMarkerResolutionArray = iMarkerResolutionGenerator.getResolutions(iMarker);
                int n = 0;
                while (n < iMarkerResolutionArray.length) {
                    arrayList.add(iMarkerResolutionArray[n]);
                    ++n;
                }
            }
        }
        return arrayList.toArray(new IMarkerResolution[arrayList.size()]);
    }

    public void addHelpQuery(MarkerQuery markerQuery, MarkerQueryResult markerQueryResult, IConfigurationElement iConfigurationElement) {
        this.addQuery(this.helpQueries, markerQuery, markerQueryResult, iConfigurationElement);
    }

    public void addResolutionQuery(MarkerQuery markerQuery, MarkerQueryResult markerQueryResult, IConfigurationElement iConfigurationElement) {
        this.addQuery(this.resolutionQueries, markerQuery, markerQueryResult, iConfigurationElement);
    }

    private void addQuery(Map map, MarkerQuery markerQuery, MarkerQueryResult markerQueryResult, IConfigurationElement iConfigurationElement) {
        HashMap hashMap = (HashMap)map.get(markerQuery);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(markerQuery, hashMap);
        }
        if (hashMap.containsKey(markerQueryResult)) {
            Collection collection = (Collection)hashMap.get(markerQueryResult);
            collection.add(iConfigurationElement);
        } else {
            HashSet<IConfigurationElement> hashSet = new HashSet<IConfigurationElement>();
            hashSet.add(iConfigurationElement);
            hashMap.put(markerQueryResult, hashSet);
        }
    }

    private class QueryComparator
    implements Comparator {
        private QueryComparator() {
        }

        public boolean equals(Object object) {
            return object instanceof QueryComparator;
        }

        public int compare(Object object, Object object2) {
            int n;
            MarkerQuery markerQuery = (MarkerQuery)object;
            MarkerQuery markerQuery2 = (MarkerQuery)object2;
            int n2 = markerQuery.getAttributes().length;
            if (n2 > (n = markerQuery2.getAttributes().length)) {
                return -1;
            }
            if (n2 == n) {
                return 0;
            }
            return 1;
        }
    }
}

