/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.ide.registry.IDERegistryReader;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerQuery;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;

public class MarkerHelpRegistryReader
extends IDERegistryReader {
    private MarkerHelpRegistry markerHelpRegistry;
    private ArrayList currentAttributeNames;
    private ArrayList currentAttributeValues;
    private static final String TAG_HELP = "markerHelp";
    private static final String TAG_RESOLUTION_GENERATOR = "markerResolutionGenerator";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String ATT_TYPE = "markerType";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";

    public void addHelp(MarkerHelpRegistry markerHelpRegistry) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        this.markerHelpRegistry = markerHelpRegistry;
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui.ide", TAG_HELP);
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui.ide", "markerResolution");
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_HELP)) {
            this.readHelpElement(iConfigurationElement);
            return true;
        }
        if (iConfigurationElement.getName().equals(TAG_RESOLUTION_GENERATOR)) {
            this.readResolutionElement(iConfigurationElement);
            return true;
        }
        if (iConfigurationElement.getName().equals(TAG_ATTRIBUTE)) {
            this.readAttributeElement(iConfigurationElement);
            return true;
        }
        return false;
    }

    private void readHelpElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(ATT_TYPE);
        this.currentAttributeNames = new ArrayList();
        this.currentAttributeValues = new ArrayList();
        this.readElementChildren(iConfigurationElement);
        String[] stringArray = this.currentAttributeNames.toArray(new String[this.currentAttributeNames.size()]);
        String[] stringArray2 = this.currentAttributeValues.toArray(new String[this.currentAttributeValues.size()]);
        MarkerQuery markerQuery = new MarkerQuery(string, stringArray);
        MarkerQueryResult markerQueryResult = new MarkerQueryResult(stringArray2);
        this.markerHelpRegistry.addHelpQuery(markerQuery, markerQueryResult, iConfigurationElement);
    }

    private void readResolutionElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(ATT_TYPE);
        this.currentAttributeNames = new ArrayList();
        this.currentAttributeValues = new ArrayList();
        this.readElementChildren(iConfigurationElement);
        String[] stringArray = this.currentAttributeNames.toArray(new String[this.currentAttributeNames.size()]);
        String[] stringArray2 = this.currentAttributeValues.toArray(new String[this.currentAttributeValues.size()]);
        MarkerQuery markerQuery = new MarkerQuery(string, stringArray);
        MarkerQueryResult markerQueryResult = new MarkerQueryResult(stringArray2);
        this.markerHelpRegistry.addResolutionQuery(markerQuery, markerQueryResult, iConfigurationElement);
    }

    private void readAttributeElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(ATT_NAME);
        String string2 = iConfigurationElement.getAttribute(ATT_VALUE);
        if (string != null && string2 != null) {
            this.currentAttributeNames.add(string);
            this.currentAttributeValues.add(string2);
        }
    }
}

