/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.IMarkerImageProvider;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.IDERegistryReader;
import org.eclipse.ui.internal.ide.registry.MarkerImageProviderRegistry;
import org.osgi.framework.Bundle;

public class MarkerImageProviderRegistry {
    private static final String ATT_PROVIDER_CLASS = "class";
    private static final String ATT_ICON = "icon";
    private static final String ATT_MARKER_TYPE = "markertype";
    private static final String ATT_ID = "id";
    private static final String MARKER_ATT_KEY = "org.eclipse.ui.internal.registry.MarkerImageProviderRegistry";
    private static final String TAG_PROVIDER = "imageprovider";
    private ArrayList descriptors = new ArrayList();

    public MarkerImageProviderRegistry() {
        class MarkerImageReader
        extends IDERegistryReader {
            final /* synthetic */ MarkerImageProviderRegistry this$0;

            MarkerImageReader(MarkerImageProviderRegistry markerImageProviderRegistry) {
                this.this$0 = markerImageProviderRegistry;
            }

            protected boolean readElement(IConfigurationElement iConfigurationElement) {
                if (iConfigurationElement.getName().equals("imageprovider")) {
                    this.this$0.addProvider(iConfigurationElement);
                    return true;
                }
                return false;
            }

            public void readRegistry() {
                this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui.ide", "markerImageProviders");
            }
        }
        new MarkerImageReader(this).readRegistry();
    }

    public void addProvider(IConfigurationElement iConfigurationElement) {
        Descriptor descriptor = new Descriptor();
        descriptor.element = iConfigurationElement;
        descriptor.pluginBundle = Platform.getBundle((String)iConfigurationElement.getNamespace());
        descriptor.id = iConfigurationElement.getAttribute(ATT_ID);
        descriptor.markerType = iConfigurationElement.getAttribute(ATT_MARKER_TYPE);
        descriptor.imagePath = iConfigurationElement.getAttribute(ATT_ICON);
        descriptor.className = iConfigurationElement.getAttribute(ATT_PROVIDER_CLASS);
        if (descriptor.imagePath != null) {
            descriptor.imageDescriptor = this.getImageDescriptor(descriptor);
        }
        if (descriptor.className == null) {
            descriptor.element = null;
            descriptor.pluginBundle = null;
        }
        this.descriptors.add(descriptor);
    }

    public ImageDescriptor getImageDescriptor(IMarker iMarker) {
        int n = this.descriptors.size();
        int n2 = 0;
        while (n2 < n) {
            Descriptor descriptor = (Descriptor)this.descriptors.get(n2);
            try {
                if (iMarker.isSubtypeOf(descriptor.markerType)) {
                    if (descriptor.className != null) {
                        if (descriptor.pluginBundle.getState() == 32) {
                            String string;
                            if (descriptor.provider == null) {
                                descriptor.provider = (IMarkerImageProvider)IDEWorkbenchPlugin.createExtension(descriptor.element, ATT_PROVIDER_CLASS);
                            }
                            if ((string = descriptor.provider.getImagePath(iMarker)) != descriptor.imagePath) {
                                descriptor.imagePath = string;
                                descriptor.imageDescriptor = this.getImageDescriptor(descriptor);
                                return descriptor.imageDescriptor;
                            }
                            return descriptor.imageDescriptor;
                        }
                        if (descriptor.imageDescriptor == null) {
                            descriptor.imagePath = (String)iMarker.getAttribute(MARKER_ATT_KEY);
                            descriptor.imageDescriptor = this.getImageDescriptor(descriptor);
                        }
                        return descriptor.imageDescriptor;
                    }
                    if (descriptor.imageDescriptor != null) {
                        return descriptor.imageDescriptor;
                    }
                }
            }
            catch (CoreException coreException) {
                Policy.handle(coreException);
                return null;
            }
            ++n2;
        }
        return null;
    }

    ImageDescriptor getImageDescriptor(Descriptor descriptor) {
        URL uRL = Platform.find((Bundle)descriptor.pluginBundle, (IPath)new Path(descriptor.imagePath));
        return ImageDescriptor.createFromURL((URL)uRL);
    }

    class Descriptor {
        String id;
        String markerType;
        String className;
        String imagePath;
        ImageDescriptor imageDescriptor;
        IConfigurationElement element;
        Bundle pluginBundle;
        IMarkerImageProvider provider;

        Descriptor() {
        }
    }
}

