/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;

public class MarkerQuery {
    private String type;
    private String[] attributes;
    private int hashCode;

    public MarkerQuery(String string, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this.type = string;
        this.attributes = stringArray;
        this.computeHashCode();
    }

    public MarkerQueryResult performQuery(IMarker iMarker) {
        try {
            if (this.type != null && !this.type.equals(iMarker.getType())) {
                return null;
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return null;
        }
        String[] stringArray = new String[this.attributes.length];
        int n = 0;
        while (n < this.attributes.length) {
            Object object;
            block7: {
                try {
                    object = iMarker.getAttribute(this.attributes[n]);
                    if (object != null) break block7;
                    return null;
                }
                catch (CoreException coreException) {
                    Policy.handle(coreException);
                    return null;
                }
            }
            stringArray[n] = object.toString();
            ++n;
        }
        return new MarkerQueryResult(stringArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MarkerQuery)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        MarkerQuery markerQuery = (MarkerQuery)object;
        if (this.type == null ? markerQuery.type != null : !this.type.equals(markerQuery.type)) {
            return false;
        }
        if (this.attributes.length != markerQuery.attributes.length) {
            return false;
        }
        int n = 0;
        while (n < this.attributes.length) {
            if (!this.attributes[n].equals(markerQuery.attributes[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void computeHashCode() {
        this.hashCode = 19;
        if (this.type != null) {
            this.hashCode = this.hashCode * 37 + this.type.hashCode();
        }
        int n = 0;
        while (n < this.attributes.length) {
            this.hashCode = this.hashCode * 37 + this.attributes[n].hashCode();
            ++n;
        }
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributes() {
        return this.attributes;
    }
}

