/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.ide.undo.MarkerDescription;

abstract class AbstractResourceDescription
extends ResourceDescription {
    IContainer parent;
    long modificationStamp = -1L;
    long localTimeStamp = -1L;
    ResourceAttributes resourceAttributes;
    MarkerDescription[] markerDescriptions;

    protected AbstractResourceDescription() {
    }

    protected AbstractResourceDescription(IResource iResource) {
        this.parent = iResource.getParent();
        if (iResource.isAccessible()) {
            this.modificationStamp = iResource.getModificationStamp();
            this.localTimeStamp = iResource.getLocalTimeStamp();
            this.resourceAttributes = iResource.getResourceAttributes();
            try {
                IMarker[] iMarkerArray = iResource.findMarkers(null, true, 2);
                this.markerDescriptions = new MarkerDescription[iMarkerArray.length];
                int n = 0;
                while (n < iMarkerArray.length) {
                    this.markerDescriptions[n] = new MarkerDescription(iMarkerArray[n]);
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public IResource createResource(IProgressMonitor iProgressMonitor) throws CoreException {
        IResource iResource = this.createResourceHandle();
        this.createExistentResourceFromHandle(iResource, iProgressMonitor);
        this.restoreResourceAttributes(iResource);
        return iResource;
    }

    public boolean isValid() {
        return this.parent == null || this.parent.exists();
    }

    protected void restoreResourceAttributes(IResource iResource) throws CoreException {
        if (this.modificationStamp != -1L) {
            iResource.revertModificationStamp(this.modificationStamp);
        }
        if (this.localTimeStamp != -1L) {
            iResource.setLocalTimeStamp(this.localTimeStamp);
        }
        if (this.resourceAttributes != null) {
            iResource.setResourceAttributes(this.resourceAttributes);
        }
        if (this.markerDescriptions != null) {
            int n = 0;
            while (n < this.markerDescriptions.length) {
                if (this.markerDescriptions[n].resource.exists()) {
                    this.markerDescriptions[n].createMarker();
                }
                ++n;
            }
        }
    }

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public boolean verifyExistence(boolean bl) {
        IResource iResource;
        IContainer iContainer = this.parent;
        if (iContainer == null) {
            iContainer = this.getWorkspace().getRoot();
        }
        return (iResource = iContainer.findMember(this.getName())) != null;
    }
}

