/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.ide.undo.AbstractResourceDescription;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.FolderDescription;
import org.eclipse.ui.internal.ide.undo.GroupDescription;
import org.eclipse.ui.internal.ide.undo.ProjectDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public abstract class ContainerDescription
extends AbstractResourceDescription {
    String name;
    URI location;
    String defaultCharSet;
    AbstractResourceDescription[] members;

    public static ContainerDescription fromContainer(IContainer iContainer) {
        return ContainerDescription.fromContainer(iContainer, false);
    }

    public static ContainerDescription fromGroupContainer(IContainer iContainer) {
        return ContainerDescription.fromContainer(iContainer, true);
    }

    protected static ContainerDescription fromContainer(IContainer iContainer, boolean bl) {
        IPath iPath = iContainer.getFullPath();
        ContainerDescription containerDescription = null;
        ContainerDescription containerDescription2 = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer iContainer2 = (IContainer)iWorkspaceRoot.findMember(iPath);
        if (iContainer2 != null) {
            return (ContainerDescription)ResourceDescription.fromResource((IResource)iContainer);
        }
        iContainer2 = iWorkspaceRoot;
        int n = 0;
        while (n < iPath.segmentCount()) {
            String string = iPath.segment(n);
            IResource iResource = iContainer2.findMember(string);
            if (iResource != null) {
                iContainer2 = (IContainer)iResource;
            } else if (n == 0) {
                containerDescription2 = containerDescription = new ProjectDescription(iWorkspaceRoot.getProject(string));
            } else {
                IFolder iFolder = iContainer2.getFolder((IPath)new Path(string));
                ContainerDescription containerDescription3 = bl ? new GroupDescription(iFolder) : new FolderDescription(iFolder);
                iContainer2 = iFolder;
                if (containerDescription2 != null) {
                    containerDescription2.addMember(containerDescription3);
                }
                containerDescription2 = containerDescription3;
                if (containerDescription == null) {
                    containerDescription = containerDescription3;
                }
            }
            ++n;
        }
        return containerDescription;
    }

    public ContainerDescription() {
    }

    public ContainerDescription(IContainer iContainer) {
        super((IResource)iContainer);
        this.name = iContainer.getName();
        if (iContainer.isLinked()) {
            this.location = iContainer.getLocationURI();
        }
        try {
            if (iContainer.isAccessible()) {
                this.defaultCharSet = iContainer.getDefaultCharset(false);
                IResource[] iResourceArray = iContainer.members();
                this.members = new AbstractResourceDescription[iResourceArray.length];
                int n = 0;
                while (n < iResourceArray.length) {
                    this.members[n] = (AbstractResourceDescription)ResourceDescription.fromResource(iResourceArray[n]);
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected void createChildResources(IContainer iContainer, IProgressMonitor iProgressMonitor, int n) throws CoreException {
        if (this.members != null && this.members.length > 0) {
            int n2 = 0;
            while (n2 < this.members.length) {
                this.members[n2].parent = iContainer;
                this.members[n2].createResource((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n / this.members.length));
                ++n2;
            }
        }
    }

    public void recordStateFromHistory(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(UndoMessages.FolderDescription_SavingUndoInfoProgress, 100);
        if (this.members != null) {
            int n = 0;
            while (n < this.members.length) {
                IFile iFile;
                IPath iPath;
                if (this.members[n] instanceof FileDescription) {
                    iPath = iResource.getFullPath().append(((FileDescription)this.members[n]).name);
                    iFile = iResource.getWorkspace().getRoot().getFile(iPath);
                    this.members[n].recordStateFromHistory((IResource)iFile, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100 / this.members.length));
                } else if (this.members[n] instanceof FolderDescription) {
                    iPath = iResource.getFullPath().append(((FolderDescription)this.members[n]).name);
                    iFile = iResource.getWorkspace().getRoot().getFolder(iPath);
                    this.members[n].recordStateFromHistory((IResource)iFile, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100 / this.members.length));
                } else if (this.members[n] instanceof GroupDescription) {
                    iPath = iResource.getFullPath().append(((GroupDescription)this.members[n]).name);
                    iFile = iResource.getWorkspace().getRoot().getFolder(iPath);
                    this.members[n].recordStateFromHistory((IResource)iFile, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100 / this.members.length));
                }
                ++n;
            }
        }
        iProgressMonitor.done();
    }

    public String getName() {
        return this.name;
    }

    public ContainerDescription getFirstLeafFolder() {
        if (this.members == null || this.members.length == 0) {
            return this;
        }
        int n = 0;
        while (n < this.members.length) {
            if (this.members[n] instanceof ContainerDescription) {
                return ((ContainerDescription)this.members[n]).getFirstLeafFolder();
            }
            ++n;
        }
        return this;
    }

    public void addMember(AbstractResourceDescription abstractResourceDescription) {
        if (this.members == null) {
            this.members = new AbstractResourceDescription[]{abstractResourceDescription};
        } else {
            AbstractResourceDescription[] abstractResourceDescriptionArray = new AbstractResourceDescription[this.members.length + 1];
            System.arraycopy(this.members, 0, abstractResourceDescriptionArray, 0, this.members.length);
            abstractResourceDescriptionArray[this.members.length] = abstractResourceDescription;
            this.members = abstractResourceDescriptionArray;
        }
    }

    protected void restoreResourceAttributes(IResource iResource) throws CoreException {
        super.restoreResourceAttributes(iResource);
        Assert.isLegal((boolean)(iResource instanceof IContainer));
        IContainer iContainer = (IContainer)iResource;
        if (this.defaultCharSet != null) {
            iContainer.setDefaultCharset(this.defaultCharSet, null);
        }
    }

    public void setLocation(URI uRI) {
        this.location = uRI;
    }

    public boolean verifyExistence(boolean bl) {
        boolean bl2 = super.verifyExistence(bl);
        if (bl2) {
            if (bl && this.members != null && this.members.length > 0) {
                int n = 0;
                while (n < this.members.length) {
                    if (!this.members[n].verifyExistence(bl)) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }
}

