/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.internal.ide.undo.AbstractResourceDescription;
import org.eclipse.ui.internal.ide.undo.IFileContentDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class FileDescription
extends AbstractResourceDescription {
    String name;
    URI location;
    String charset;
    private IFileContentDescription fileContentDescription;

    public FileDescription(IFile iFile) {
        super((IResource)iFile);
        this.name = iFile.getName();
        try {
            this.charset = iFile.getCharset(false);
        }
        catch (CoreException coreException) {}
        if (iFile.isLinked()) {
            this.location = iFile.getLocationURI();
        }
    }

    public FileDescription(IFile iFile, URI uRI, IFileContentDescription iFileContentDescription) {
        super((IResource)iFile);
        this.name = iFile.getName();
        this.location = uRI;
        this.charset = null;
        this.fileContentDescription = iFileContentDescription;
    }

    public void recordStateFromHistory(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isLegal((iResource.getType() == 1 ? 1 : 0) != 0);
        if (this.location != null) {
            return;
        }
        IFileState[] iFileStateArray = ((IFile)iResource).getHistory(iProgressMonitor);
        if (iFileStateArray.length > 0) {
            final IFileState iFileState = this.getMatchingFileState(iFileStateArray);
            this.fileContentDescription = new IFileContentDescription(){

                public boolean exists() {
                    return iFileState.exists();
                }

                public InputStream getContents() throws CoreException {
                    return iFileState.getContents();
                }

                public String getCharset() throws CoreException {
                    return iFileState.getCharset();
                }
            };
        }
    }

    public IResource createResourceHandle() {
        IWorkspaceRoot iWorkspaceRoot = this.parent.getWorkspace().getRoot();
        IPath iPath = this.parent.getFullPath().append(this.name);
        return iWorkspaceRoot.getFile(iPath);
    }

    public void createExistentResourceFromHandle(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isLegal((boolean)(iResource instanceof IFile));
        if (iResource.exists()) {
            return;
        }
        IFile iFile = (IFile)iResource;
        iProgressMonitor.beginTask("", 200);
        iProgressMonitor.setTaskName(UndoMessages.FileDescription_NewFileProgress);
        try {
            try {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.location != null) {
                    iFile.createLink(this.location, 16, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                } else {
                    InputStream inputStream = new ByteArrayInputStream(UndoMessages.FileDescription_ContentsCouldNotBeRestored.getBytes());
                    if (this.fileContentDescription != null && this.fileContentDescription.exists()) {
                        inputStream = this.fileContentDescription.getContents();
                    }
                    iFile.create(inputStream, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    iFile.setCharset(this.charset, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getCode() != 374) {
                    throw coreException;
                }
                iFile.refreshLocal(0, null);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public boolean isValid() {
        if (this.location != null) {
            return super.isValid();
        }
        return super.isValid() && this.fileContentDescription != null && this.fileContentDescription.exists();
    }

    public String getName() {
        return this.name;
    }

    private IFileState getMatchingFileState(IFileState[] iFileStateArray) {
        int n = 0;
        while (n < iFileStateArray.length) {
            if (this.localTimeStamp == iFileStateArray[n].getModificationTime()) {
                return iFileStateArray[n];
            }
            ++n;
        }
        return iFileStateArray[0];
    }

    protected void restoreResourceAttributes(IResource iResource) throws CoreException {
        super.restoreResourceAttributes(iResource);
        Assert.isLegal((boolean)(iResource instanceof IFile));
        IFile iFile = (IFile)iResource;
        if (this.charset != null) {
            iFile.setCharset(this.charset, null);
        }
    }
}

