/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class FolderDescription
extends ContainerDescription {
    public FolderDescription(IFolder iFolder) {
        super((IContainer)iFolder);
    }

    public FolderDescription(IFolder iFolder, URI uRI) {
        super((IContainer)iFolder);
        this.name = iFolder.getName();
        this.location = uRI;
    }

    public IResource createResourceHandle() {
        IWorkspaceRoot iWorkspaceRoot = this.getWorkspace().getRoot();
        IPath iPath = this.parent.getFullPath().append(this.name);
        return iWorkspaceRoot.getFolder(iPath);
    }

    public void createExistentResourceFromHandle(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isLegal((boolean)(iResource instanceof IFolder));
        if (iResource.exists()) {
            return;
        }
        IFolder iFolder = (IFolder)iResource;
        try {
            iProgressMonitor.beginTask("", 200);
            iProgressMonitor.setTaskName(UndoMessages.FolderDescription_NewFolderProgress);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.location != null) {
                iFolder.createLink(this.location, 16, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            } else {
                iFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createChildResources((IContainer)iFolder, iProgressMonitor, 100);
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

