/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class GroupDescription
extends ContainerDescription {
    public GroupDescription(IFolder iFolder) {
        super((IContainer)iFolder);
        this.name = iFolder.getName();
    }

    public IResource createResourceHandle() {
        IWorkspaceRoot iWorkspaceRoot = this.getWorkspace().getRoot();
        IPath iPath = this.parent.getFullPath().append(this.name);
        return iWorkspaceRoot.getFolder(iPath);
    }

    public void createExistentResourceFromHandle(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isLegal((boolean)(iResource instanceof IFolder));
        if (iResource.exists()) {
            return;
        }
        IFolder iFolder = (IFolder)iResource;
        try {
            iProgressMonitor.beginTask("", 200);
            iProgressMonitor.setTaskName(UndoMessages.GroupDescription_NewGroupProgress);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iFolder.createGroup(16, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createChildResources((IContainer)iFolder, iProgressMonitor, 100);
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

