/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class ProjectDescription
extends ContainerDescription {
    private IProjectDescription projectDescription;
    private boolean openOnCreate = true;

    public ProjectDescription(IProject iProject) {
        super((IContainer)iProject);
        Assert.isLegal((boolean)iProject.exists());
        if (iProject.isOpen()) {
            try {
                this.projectDescription = iProject.getDescription();
            }
            catch (CoreException coreException) {}
        } else {
            this.openOnCreate = false;
        }
    }

    public ProjectDescription(IProjectDescription iProjectDescription) {
        this.projectDescription = iProjectDescription;
    }

    public IResource createResourceHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
    }

    public void createExistentResourceFromHandle(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isLegal((boolean)(iResource instanceof IProject));
        if (iResource.exists()) {
            return;
        }
        IProject iProject = (IProject)iResource;
        iProgressMonitor.beginTask("", 200);
        iProgressMonitor.setTaskName(UndoMessages.FolderDescription_NewFolderProgress);
        if (this.projectDescription == null) {
            iProject.create((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
        } else {
            iProject.create(this.projectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.openOnCreate) {
            iProject.open(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
        }
        iProgressMonitor.done();
    }

    public String getName() {
        if (this.projectDescription != null) {
            return this.projectDescription.getName();
        }
        return super.getName();
    }

    public boolean verifyExistence(boolean bl) {
        IProject iProject = (IProject)this.createResourceHandle();
        if (iProject.isAccessible()) {
            return super.verifyExistence(bl);
        }
        return super.verifyExistence(false);
    }
}

