/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.Policy;

public class WorkspaceUndoMonitor {
    private static WorkspaceUndoMonitor instance;
    private static int CHANGE_THRESHHOLD;
    private static String DEBUG_PREFIX;
    private int numChanges = 0;
    private IUndoableOperation operationInProgress = null;
    private IResourceChangeListener resourceListener;
    private IOperationHistoryListener historyListener;

    static {
        CHANGE_THRESHHOLD = 10;
        DEBUG_PREFIX = "Workspace Undo Monitor:  ";
    }

    public static WorkspaceUndoMonitor getInstance() {
        if (instance == null) {
            instance = new WorkspaceUndoMonitor();
        }
        return instance;
    }

    private WorkspaceUndoMonitor() {
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Installing listeners");
        }
        this.resourceListener = this.getResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.historyListener = this.getOperationHistoryListener();
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
    }

    private IResourceChangeListener getResourceChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                if (WorkspaceUndoMonitor.this.operationInProgress != null) {
                    return;
                }
                if (iResourceChangeEvent.getType() == 1 || iResourceChangeEvent.getType() == 16) {
                    WorkspaceUndoMonitor.this.incrementChangeCount();
                    if (WorkspaceUndoMonitor.this.numChanges >= CHANGE_THRESHHOLD) {
                        WorkspaceUndoMonitor.this.checkOperationHistory();
                    }
                }
            }
        };
    }

    private IOperationHistoryListener getOperationHistoryListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent operationHistoryEvent) {
                if (!operationHistoryEvent.getOperation().hasContext(WorkspaceUndoUtil.getWorkspaceUndoContext())) {
                    return;
                }
                switch (operationHistoryEvent.getEventType()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        WorkspaceUndoMonitor.this.operationInProgress = operationHistoryEvent.getOperation();
                        break;
                    }
                    case 4: 
                    case 9: 
                    case 10: {
                        WorkspaceUndoMonitor.this.resetChangeCount();
                        WorkspaceUndoMonitor.this.operationInProgress = null;
                        break;
                    }
                    case 7: {
                        WorkspaceUndoMonitor.this.operationInProgress = null;
                    }
                }
            }
        };
    }

    public void shutdown() {
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Shutting Down");
        }
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        if (this.historyListener != null) {
            this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        }
    }

    private IOperationHistory getOperationHistory() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    private void checkOperationHistory() {
        IUndoableOperation iUndoableOperation;
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Checking Operation History...");
        }
        if ((iUndoableOperation = this.getOperationHistory().getUndoOperation(WorkspaceUndoUtil.getWorkspaceUndoContext())) == null) {
            this.resetChangeCount();
            return;
        }
        if (!iUndoableOperation.canUndo()) {
            this.flushWorkspaceHistory(iUndoableOperation);
            return;
        }
        if (iUndoableOperation instanceof IAdvancedUndoableOperation && iUndoableOperation instanceof IAdvancedUndoableOperation2) {
            IStatus iStatus;
            ((IAdvancedUndoableOperation2)iUndoableOperation).setQuietCompute(true);
            try {
                iStatus = ((IAdvancedUndoableOperation)iUndoableOperation).computeUndoableStatus(null);
            }
            catch (ExecutionException executionException) {
                iStatus = Status.OK_STATUS;
            }
            ((IAdvancedUndoableOperation2)iUndoableOperation).setQuietCompute(false);
            if (iStatus.getSeverity() == 4) {
                this.flushWorkspaceHistory(iUndoableOperation);
            }
        }
        this.resetChangeCount();
    }

    private void flushWorkspaceHistory(IUndoableOperation iUndoableOperation) {
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Flushing undo history due to " + iUndoableOperation);
        }
        this.getOperationHistory().dispose(WorkspaceUndoUtil.getWorkspaceUndoContext(), true, true, false);
    }

    private void resetChangeCount() {
        this.numChanges = 0;
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Resetting change count to 0");
        }
    }

    private void incrementChangeCount() {
        ++this.numChanges;
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Incrementing workspace change count.  Count = " + this.numChanges);
        }
    }
}

