/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.SeverityAndDescriptionFieldFilter;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;

public class AllMarkersSeverityAndDescriptionFieldFilter
extends SeverityAndDescriptionFieldFilter {
    private boolean filterOnSeverity = false;
    private static String FILTER_ON_SEVERITY = "FILTER_ON_SEVERITY";

    public boolean select(MarkerItem markerItem) {
        if (this.filterOnSeverity) {
            IMarker iMarker = markerItem.getMarker();
            if (iMarker == null) {
                return false;
            }
            if (!this.checkSeverity(markerItem.getAttributeValue("severity", -1))) {
                return false;
            }
        }
        return super.select(markerItem);
    }

    boolean getFilterOnSeverity() {
        return this.filterOnSeverity;
    }

    void setFilterOnSeverity(boolean bl) {
        this.filterOnSeverity = bl;
    }

    public void loadSettings(IMemento iMemento) {
        super.loadSettings(iMemento);
        Boolean bl = iMemento.getBoolean(FILTER_ON_SEVERITY);
        if (bl != null) {
            this.filterOnSeverity = bl;
        }
    }

    public void saveSettings(IMemento iMemento) {
        super.saveSettings(iMemento);
        iMemento.putBoolean(FILTER_ON_SEVERITY, this.filterOnSeverity);
    }

    public void populateWorkingCopy(MarkerFieldFilter markerFieldFilter) {
        super.populateWorkingCopy(markerFieldFilter);
        ((AllMarkersSeverityAndDescriptionFieldFilter)markerFieldFilter).filterOnSeverity = this.filterOnSeverity;
    }
}

