/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CompatibilityMarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.FiltersConfigurationDialog;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerComparator;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerMap;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class CachedMarkerBuilder {
    private static final MarkerCategory[] EMPTY_CATEGORY_ARRAY = new MarkerCategory[0];
    private static final MarkerEntry[] EMPTY_ENTRY_ARRAY = new MarkerEntry[0];
    private static final int SHORT_DELAY = 100;
    private static final int TIME_OUT = 30000;
    private static final String TAG_FILTERS_SECTION = "filterGroups";
    private static final String TAG_GROUP_ENTRY = "filterGroup";
    private static final String TAG_AND = "andFilters";
    private static final String TAG_CATEGORY_GROUP = "categoryGroup";
    private static final String TAG_COLUMN_VISIBILITY = "visible";
    private static final String VALUE_NONE = "none";
    private static final String TAG_LEGACY_FILTER_ENTRY = "filter";
    private static final Integer[] EMPTY_MARKER_COUNTS = new Integer[]{new Integer(0), new Integer(0), new Integer(0)};
    private boolean building = true;
    private MarkerCategory[] categories;
    private MarkerMap currentMap = null;
    private MarkerContentGenerator generator;
    private Job markerProcessJob;
    private IWorkbenchSiteProgressService progressService;
    private Job updateJob;
    private MarkerGroup categoryGroup;
    private Collection enabledFilters;
    private Collection filters;
    private IResource[] focusResources = MarkerSupportInternalUtilities.EMPTY_RESOURCE_ARRAY;
    private MarkerField[] visibleFields;
    private boolean andFilters = false;
    private MarkerComparator comparator;
    private IMemento memento;
    private String viewId;
    private long preBuildTime = -1L;
    private IResourceChangeListener resourceListener;
    private IPropertyChangeListener preferenceListener;

    public CachedMarkerBuilder(MarkerContentGenerator markerContentGenerator, String string, IMemento iMemento) {
        this.generator = markerContentGenerator;
        this.viewId = string;
        this.initialiseVisibleFields(iMemento);
        this.initializePreferenceListener();
        this.memento = iMemento;
        if (iMemento == null) {
            this.setDefaultCategoryGroup(markerContentGenerator);
        } else {
            String string2 = iMemento.getString(TAG_CATEGORY_GROUP);
            if (string2 == null) {
                this.setDefaultCategoryGroup(markerContentGenerator);
            } else if (string2.equals(VALUE_NONE)) {
                this.categoryGroup = null;
            } else {
                MarkerGroup markerGroup = markerContentGenerator.getMarkerGroup(string2);
                if (markerGroup == null) {
                    this.setDefaultCategoryGroup(markerContentGenerator);
                } else {
                    this.categoryGroup = markerGroup;
                }
            }
        }
        this.createMarkerProcessJob();
        this.resourceListener = this.getUpdateListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 25);
    }

    private void addResources(Collection collection, ResourceMapping resourceMapping) {
        try {
            ResourceTraversal[] resourceTraversalArray = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            int n = 0;
            while (n < resourceTraversalArray.length) {
                ResourceTraversal resourceTraversal = resourceTraversalArray[n];
                IResource[] iResourceArray = resourceTraversal.getResources();
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    collection.add(iResourceArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
    }

    boolean andFilters() {
        return this.andFilters;
    }

    void buildAllMarkers(IProgressMonitor iProgressMonitor) {
        this.building = true;
        try {
            iProgressMonitor.beginTask(MarkerMessages.MarkerView_19, 60);
            iProgressMonitor.subTask(MarkerMessages.MarkerView_waiting_on_changes);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            iProgressMonitor.subTask(MarkerMessages.MarkerView_searching_for_markers);
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
            MarkerMap markerMap = this.generator.generateFilteredMarkers(subProgressMonitor, this.andFilters(), this.focusResources, this.getEnabledFilters());
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            this.sortAndMakeCategories((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 30), markerMap);
            iProgressMonitor.done();
        }
        finally {
            this.building = false;
        }
    }

    MarkerCategory[] buildHierarchy(MarkerMap markerMap, int n, int n2, int n3) {
        MarkerComparator markerComparator = this.getComparator();
        if (n3 > 0) {
            return null;
        }
        ArrayList<MarkerCategory> arrayList = new ArrayList<MarkerCategory>();
        MarkerEntry markerEntry = null;
        int n4 = n;
        MarkerEntry[] markerEntryArray = markerMap.toArray();
        int n5 = n;
        while (n5 <= n2) {
            if (markerEntry != null && markerComparator.compareCategory(markerEntry, markerEntryArray[n5]) != 0) {
                arrayList.add(new MarkerCategory(this, n4, n5 - 1, this.getCategoryGroup().getMarkerField().getValue(markerMap.elementAt(n4))));
                n4 = n5;
            }
            markerEntry = markerEntryArray[n5];
            ++n5;
        }
        if (n2 >= n4) {
            arrayList.add(new MarkerCategory(this, n4, n2, this.getCategoryGroup().getMarkerField().getValue(markerMap.elementAt(n4))));
        }
        MarkerCategory[] markerCategoryArray = new MarkerCategory[arrayList.size()];
        arrayList.toArray(markerCategoryArray);
        return markerCategoryArray;
    }

    private void cancelJobs() {
        this.markerProcessJob.cancel();
        this.updateJob.cancel();
    }

    Collection createFilterConfigurationFields() {
        ArrayList<FilterConfigurationArea> arrayList = new ArrayList<FilterConfigurationArea>();
        int n = 0;
        while (n < this.visibleFields.length) {
            FilterConfigurationArea filterConfigurationArea = MarkerSupportInternalUtilities.generateFilterArea(this.visibleFields[n]);
            if (filterConfigurationArea != null) {
                arrayList.add(filterConfigurationArea);
            }
            ++n;
        }
        return arrayList;
    }

    private void createMarkerProcessJob() {
        this.markerProcessJob = new Job(MarkerMessages.MarkerView_processUpdates){

            public boolean belongsTo(Object object) {
                return MarkerContentGenerator.CACHE_UPDATE_FAMILY == object;
            }

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                CachedMarkerBuilder.this.updateJob.cancel();
                CachedMarkerBuilder.this.buildAllMarkers(iProgressMonitor);
                CachedMarkerBuilder.this.updateJob.schedule();
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                if (CachedMarkerBuilder.this.preBuildTime > 0L && System.currentTimeMillis() - CachedMarkerBuilder.this.preBuildTime < 30000L) {
                    return false;
                }
                CachedMarkerBuilder.this.preBuildTime = -1L;
                return IDEWorkbenchPlugin.getDefault().getBundle().getState() == 32;
            }
        };
        this.markerProcessJob.setSystem(true);
    }

    void disableAllFilters() {
        Collection collection = this.getEnabledFilters();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
            markerFieldFilterGroup.setEnabled(false);
        }
        collection.clear();
        this.writeFiltersPreference();
        this.scheduleMarkerUpdate();
    }

    void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
    }

    Collection getAllFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList();
            IConfigurationElement[] iConfigurationElementArray = this.generator.getFilterReferences();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.filters.add(new MarkerFieldFilterGroup(iConfigurationElementArray[n], this));
                ++n;
            }
            if (this.viewId.equals("org.eclipse.ui.views.ProblemView")) {
                Iterator iterator = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
                while (iterator.hasNext()) {
                    this.filters.add(new CompatibilityMarkerFieldFilterGroup((ProblemFilter)iterator.next(), this));
                }
            }
            this.loadFiltersPreference();
        }
        return this.filters;
    }

    public MarkerCategory[] getCategories() {
        if (this.building) {
            return null;
        }
        return this.categories;
    }

    MarkerGroup getCategoryGroup() {
        return this.categoryGroup;
    }

    MarkerComparator getComparator() {
        if (this.comparator == null) {
            MarkerField markerField = null;
            if (this.getCategoryGroup() != null) {
                markerField = this.getCategoryGroup().getMarkerField();
            }
            this.comparator = new MarkerComparator(markerField, this.generator.getAllFields());
            this.comparator.restore(this.memento);
        }
        return this.comparator;
    }

    MarkerSupportItem[] getElements() {
        if (this.refreshingMarkers()) {
            return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
        }
        if (this.isShowingHierarchy() && this.categories != null) {
            return this.categories;
        }
        return this.currentMap.toArray();
    }

    Collection getEnabledFilters() {
        if (this.enabledFilters == null) {
            this.enabledFilters = new HashSet();
            Iterator iterator = this.getAllFilters().iterator();
            while (iterator.hasNext()) {
                MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
                if (!markerFieldFilterGroup.isEnabled()) continue;
                this.enabledFilters.add(markerFieldFilterGroup);
            }
        }
        return this.enabledFilters;
    }

    MarkerContentGenerator getGenerator() {
        return this.generator;
    }

    Object[] getHiddenFields() {
        MarkerField[] markerFieldArray = this.getGenerator().getAllFields();
        MarkerField[] markerFieldArray2 = this.getVisibleFields();
        HashSet<MarkerField> hashSet = new HashSet<MarkerField>();
        int n = 0;
        while (n < markerFieldArray.length) {
            hashSet.add(markerFieldArray[n]);
            ++n;
        }
        n = 0;
        while (n < markerFieldArray2.length) {
            hashSet.remove(markerFieldArray2[n]);
            ++n;
        }
        return hashSet.toArray();
    }

    private String getLegacyFiltersPreferenceName() {
        if (this.viewId.equals("org.eclipse.ui.views.BookmarkView")) {
            return "BOOKMARKS_FILTERS";
        }
        if (this.viewId.equals("org.eclipse.ui.views.TaskList")) {
            return "TASKS_FILTERS";
        }
        return "PROBLEMS_FILTERS";
    }

    Integer[] getMarkerCounts() {
        if (this.currentMap == null) {
            return EMPTY_MARKER_COUNTS;
        }
        return this.currentMap.getMarkerCounts();
    }

    MarkerEntry[] getMarkerEntries() {
        if (this.refreshingMarkers()) {
            return EMPTY_ENTRY_ARRAY;
        }
        return this.currentMap.toArray();
    }

    MarkerItem getMarkerItem(IMarker iMarker) {
        if (this.refreshingMarkers()) {
            return null;
        }
        return this.currentMap.getMarkerItem(iMarker);
    }

    private String getMementoPreferenceName() {
        return String.valueOf(this.getClass().getName()) + this.viewId;
    }

    MarkerField getPrimarySortField() {
        return this.getComparator().getPrimarySortField();
    }

    int getSortDirection(MarkerField markerField) {
        if (this.getComparator().descendingFields.contains(markerField)) {
            return -1;
        }
        return 1;
    }

    int getTotalMarkerCount() {
        MarkerSupportItem[] markerSupportItemArray = this.getElements();
        if (markerSupportItemArray.length == 0 || markerSupportItemArray[0].isConcrete()) {
            return markerSupportItemArray.length;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < markerSupportItemArray.length) {
            n += markerSupportItemArray[n2].getChildren().length;
            ++n2;
        }
        return n;
    }

    private IResourceChangeListener getUpdateListener() {
        return new IResourceChangeListener(){

            private boolean hasMarkerDelta(IResourceChangeEvent iResourceChangeEvent) {
                Iterator iterator = CachedMarkerBuilder.this.generator.getMarkerTypes().iterator();
                while (iterator.hasNext()) {
                    MarkerType markerType = (MarkerType)iterator.next();
                    if (iResourceChangeEvent.findMarkerDeltas(markerType.getId(), true).length <= 0) continue;
                    return true;
                }
                return false;
            }

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                if (!this.hasMarkerDelta(iResourceChangeEvent)) {
                    return;
                }
                if (iResourceChangeEvent.getType() == 8) {
                    CachedMarkerBuilder.this.preBuild();
                    return;
                }
                if (iResourceChangeEvent.getType() == 16) {
                    CachedMarkerBuilder.this.postBuild();
                    CachedMarkerBuilder.this.scheduleMarkerUpdate();
                    return;
                }
                if (CachedMarkerBuilder.this.progressService == null) {
                    CachedMarkerBuilder.this.markerProcessJob.schedule(30000L);
                } else {
                    CachedMarkerBuilder.this.progressService.schedule(CachedMarkerBuilder.this.markerProcessJob, 30000L);
                }
            }
        };
    }

    MarkerField[] getVisibleFields() {
        return this.visibleFields;
    }

    boolean hasNoMarkers() {
        return this.currentMap == null;
    }

    private void initialiseVisibleFields(IMemento iMemento) {
        if (iMemento == null || iMemento.getChildren(TAG_COLUMN_VISIBILITY).length == 0) {
            MarkerField[] markerFieldArray = this.getGenerator().getInitialVisible();
            this.visibleFields = new MarkerField[markerFieldArray.length];
            System.arraycopy(markerFieldArray, 0, this.visibleFields, 0, markerFieldArray.length);
            return;
        }
        IMemento[] iMementoArray = iMemento.getChildren(TAG_COLUMN_VISIBILITY);
        ArrayList arrayList = new ArrayList();
        MarkerField[] markerFieldArray = this.getGenerator().getAllFields();
        Hashtable<String, MarkerField> hashtable = new Hashtable<String, MarkerField>();
        int n = 0;
        while (n < markerFieldArray.length) {
            hashtable.put(markerFieldArray[n].getConfigurationElement().getAttribute("id"), markerFieldArray[n]);
            ++n;
        }
        n = 0;
        while (n < iMementoArray.length) {
            String string = iMementoArray[n].getID();
            if (hashtable.containsKey(string)) {
                arrayList.add(hashtable.get(string));
            }
            ++n;
        }
        this.visibleFields = new MarkerField[arrayList.size()];
        arrayList.toArray(this.visibleFields);
    }

    private void initializePreferenceListener() {
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals(CachedMarkerBuilder.this.getMementoPreferenceName())) {
                    CachedMarkerBuilder.this.rebuildFilters();
                }
            }
        };
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
    }

    public boolean isBuilding() {
        return this.building;
    }

    boolean isShowingHierarchy() {
        return this.categoryGroup != null;
    }

    private void loadFilterSettings(IMemento iMemento) {
        if (iMemento == null) {
            return;
        }
        Boolean bl = iMemento.getBoolean(TAG_AND);
        if (bl != null) {
            this.setAndFilters(bl);
        }
        IMemento[] iMementoArray = iMemento.getChildren(TAG_GROUP_ENTRY);
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento2 = iMementoArray[n];
            String string = iMemento2.getString("IMemento.internal.id");
            if (string != null && !this.loadGroupWithID(iMemento2, string)) {
                this.loadUserFilter(iMemento2);
            }
            ++n;
        }
    }

    private void loadFiltersFrom(String string) {
        if (string.equals("")) {
            return;
        }
        try {
            this.loadFilterSettings((IMemento)XMLMemento.createReadRoot((Reader)new StringReader(string)));
        }
        catch (WorkbenchException workbenchException) {
            StatusManager.getManager().handle(workbenchException.getStatus());
        }
    }

    private void loadFiltersPreference() {
        this.loadFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(this.getMementoPreferenceName()));
        String string = this.getLegacyFiltersPreferenceName();
        String string2 = String.valueOf(string) + "_MIGRATE";
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(string2)) {
            return;
        }
        this.loadLegacyFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(string));
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(string2, true);
    }

    private boolean loadGroupWithID(IMemento iMemento, String string) {
        Iterator iterator = this.getAllFilters().iterator();
        while (iterator.hasNext()) {
            MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
            if (!string.equals(markerFieldFilterGroup.getID())) continue;
            markerFieldFilterGroup.loadSettings(iMemento);
            return true;
        }
        return false;
    }

    private void loadLegacyFilter(IMemento iMemento) {
        MarkerFieldFilterGroup markerFieldFilterGroup = new MarkerFieldFilterGroup(null, this);
        markerFieldFilterGroup.legacyLoadSettings(iMemento);
        this.getAllFilters().add(markerFieldFilterGroup);
    }

    private void loadLegacyFiltersFrom(String string) {
        if (string.equals("")) {
            return;
        }
        try {
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)new StringReader(string));
            this.restoreLegacyFilters((IMemento)xMLMemento);
        }
        catch (WorkbenchException workbenchException) {
            StatusManager.getManager().handle(workbenchException.getStatus());
            return;
        }
    }

    private void loadUserFilter(IMemento iMemento) {
        MarkerFieldFilterGroup markerFieldFilterGroup = new MarkerFieldFilterGroup(null, this);
        markerFieldFilterGroup.loadSettings(iMemento);
        this.getAllFilters().add(markerFieldFilterGroup);
    }

    protected void postBuild() {
        this.preBuildTime = -1L;
    }

    protected void preBuild() {
        this.preBuildTime = System.currentTimeMillis();
    }

    protected void rebuildFilters() {
        this.filters = null;
        this.enabledFilters = null;
        this.scheduleMarkerUpdate();
    }

    void refreshContents(IWorkbenchSiteProgressService iWorkbenchSiteProgressService) {
        try {
            iWorkbenchSiteProgressService.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    if (CachedMarkerBuilder.this.refreshingMarkers()) {
                        return;
                    }
                    CachedMarkerBuilder.this.sortAndMakeCategories(iProgressMonitor, CachedMarkerBuilder.this.currentMap);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException));
        }
        catch (InterruptedException interruptedException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, interruptedException.getLocalizedMessage(), (Throwable)interruptedException));
        }
    }

    private boolean refreshingMarkers() {
        if (this.currentMap == null) {
            this.scheduleMarkerUpdate();
            return true;
        }
        return this.building;
    }

    private void restoreLegacyFilters(IMemento iMemento) {
        IMemento[] iMementoArray = null;
        if (iMemento != null) {
            iMementoArray = iMemento.getChildren(TAG_LEGACY_FILTER_ENTRY);
        }
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento2 = iMementoArray[n];
            String string = iMemento2.getString("IMemento.internal.id");
            if (string != null) {
                this.loadLegacyFilter(iMemento2);
            }
            ++n;
        }
    }

    void saveState(IMemento iMemento, MarkerField[] markerFieldArray) {
        this.getComparator().saveState(iMemento);
        if (this.categoryGroup == null) {
            iMemento.putString(TAG_CATEGORY_GROUP, VALUE_NONE);
        } else {
            iMemento.putString(TAG_CATEGORY_GROUP, this.getCategoryGroup().getId());
        }
        int n = 0;
        while (n < markerFieldArray.length) {
            iMemento.createChild(TAG_COLUMN_VISIBILITY, markerFieldArray[n].getConfigurationElement().getAttribute("id"));
            ++n;
        }
    }

    public void scheduleMarkerUpdate() {
        this.cancelJobs();
        this.currentMap = null;
        this.building = true;
        if (this.progressService != null) {
            this.progressService.schedule(this.markerProcessJob, 100L);
        } else {
            this.markerProcessJob.schedule(100L);
        }
    }

    void setAndFilters(boolean bl) {
        this.andFilters = bl;
    }

    void setCategoryGroup(MarkerGroup markerGroup) {
        this.categoryGroup = markerGroup;
        if (markerGroup == null) {
            this.getComparator().setCategory(null);
        } else {
            this.getComparator().setCategory(markerGroup.getMarkerField());
        }
        this.scheduleMarkerUpdate();
    }

    private void setDefaultCategoryGroup(MarkerContentGenerator markerContentGenerator) {
        MarkerGroup markerGroup;
        String string = markerContentGenerator.getCategoryName();
        if (string != null && (markerGroup = markerContentGenerator.getMarkerGroup(string)) != null) {
            this.categoryGroup = markerGroup;
        }
    }

    void setGenerator(MarkerContentGenerator markerContentGenerator) {
        this.generator = markerContentGenerator;
        this.scheduleMarkerUpdate();
    }

    void setPrimarySortField(MarkerField markerField) {
        this.getComparator().setPrimarySortField(markerField);
    }

    void setProgressService(IWorkbenchSiteProgressService iWorkbenchSiteProgressService) {
        this.progressService = iWorkbenchSiteProgressService;
        if (iWorkbenchSiteProgressService != null) {
            iWorkbenchSiteProgressService.showBusyForFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            iWorkbenchSiteProgressService.showBusyForFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
            iWorkbenchSiteProgressService.showBusyForFamily(MarkerContentGenerator.CACHE_UPDATE_FAMILY);
        }
    }

    public void setUpdateJob(Job job) {
        this.updateJob = job;
    }

    void sortAndMakeCategories(IProgressMonitor iProgressMonitor, MarkerMap markerMap) {
        Arrays.sort(markerMap.toArray(), this.getComparator());
        iProgressMonitor.worked(50);
        if (markerMap.getSize() == 0) {
            this.categories = EMPTY_CATEGORY_ARRAY;
            this.currentMap = markerMap;
            iProgressMonitor.done();
            return;
        }
        iProgressMonitor.subTask(MarkerMessages.MarkerView_queueing_updates);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (this.isShowingHierarchy()) {
            MarkerCategory[] markerCategoryArray = this.buildHierarchy(markerMap, 0, markerMap.getSize() - 1, 0);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            this.categories = markerCategoryArray;
        }
        iProgressMonitor.worked(50);
        this.currentMap = markerMap;
        this.currentMap.clearAttributeCaches();
    }

    void toggleFilter(MarkerFieldFilterGroup markerFieldFilterGroup) {
        Collection collection = this.getEnabledFilters();
        if (collection.remove(markerFieldFilterGroup)) {
            markerFieldFilterGroup.setEnabled(false);
        } else {
            markerFieldFilterGroup.setEnabled(true);
            collection.add(markerFieldFilterGroup);
        }
        this.writeFiltersPreference();
        this.scheduleMarkerUpdate();
    }

    void updateFocusElements(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IResource) {
                arrayList.add(objectArray[n]);
            } else {
                this.addResources(arrayList, (ResourceMapping)objectArray[n]);
            }
            ++n;
        }
        this.focusResources = new IResource[arrayList.size()];
        arrayList.toArray(this.focusResources);
    }

    void updateForNewSelection(Object[] objectArray) {
        if (this.updateNeeded(objectArray)) {
            this.updateFocusElements(objectArray);
            this.scheduleMarkerUpdate();
        }
    }

    void updateFrom(FiltersConfigurationDialog filtersConfigurationDialog) {
        this.setAndFilters(filtersConfigurationDialog.andFilters());
        this.filters = filtersConfigurationDialog.getFilters();
        this.enabledFilters = null;
        this.writeFiltersPreference();
        this.scheduleMarkerUpdate();
    }

    boolean updateNeeded(Object[] objectArray) {
        Iterator iterator = this.getEnabledFilters().iterator();
        while (iterator.hasNext()) {
            MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
            int n = markerFieldFilterGroup.getScope();
            if (n == 0 || n == 4 || objectArray == null || objectArray.length < 1) continue;
            if (this.focusResources.length == 0) {
                return true;
            }
            if (Arrays.equals(this.focusResources, objectArray)) continue;
            if (n == 3) {
                Collection collection = MarkerFieldFilterGroup.getProjectsAsCollection(this.focusResources);
                Collection collection2 = MarkerFieldFilterGroup.getProjectsAsCollection(objectArray);
                if (collection.size() == collection2.size() && collection2.containsAll(collection)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void writeFiltersPreference() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)TAG_FILTERS_SECTION);
        this.writeFiltersSettings(xMLMemento);
        StringWriter stringWriter = new StringWriter();
        try {
            xMLMemento.save((Writer)stringWriter);
        }
        catch (IOException iOException) {
            IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(iOException));
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().putValue(this.getMementoPreferenceName(), stringWriter.toString());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
    }

    private void writeFiltersSettings(XMLMemento xMLMemento) {
        xMLMemento.putBoolean(TAG_AND, this.andFilters);
        Iterator iterator = this.getAllFilters().iterator();
        while (iterator.hasNext()) {
            MarkerFieldFilterGroup markerFieldFilterGroup = (MarkerFieldFilterGroup)iterator.next();
            IMemento iMemento = xMLMemento.createChild(TAG_GROUP_ENTRY, markerFieldFilterGroup.getID());
            markerFieldFilterGroup.saveFilterSettings(iMemento);
        }
    }

    void setVisibleFields(Collection collection) {
        MarkerField[] markerFieldArray = new MarkerField[collection.size()];
        collection.toArray(markerFieldArray);
        this.visibleFields = markerFieldArray;
    }
}

