/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.views.markers.CompletionFieldFilter;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class CompletionConfigurationArea
extends FilterConfigurationArea {
    private Button completeButton;
    private Button incompleteButton;
    int completionState;

    public void apply(MarkerFieldFilter markerFieldFilter) {
        ((CompletionFieldFilter)markerFieldFilter).setCompletion(this.completionState);
    }

    public void createContents(Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.completeButton = new Button(composite, 32);
        this.completeButton.setText(MarkerMessages.filtersDialog_statusComplete);
        this.completeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CompletionConfigurationArea.this.updateCompletion(2, CompletionConfigurationArea.this.completeButton.getSelection());
            }
        });
        this.incompleteButton = new Button(composite, 32);
        this.incompleteButton.setText(MarkerMessages.filtersDialog_statusIncomplete);
        this.incompleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CompletionConfigurationArea.this.updateCompletion(1, CompletionConfigurationArea.this.incompleteButton.getSelection());
            }
        });
    }

    void updateCompletion(int n, boolean bl) {
        this.completionState = bl ? n | this.completionState : n ^ this.completionState;
    }

    public void initialize(MarkerFieldFilter markerFieldFilter) {
        this.completionState = ((CompletionFieldFilter)markerFieldFilter).getCompletion();
        this.completeButton.setSelection((2 & this.completionState) > 0);
        this.incompleteButton.setSelection((1 & this.completionState) > 0);
    }

    public String getTitle() {
        return MarkerMessages.filtersDialog_completionTitle;
    }
}

