/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class CompletionFieldFilter
extends CompatibilityFieldFilter {
    static final int COMPLETED = 2;
    static final int NOT_COMPLETED = 1;
    private static int ALL_SELECTED = 3;
    private int completion = ALL_SELECTED;
    private static String COMPLETION_ATTRIBUTE = "completion";

    public void loadSettings(IMemento iMemento) {
        Integer n = iMemento.getInteger(COMPLETION_ATTRIBUTE);
        if (n == null) {
            return;
        }
        this.completion = n;
    }

    void loadLegacySettings(IMemento iMemento, MarkerContentGenerator markerContentGenerator) {
        String string = iMemento.getString("done");
        if (string != null) {
            this.completion = Boolean.valueOf(string) != false ? 2 : 1;
        }
    }

    public void initialize(ProblemFilter problemFilter) {
    }

    public void saveSettings(IMemento iMemento) {
        iMemento.putInteger(COMPLETION_ATTRIBUTE, this.completion);
    }

    public boolean select(MarkerItem markerItem) {
        if (this.completion == ALL_SELECTED) {
            return true;
        }
        if (markerItem.getAttributeValue("userEditable", true)) {
            if (markerItem.getAttributeValue("done", false)) {
                return (this.completion & 2) > 0;
            }
            return (this.completion & 1) > 0;
        }
        return false;
    }

    int getCompletion() {
        return this.completion;
    }

    void setCompletion(int n) {
        this.completion = n;
    }

    public void populateWorkingCopy(MarkerFieldFilter markerFieldFilter) {
        super.populateWorkingCopy(markerFieldFilter);
        ((CompletionFieldFilter)markerFieldFilter).setCompletion(this.getCompletion());
    }
}

